/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.FileSystemOperationUnhandledException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidFileSystemPropertyException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriAuthorityException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TrileanConversionException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformerInterface;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.security.ContextProviderEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.security.NoContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsAclHelper;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContextBuilder;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientRenameResult;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatisticsImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatisticsImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsPermission;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.ListingSupport;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.services.StaticRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.CRC64;
import org.apache.hadoop.fs.azurebfs.utils.DateTimeUtils;
import org.apache.hadoop.fs.azurebfs.utils.EncryptionType;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.impl.BackReference;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AzureBlobFileSystemStore
implements Closeable,
ListingSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobFileSystemStore.class);
    private AbfsClient client;
    private AbfsClientHandler clientHandler;
    private URI uri;
    private String userName;
    private String primaryUserGroup;
    private static final String TOKEN_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";
    private static final String XMS_PROPERTIES_ENCODING = "ISO-8859-1";
    private static final int GET_SET_AGGREGATE_COUNT = 2;
    private final Map<AbfsLease, Object> leaseRefs;
    private final AbfsConfiguration abfsConfiguration;
    private Set<String> azureInfiniteLeaseDirSet;
    private volatile Trilean isNamespaceEnabled;
    private final AuthType authType;
    private final UserGroupInformation userGroupInformation;
    private final IdentityTransformerInterface identityTransformer;
    private final AbfsPerfTracker abfsPerfTracker;
    private final AbfsCounters abfsCounters;
    private Set<String> appendBlobDirSet;
    private DataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private ExecutorService boundedThreadPool;
    private BackReference fsBackRef;

    public AzureBlobFileSystemStore(AzureBlobFileSystemStoreBuilder abfsStoreBuilder) throws IOException {
        this.uri = abfsStoreBuilder.uri;
        String[] authorityParts = this.authorityParts(this.uri);
        String fileSystemName = authorityParts[0];
        String accountName = authorityParts[1];
        this.fsBackRef = abfsStoreBuilder.fsBackRef;
        this.leaseRefs = Collections.synchronizedMap(new WeakHashMap());
        try {
            this.abfsConfiguration = new AbfsConfiguration(abfsStoreBuilder.configuration, accountName, fileSystemName, this.getAbfsServiceTypeFromUrl());
        }
        catch (IllegalAccessException exception) {
            throw new FileSystemOperationUnhandledException(exception);
        }
        LOG.trace("AbfsConfiguration init complete");
        this.isNamespaceEnabled = this.abfsConfiguration.getIsNamespaceEnabledAccount();
        this.userGroupInformation = UserGroupInformation.getCurrentUser();
        this.userName = this.userGroupInformation.getShortUserName();
        LOG.trace("UGI init complete");
        if (!this.abfsConfiguration.getSkipUserGroupMetadataDuringInitialization()) {
            try {
                this.primaryUserGroup = this.userGroupInformation.getPrimaryGroupName();
            }
            catch (IOException ex) {
                LOG.error("Failed to get primary group for {}, using user name as primary group name", (Object)this.userName);
                this.primaryUserGroup = this.userName;
            }
        } else {
            this.primaryUserGroup = this.userName;
        }
        LOG.trace("primaryUserGroup is {}", (Object)this.primaryUserGroup);
        this.updateInfiniteLeaseDirs();
        this.authType = this.abfsConfiguration.getAuthType(accountName);
        boolean usingOauth = this.authType == AuthType.OAuth;
        boolean useHttps = usingOauth || this.abfsConfiguration.isHttpsAlwaysUsed() ? true : abfsStoreBuilder.isSecureScheme;
        this.abfsPerfTracker = new AbfsPerfTracker(fileSystemName, accountName, this.abfsConfiguration);
        this.abfsCounters = abfsStoreBuilder.abfsCounters;
        this.initializeClient(this.uri, fileSystemName, accountName, useHttps);
        Class<IdentityTransformerInterface> identityTransformerClass = abfsStoreBuilder.configuration.getClass("fs.azure.identity.transformer.class", IdentityTransformer.class, IdentityTransformerInterface.class);
        try {
            this.identityTransformer = identityTransformerClass.getConstructor(Configuration.class).newInstance(abfsStoreBuilder.configuration);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
        LOG.trace("IdentityTransformer init complete");
        String appendBlobDirs = this.abfsConfiguration.getAppendBlobDirs();
        this.appendBlobDirSet = appendBlobDirs.trim().isEmpty() ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAppendBlobDirs().split(",")));
        this.blockFactory = abfsStoreBuilder.blockFactory;
        this.blockOutputActiveBlocks = abfsStoreBuilder.blockOutputActiveBlocks;
        this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance(this.abfsConfiguration.getWriteMaxConcurrentRequestCount(), this.abfsConfiguration.getMaxWriteRequestsToQueue(), 10L, TimeUnit.SECONDS, "abfs-bounded");
    }

    public void updateClientWithNamespaceInfo(TracingContext tracingContext) throws AzureBlobFileSystemException {
        boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
        AbfsClient.setIsNamespaceEnabled(isNamespaceEnabled);
    }

    public boolean isAppendBlobKey(String key) {
        return UriUtils.isKeyForDirectorySet(key, this.appendBlobDirSet);
    }

    public String getUser() {
        return this.userName;
    }

    public String getPrimaryGroup() {
        return this.primaryUserGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        ArrayList futures = new ArrayList();
        for (AbfsLease lease : this.leaseRefs.keySet()) {
            if (lease == null) continue;
            ListenableFuture<?> future = this.getClient().submit(() -> lease.free());
            futures.add(future);
        }
        try {
            Futures.allAsList(futures).get();
            HadoopExecutors.shutdown(this.boundedThreadPool, LOG, 30L, TimeUnit.SECONDS);
            this.boundedThreadPool = null;
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted freeing leases", e);
            Thread.currentThread().interrupt();
            IOUtils.cleanupWithLogger(LOG, this.getClient());
        }
        catch (ExecutionException e2) {
            LOG.error("Error freeing leases", e2);
            {
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger(LOG, this.getClient());
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger(LOG, this.getClient());
        }
        IOUtils.cleanupWithLogger(LOG, this.getClient());
    }

    byte[] encodeAttribute(String value) throws UnsupportedEncodingException {
        return this.getClient().encodeAttribute(value);
    }

    String decodeAttribute(byte[] value) throws UnsupportedEncodingException {
        return this.getClient().decodeAttribute(value);
    }

    private String[] authorityParts(URI uri) throws InvalidUriAuthorityException, InvalidUriException {
        String authority = uri.getRawAuthority();
        if (null == authority) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        if (!authority.contains("@")) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        String[] authorityParts = authority.split("@", 2);
        if (authorityParts.length < 2 || authorityParts[0] != null && authorityParts[0].isEmpty()) {
            String errMsg = String.format("'%s' has a malformed authority, expected container name. Authority takes the form abfs://[<container name>@]<account name>", uri.toString());
            throw new InvalidUriException(errMsg);
        }
        return authorityParts;
    }

    public boolean getIsNamespaceEnabled(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try {
            return this.isNamespaceEnabled();
        }
        catch (TrileanConversionException e) {
            LOG.debug("isNamespaceEnabled is UNKNOWN; fall back and determine through getAcl server call", e);
            return this.getNamespaceEnabledInformationFromServer(tracingContext);
        }
    }

    private synchronized boolean getNamespaceEnabledInformationFromServer(TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (this.isNamespaceEnabled != Trilean.UNKNOWN) {
            return this.isNamespaceEnabled.toBoolean();
        }
        try {
            LOG.debug("Get root ACL status");
            this.getClient(AbfsServiceType.DFS).getAclStatus("/", tracingContext);
            this.isNamespaceEnabled = Trilean.getTrilean(true);
        }
        catch (AbfsRestOperationException ex) {
            if (400 != ex.getStatusCode()) {
                this.isNamespaceEnabled = Trilean.getTrilean(true);
                LOG.debug("Failed to get ACL status with non 400. Inferring namespace enabled", ex);
                throw ex;
            }
            LOG.debug("Failed to get ACL status with 400. Inferring namespace disabled and ignoring error", ex);
            this.isNamespaceEnabled = Trilean.getTrilean(false);
        }
        catch (AzureBlobFileSystemException ex) {
            throw ex;
        }
        return this.isNamespaceEnabled.toBoolean();
    }

    @VisibleForTesting
    boolean isNamespaceEnabled() throws TrileanConversionException {
        return this.isNamespaceEnabled.toBoolean();
    }

    @VisibleForTesting
    URIBuilder getURIBuilder(String hostName, boolean isSecure) {
        String scheme = isSecure ? "https" : "http";
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(scheme);
        String endPoint = this.abfsConfiguration.get("fs.azure.abfs.endpoint");
        if (endPoint == null || !endPoint.contains(":")) {
            uriBuilder.setHost(hostName);
            return uriBuilder;
        }
        String[] data = endPoint.split(":");
        if (data.length != 2) {
            throw new RuntimeException(String.format("ABFS endpoint is not set correctly : %s, Do not specify scheme when using {IP}:{PORT}", endPoint));
        }
        uriBuilder.setHost(data[0].trim());
        uriBuilder.setPort(Integer.parseInt(data[1].trim()));
        uriBuilder.setPath("/" + UriUtils.extractAccountNameFromHostName(hostName));
        return uriBuilder;
    }

    public AbfsConfiguration getAbfsConfiguration() {
        return this.abfsConfiguration;
    }

    public Hashtable<String, String> getFilesystemProperties(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getFilesystemProperties", "getFilesystemProperties");){
            LOG.debug("getFilesystemProperties for filesystem: {}", (Object)this.getClient().getFileSystem());
            AbfsRestOperation op = this.getClient().getFilesystemProperties(tracingContext);
            perfInfo.registerResult(op.getResult());
            Hashtable<String, String> parsedXmsProperties = this.getClient().getXMSProperties(op.getResult());
            perfInfo.registerSuccess(true);
            Hashtable<String, String> hashtable = parsedXmsProperties;
            return hashtable;
        }
    }

    public void setFilesystemProperties(Hashtable<String, String> properties, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (properties == null || properties.isEmpty()) {
            LOG.trace("setFilesystemProperties no properties present");
            return;
        }
        LOG.debug("setFilesystemProperties for filesystem: {} with properties: {}", (Object)this.getClient().getFileSystem(), (Object)properties);
        try (AbfsPerfInfo perfInfo = this.startTracking("setFilesystemProperties", "setFilesystemProperties");){
            AbfsRestOperation op = this.getClient().setFilesystemProperties(properties, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public Hashtable<String, String> getPathStatus(Path path, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getPathStatus", "getPathStatus");){
            LOG.debug("getPathStatus for filesystem: {} path: {}", (Object)this.getClient().getFileSystem(), (Object)path);
            String relativePath = this.getRelativePath(path);
            ContextEncryptionAdapter contextEncryptionAdapter = this.createEncryptionAdapterFromServerStoreContext(relativePath, tracingContext);
            AbfsRestOperation op = this.getClient().getPathStatus(relativePath, true, tracingContext, contextEncryptionAdapter);
            perfInfo.registerResult(op.getResult());
            contextEncryptionAdapter.destroy();
            Hashtable<String, String> parsedXmsProperties = this.getClient().getXMSProperties(op.getResult());
            perfInfo.registerSuccess(true);
            Hashtable<String, String> hashtable = parsedXmsProperties;
            return hashtable;
        }
    }

    private ContextEncryptionAdapter createEncryptionAdapterFromServerStoreContext(String path, TracingContext tracingContext) throws IOException {
        if (this.getClient().getEncryptionType() != EncryptionType.ENCRYPTION_CONTEXT) {
            return NoContextEncryptionAdapter.getInstance();
        }
        String responseHeaderEncryptionContext = this.getClient().getPathStatus(path, false, tracingContext, null).getResult().getResponseHeader("x-ms-encryption-context");
        if (responseHeaderEncryptionContext == null) {
            throw new PathIOException(path, "EncryptionContext not present in GetPathStatus response");
        }
        byte[] encryptionContext = responseHeaderEncryptionContext.getBytes(StandardCharsets.UTF_8);
        try {
            return new ContextProviderEncryptionAdapter(this.getClient().getEncryptionContextProvider(), new Path(path).toUri().getPath(), encryptionContext);
        }
        catch (IOException e) {
            LOG.debug("Could not initialize EncryptionAdapter");
            throw e;
        }
    }

    public void setPathProperties(Path path, Hashtable<String, String> properties, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("setPathProperties", "setPathProperties");){
            LOG.debug("setPathProperties for filesystem: {} path: {} with properties: {}", this.getClient().getFileSystem(), path, properties);
            String relativePath = this.getRelativePath(path);
            ContextEncryptionAdapter contextEncryptionAdapter = this.createEncryptionAdapterFromServerStoreContext(relativePath, tracingContext);
            AbfsRestOperation op = this.getClient().setPathProperties(this.getRelativePath(path), properties, tracingContext, contextEncryptionAdapter);
            contextEncryptionAdapter.destroy();
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void createFilesystem(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createFilesystem", "createFilesystem");){
            LOG.debug("createFilesystem for filesystem: {}", (Object)this.getClient().getFileSystem());
            AbfsRestOperation op = this.getClient().createFilesystem(tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void deleteFilesystem(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("deleteFilesystem", "deleteFilesystem");){
            LOG.debug("deleteFilesystem for filesystem: {}", (Object)this.getClient().getFileSystem());
            AbfsRestOperation op = this.getClient().deleteFilesystem(tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public OutputStream createNonRecursive(Path path, FileSystem.Statistics statistics, boolean overwrite, FsPermission permission, FsPermission umask, TracingContext tracingContext) throws IOException {
        LOG.debug("CreateNonRecursive for filesystem: {} path: {} overwrite: {} permission: {} umask: {}", this.getClient().getFileSystem(), path, overwrite, permission, umask);
        this.getClient().createNonRecursivePreCheck(path.getParent(), tracingContext);
        return this.createFile(path, statistics, overwrite, permission, umask, tracingContext);
    }

    public OutputStream createFile(Path path, FileSystem.Statistics statistics, boolean overwrite, FsPermission permission, FsPermission umask, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createFile", "createPath");){
            AbfsClient createClient = this.getClientHandler().getIngressClient();
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
            LOG.debug("createFile filesystem: {} path: {} overwrite: {} permission: {} umask: {} isNamespaceEnabled: {}", createClient.getFileSystem(), path, overwrite, permission, umask, isNamespaceEnabled);
            String relativePath = this.getRelativePath(path);
            boolean isAppendBlob = false;
            if (this.isAppendBlobKey(path.toString())) {
                isAppendBlob = true;
            }
            boolean triggerConditionalCreateOverwrite = false;
            if (overwrite && this.abfsConfiguration.isConditionalCreateOverwriteEnabled()) {
                triggerConditionalCreateOverwrite = true;
            }
            ContextEncryptionAdapter contextEncryptionAdapter = createClient.getEncryptionType() == EncryptionType.ENCRYPTION_CONTEXT ? new ContextProviderEncryptionAdapter(createClient.getEncryptionContextProvider(), this.getRelativePath(path)) : NoContextEncryptionAdapter.getInstance();
            AbfsRestOperation op = triggerConditionalCreateOverwrite ? this.conditionalCreateOverwriteFile(relativePath, statistics, new Permissions(isNamespaceEnabled, permission, umask), isAppendBlob, contextEncryptionAdapter, tracingContext) : createClient.createPath(relativePath, true, overwrite, new Permissions(isNamespaceEnabled, permission, umask), isAppendBlob, null, contextEncryptionAdapter, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
            AbfsLease lease = this.maybeCreateLease(relativePath, tracingContext);
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            AbfsOutputStream abfsOutputStream = new AbfsOutputStream(this.populateAbfsOutputStreamContext(isAppendBlob, lease, this.getClientHandler(), statistics, relativePath, 0L, eTag, contextEncryptionAdapter, tracingContext));
            return abfsOutputStream;
        }
    }

    private AbfsRestOperation conditionalCreateOverwriteFile(String relativePath, FileSystem.Statistics statistics, Permissions permissions, boolean isAppendBlob, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) throws IOException {
        AbfsClient createClient = this.getClientHandler().getIngressClient();
        AbfsRestOperation op = createClient.conditionalCreateOverwriteFile(relativePath, statistics, permissions, isAppendBlob, contextEncryptionAdapter, tracingContext);
        return op;
    }

    private AbfsOutputStreamContext populateAbfsOutputStreamContext(boolean isAppendBlob, AbfsLease lease, AbfsClientHandler clientHandler, FileSystem.Statistics statistics, String path, long position, String eTag, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) {
        int bufferSize = this.abfsConfiguration.getWriteBufferSize();
        if (isAppendBlob && bufferSize > 0x400000) {
            bufferSize = 0x400000;
        }
        return new AbfsOutputStreamContext(this.abfsConfiguration.getSasTokenRenewPeriodForStreamsInSeconds()).withWriteBufferSize(bufferSize).enableExpectHeader(this.abfsConfiguration.isExpectHeaderEnabled()).enableFlush(this.abfsConfiguration.isFlushEnabled()).enableSmallWriteOptimization(this.abfsConfiguration.isSmallWriteOptimizationEnabled()).disableOutputStreamFlush(this.abfsConfiguration.isOutputStreamFlushDisabled()).withStreamStatistics(new AbfsOutputStreamStatisticsImpl()).withAppendBlob(isAppendBlob).withWriteMaxConcurrentRequestCount(this.abfsConfiguration.getWriteMaxConcurrentRequestCount()).withMaxWriteRequestsToQueue(this.abfsConfiguration.getMaxWriteRequestsToQueue()).withLease(lease).withEncryptionAdapter(contextEncryptionAdapter).withBlockFactory(this.getBlockFactory()).withBlockOutputActiveBlocks(this.blockOutputActiveBlocks).withClientHandler(clientHandler).withPosition(position).withFsStatistics(statistics).withPath(path).withExecutorService(new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true)).withTracingContext(tracingContext).withAbfsBackRef(this.fsBackRef).withIngressServiceType(this.abfsConfiguration.getIngressServiceType()).withDFSToBlobFallbackEnabled(this.abfsConfiguration.isDfsToBlobFallbackEnabled()).withETag(eTag).build();
    }

    public void createDirectory(Path path, FsPermission permission, FsPermission umask, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createDirectory", "createPath");){
            AbfsClient createClient = this.getClientHandler().getIngressClient();
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
            LOG.debug("createDirectory filesystem: {} path: {} permission: {} umask: {} isNamespaceEnabled: {}", createClient.getFileSystem(), path, permission, umask, isNamespaceEnabled);
            boolean overwrite = !isNamespaceEnabled || this.abfsConfiguration.isEnabledMkdirOverwrite();
            Permissions permissions = new Permissions(isNamespaceEnabled, permission, umask);
            AbfsRestOperation op = createClient.createPath(this.getRelativePath(path), false, overwrite, permissions, false, null, null, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public AbfsInputStream openFileForRead(Path path, FileSystem.Statistics statistics, TracingContext tracingContext) throws IOException {
        return this.openFileForRead(path, Optional.empty(), statistics, tracingContext);
    }

    public AbfsInputStream openFileForRead(Path path, Optional<OpenFileParameters> parameters, FileSystem.Statistics statistics, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("openFileForRead", "getPathStatus");){
            String eTag;
            long contentLength;
            String resourceType;
            LOG.debug("openFileForRead filesystem: {} path: {}", (Object)this.getClient().getFileSystem(), (Object)path);
            FileStatus fileStatus = parameters.map(OpenFileParameters::getStatus).orElse(null);
            String relativePath = this.getRelativePath(path);
            ContextEncryptionAdapter contextEncryptionAdapter = NoContextEncryptionAdapter.getInstance();
            if (fileStatus instanceof VersionedFileStatus && (this.getClient().getEncryptionType() != EncryptionType.ENCRYPTION_CONTEXT || ((VersionedFileStatus)fileStatus).getEncryptionContext() != null)) {
                path = path.makeQualified(this.uri, path);
                Preconditions.checkArgument(fileStatus.getPath().equals(path), String.format("Filestatus path [%s] does not match with given path [%s]", fileStatus.getPath(), path));
                resourceType = fileStatus.isFile() ? "file" : "directory";
                contentLength = fileStatus.getLen();
                eTag = ((VersionedFileStatus)fileStatus).getVersion();
                String encryptionContext = ((VersionedFileStatus)fileStatus).getEncryptionContext();
                if (this.getClient().getEncryptionType() == EncryptionType.ENCRYPTION_CONTEXT) {
                    contextEncryptionAdapter = new ContextProviderEncryptionAdapter(this.getClient().getEncryptionContextProvider(), this.getRelativePath(path), encryptionContext.getBytes(StandardCharsets.UTF_8));
                }
            } else {
                AbfsHttpOperation op = this.getClient().getPathStatus(relativePath, false, tracingContext, null).getResult();
                resourceType = this.getClient().checkIsDir(op) ? "directory" : "file";
                contentLength = this.extractContentLength(op);
                eTag = op.getResponseHeader("ETag");
                if (this.getClient().getEncryptionType() == EncryptionType.ENCRYPTION_CONTEXT) {
                    String fileEncryptionContext = op.getResponseHeader("x-ms-encryption-context");
                    if (fileEncryptionContext == null) {
                        LOG.debug("EncryptionContext missing in GetPathStatus response");
                        throw new PathIOException(path.toString(), "EncryptionContext not present in GetPathStatus response headers");
                    }
                    contextEncryptionAdapter = new ContextProviderEncryptionAdapter(this.getClient().getEncryptionContextProvider(), this.getRelativePath(path), fileEncryptionContext.getBytes(StandardCharsets.UTF_8));
                }
            }
            if (this.parseIsDirectory(resourceType)) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
            }
            perfInfo.registerSuccess(true);
            AbfsInputStream abfsInputStream = new AbfsInputStream(this.getClient(), statistics, relativePath, contentLength, this.populateAbfsInputStreamContext(parameters.map(OpenFileParameters::getOptions), contextEncryptionAdapter), eTag, tracingContext);
            return abfsInputStream;
        }
    }

    private AbfsInputStreamContext populateAbfsInputStreamContext(Optional<Configuration> options, ContextEncryptionAdapter contextEncryptionAdapter) {
        boolean bufferedPreadDisabled = options.map(c -> c.getBoolean("fs.azure.buffered.pread.disable", false)).orElse(false);
        int footerReadBufferSize = options.map(c -> c.getInt("fs.azure.footer.read.request.size", this.getAbfsConfiguration().getFooterReadBufferSize())).orElse(this.getAbfsConfiguration().getFooterReadBufferSize());
        return new AbfsInputStreamContext(this.getAbfsConfiguration().getSasTokenRenewPeriodForStreamsInSeconds()).withReadBufferSize(this.getAbfsConfiguration().getReadBufferSize()).withReadAheadQueueDepth(this.getAbfsConfiguration().getReadAheadQueueDepth()).withTolerateOobAppends(this.getAbfsConfiguration().getTolerateOobAppends()).isReadAheadEnabled(this.getAbfsConfiguration().isReadAheadEnabled()).withReadSmallFilesCompletely(this.getAbfsConfiguration().readSmallFilesCompletely()).withOptimizeFooterRead(this.getAbfsConfiguration().optimizeFooterRead()).withFooterReadBufferSize(footerReadBufferSize).withReadAheadRange(this.getAbfsConfiguration().getReadAheadRange()).withStreamStatistics(new AbfsInputStreamStatisticsImpl()).withShouldReadBufferSizeAlways(this.getAbfsConfiguration().shouldReadBufferSizeAlways()).withReadAheadBlockSize(this.getAbfsConfiguration().getReadAheadBlockSize()).withBufferedPreadDisabled(bufferedPreadDisabled).withEncryptionAdapter(contextEncryptionAdapter).withAbfsBackRef(this.fsBackRef).build();
    }

    public OutputStream openFileForWrite(Path path, FileSystem.Statistics statistics, boolean overwrite, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("openFileForWrite", "getPathStatus");){
            ContextEncryptionAdapter contextEncryptionAdapter;
            LOG.debug("openFileForWrite filesystem: {} path: {} overwrite: {}", this.getClient().getFileSystem(), path, overwrite);
            String relativePath = this.getRelativePath(path);
            AbfsClient writeClient = this.getClientHandler().getIngressClient();
            AbfsRestOperation op = this.getClient().getPathStatus(relativePath, false, tracingContext, null);
            perfInfo.registerResult(op.getResult());
            if (this.getClient().checkIsDir(op.getResult())) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForWrite must be used with files and not directories", null);
            }
            long contentLength = this.extractContentLength(op.getResult());
            long offset = overwrite ? 0L : contentLength;
            perfInfo.registerSuccess(true);
            boolean isAppendBlob = false;
            if (this.isAppendBlobKey(path.toString())) {
                isAppendBlob = true;
            }
            AbfsLease lease = this.maybeCreateLease(relativePath, tracingContext);
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            if (writeClient.getEncryptionType() == EncryptionType.ENCRYPTION_CONTEXT) {
                String encryptionContext = op.getResult().getResponseHeader("x-ms-encryption-context");
                if (encryptionContext == null) {
                    throw new PathIOException(path.toString(), "File doesn't have encryptionContext.");
                }
                contextEncryptionAdapter = new ContextProviderEncryptionAdapter(writeClient.getEncryptionContextProvider(), this.getRelativePath(path), encryptionContext.getBytes(StandardCharsets.UTF_8));
            } else {
                contextEncryptionAdapter = NoContextEncryptionAdapter.getInstance();
            }
            AbfsOutputStream abfsOutputStream = new AbfsOutputStream(this.populateAbfsOutputStreamContext(isAppendBlob, lease, this.getClientHandler(), statistics, relativePath, offset, eTag, contextEncryptionAdapter, tracingContext));
            return abfsOutputStream;
        }
    }

    public void breakLease(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        LOG.debug("lease path: {}", (Object)path);
        this.getClient().breakLease(this.getRelativePath(path), tracingContext);
    }

    public boolean rename(Path source, Path destination, TracingContext tracingContext, String sourceEtag) throws IOException {
        boolean shouldContinue;
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        LOG.debug("renameAsync filesystem: {} source: {} destination: {}", this.getClient().getFileSystem(), source, destination);
        String continuation = null;
        String sourceRelativePath = this.getRelativePath(source);
        String destinationRelativePath = this.getRelativePath(destination);
        boolean recovered = false;
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("rename", "renamePath");){
                AbfsClientRenameResult abfsClientRenameResult = this.getClient().renamePath(sourceRelativePath, destinationRelativePath, continuation, tracingContext, sourceEtag, false);
                AbfsRestOperation op = abfsClientRenameResult.getOp();
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                perfInfo.registerSuccess(true);
                ++countAggregate;
                shouldContinue = continuation != null && !continuation.isEmpty();
                recovered |= abfsClientRenameResult.isRenameRecovered();
                this.populateRenameRecoveryStatistics(abfsClientRenameResult);
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
        return recovered;
    }

    public void delete(Path path, boolean recursive, TracingContext tracingContext) throws AzureBlobFileSystemException {
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        boolean shouldContinue = true;
        LOG.debug("delete filesystem: {} path: {} recursive: {}", this.getClient().getFileSystem(), path, String.valueOf(recursive));
        String continuation = null;
        String relativePath = this.getRelativePath(path);
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("delete", "deletePath");){
                AbfsRestOperation op = this.getClient().deletePath(relativePath, recursive, continuation, tracingContext);
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
    }

    public FileStatus getFileStatus(Path path, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getFileStatus", "undetermined");){
            boolean resourceIsDir;
            long contentLength;
            AbfsRestOperation op;
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
            LOG.debug("getFileStatus filesystem: {} path: {} isNamespaceEnabled: {}", this.getClient().getFileSystem(), path, isNamespaceEnabled);
            if (path.isRoot()) {
                if (isNamespaceEnabled) {
                    perfInfo.registerCallee("getAclStatus");
                    op = this.getClient().getAclStatus(this.getRelativePath(path), tracingContext);
                } else {
                    perfInfo.registerCallee("getFilesystemProperties");
                    op = this.getClient().getFilesystemProperties(tracingContext);
                }
            } else {
                perfInfo.registerCallee("getPathStatus");
                op = this.getClient().getPathStatus(this.getRelativePath(path), false, tracingContext, null);
            }
            perfInfo.registerResult(op.getResult());
            long blockSize = this.abfsConfiguration.getAzureBlockSize();
            AbfsHttpOperation result = op.getResult();
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(result);
            String lastModified = result.getResponseHeader("Last-Modified");
            String permissions = result.getResponseHeader("x-ms-permissions");
            String encryptionContext = op.getResult().getResponseHeader("x-ms-encryption-context");
            boolean hasAcl = AbfsPermission.isExtendedAcl(permissions);
            if (path.isRoot()) {
                contentLength = 0L;
                resourceIsDir = true;
            } else {
                contentLength = this.extractContentLength(result);
                resourceIsDir = this.getClient().checkIsDir(result);
            }
            String transformedOwner = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-owner"), true, this.userName);
            String transformedGroup = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-group"), false, this.primaryUserGroup);
            perfInfo.registerSuccess(true);
            VersionedFileStatus versionedFileStatus = new VersionedFileStatus(transformedOwner, transformedGroup, permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions), hasAcl, contentLength, resourceIsDir, 1, blockSize, DateTimeUtils.parseLastModifiedTime(lastModified), path, eTag, encryptionContext);
            return versionedFileStatus;
        }
    }

    @Override
    public FileStatus[] listStatus(Path path, TracingContext tracingContext) throws IOException {
        return this.listStatus(path, null, tracingContext);
    }

    @Override
    @InterfaceStability.Unstable
    public FileStatus[] listStatus(Path path, String startFrom, TracingContext tracingContext) throws IOException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        this.listStatus(path, startFrom, fileStatuses, true, null, tracingContext);
        return fileStatuses.toArray(new FileStatus[fileStatuses.size()]);
    }

    @Override
    public String listStatus(Path path, String startFrom, List<FileStatus> fileStatuses, boolean fetchAll, String continuation, TracingContext tracingContext) throws IOException {
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        boolean shouldContinue = true;
        LOG.debug("listStatus filesystem: {} path: {}, startFrom: {}", this.getClient().getFileSystem(), path, startFrom);
        String relativePath = this.getRelativePath(path);
        AbfsClient listingClient = this.getClient();
        if ((continuation == null || continuation.isEmpty()) && startFrom != null && !startFrom.isEmpty()) {
            listingClient = this.getClient(AbfsServiceType.DFS);
            continuation = this.getIsNamespaceEnabled(tracingContext) ? this.generateContinuationTokenForXns(startFrom) : this.generateContinuationTokenForNonXns(relativePath, startFrom);
        }
        ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("listStatus", "listPath");){
                ListResponseData listResponseData = listingClient.listPath(relativePath, false, this.abfsConfiguration.getListMaxResults(), continuation, tracingContext, this.uri);
                AbfsRestOperation op = listResponseData.getOp();
                perfInfo.registerResult(op.getResult());
                continuation = listResponseData.getContinuationToken();
                List<VersionedFileStatus> fileStatusListInCurrItr = listResponseData.getFileStatusList();
                if (fileStatusListInCurrItr != null && !fileStatusListInCurrItr.isEmpty()) {
                    fileStatusList.addAll(fileStatusListInCurrItr);
                }
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = fetchAll && continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
        fileStatuses.addAll(listingClient.postListProcessing(relativePath, fileStatusList, tracingContext, this.uri));
        return continuation;
    }

    private String generateContinuationTokenForXns(String firstEntryName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(firstEntryName) && !firstEntryName.startsWith("/"), "startFrom must be a dir/file name and it can not be a full path");
        StringBuilder sb = new StringBuilder();
        sb.append(firstEntryName).append("#$").append("0");
        CRC64 crc64 = new CRC64();
        StringBuilder token = new StringBuilder();
        token.append(crc64.compute(sb.toString().getBytes(StandardCharsets.UTF_8))).append(" ").append("0").append(" ").append(firstEntryName);
        return Base64.encode(token.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String generateContinuationTokenForNonXns(String path, String firstEntryName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(firstEntryName) && !firstEntryName.startsWith("/"), "startFrom must be a dir/file name and it can not be a full path");
        path = AbfsClient.getDirectoryQueryParameter(path);
        String startFrom = path.isEmpty() || path.equals("/") ? firstEntryName : path + "/" + firstEntryName;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TOKEN_DATE_PATTERN, Locale.US);
        String date = simpleDateFormat.format(new Date());
        String token = String.format("%06d!%s!%06d!%s!%06d!%s!", path.length(), path, startFrom.length(), startFrom, date.length(), date);
        String base64EncodedToken = Base64.encode(token.getBytes(StandardCharsets.UTF_8));
        StringBuilder encodedTokenBuilder = new StringBuilder(base64EncodedToken.length() + 5);
        encodedTokenBuilder.append(String.format("%s!%d!", "2", base64EncodedToken.length()));
        for (int i = 0; i < base64EncodedToken.length(); ++i) {
            int current = base64EncodedToken.charAt(i);
            if (47 == current) {
                current = 95;
            } else if (43 == current) {
                current = 42;
            } else if (61 == current) {
                current = 45;
            }
            encodedTokenBuilder.append((char)current);
        }
        return encodedTokenBuilder.toString();
    }

    public void setOwner(Path path, String owner, String group, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("setOwner", "setOwner");){
            LOG.debug("setOwner filesystem: {} path: {} owner: {} group: {}", this.getClient().getFileSystem(), path, owner, group);
            String transformedOwner = this.identityTransformer.transformUserOrGroupForSetRequest(owner);
            String transformedGroup = this.identityTransformer.transformUserOrGroupForSetRequest(group);
            AbfsRestOperation op = this.getClient().setOwner(this.getRelativePath(path), transformedOwner, transformedGroup, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void setPermission(Path path, FsPermission permission, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("setPermission", "setPermission");){
            LOG.debug("setPermission filesystem: {} path: {} permission: {}", this.getClient().getFileSystem(), path, permission);
            AbfsRestOperation op = this.getClient().setPermission(this.getRelativePath(path), String.format("%04d", permission.toOctal()), tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("modifyAclEntries", "getAclStatus");){
            LOG.debug("modifyAclEntries filesystem: {} path: {} aclSpec: {}", this.getClient().getFileSystem(), path, AclEntry.aclSpecToString(aclSpec));
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> modifyAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean useUpn = AbfsAclHelper.isUpnFormatAclEntries(modifyAclEntries);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.getClient().getAclStatus(relativePath, useUpn, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.modifyAclEntriesInternal(aclEntries, modifyAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("modifyAclEntries", "setAcl");){
                AbfsRestOperation setAclOp = this.getClient().setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeAclEntries", "getAclStatus");){
            LOG.debug("removeAclEntries filesystem: {} path: {} aclSpec: {}", this.getClient().getFileSystem(), path, AclEntry.aclSpecToString(aclSpec));
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> removeAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean isUpnFormat = AbfsAclHelper.isUpnFormatAclEntries(removeAclEntries);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.getClient().getAclStatus(relativePath, isUpnFormat, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.removeAclEntriesInternal(aclEntries, removeAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeAclEntries", "setAcl");){
                AbfsRestOperation setAclOp = this.getClient().setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeDefaultAcl(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeDefaultAcl", "getAclStatus");){
            LOG.debug("removeDefaultAcl filesystem: {} path: {}", (Object)this.getClient().getFileSystem(), (Object)path);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.getClient().getAclStatus(relativePath, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            HashMap<String, String> defaultAclEntries = new HashMap<String, String>();
            for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
                if (!aclEntry.getKey().startsWith("default:")) continue;
                defaultAclEntries.put(aclEntry.getKey(), aclEntry.getValue());
            }
            aclEntries.keySet().removeAll(defaultAclEntries.keySet());
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeDefaultAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.getClient().setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeAcl(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeAcl", "getAclStatus");){
            LOG.debug("removeAcl filesystem: {} path: {}", (Object)this.getClient().getFileSystem(), (Object)path);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.getClient().getAclStatus(relativePath, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            HashMap<String, String> newAclEntries = new HashMap<String, String>();
            newAclEntries.put("user:", aclEntries.get("user:"));
            newAclEntries.put("group:", aclEntries.get("group:"));
            newAclEntries.put("other:", aclEntries.get("other:"));
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.getClient().setAcl(relativePath, AbfsAclHelper.serializeAclSpec(newAclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void setAcl(Path path, List<AclEntry> aclSpec, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("setAcl", "getAclStatus");){
            LOG.debug("setAcl filesystem: {} path: {} aclspec: {}", this.getClient().getFileSystem(), path, AclEntry.aclSpecToString(aclSpec));
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean isUpnFormat = AbfsAclHelper.isUpnFormatAclEntries(aclEntries);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.getClient().getAclStatus(relativePath, isUpnFormat, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
            Map<String, String> getAclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.setAclEntriesInternal(aclEntries, getAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("setAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.getClient().setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public AclStatus getAclStatus(Path path, TracingContext tracingContext) throws IOException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("getAclStatus", "getAclStatus");){
            LOG.debug("getAclStatus filesystem: {} path: {}", (Object)this.getClient().getFileSystem(), (Object)path);
            AbfsRestOperation op = this.getClient().getAclStatus(this.getRelativePath(path), tracingContext);
            AbfsHttpOperation result = op.getResult();
            perfInfo.registerResult(result);
            String transformedOwner = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-owner"), true, this.userName);
            String transformedGroup = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-group"), false, this.primaryUserGroup);
            String permissions = result.getResponseHeader("x-ms-permissions");
            String aclSpecString = op.getResult().getResponseHeader("x-ms-acl");
            List<AclEntry> aclEntries = AclEntry.parseAclSpec(AbfsAclHelper.processAclString(aclSpecString), true);
            this.identityTransformer.transformAclEntriesForGetRequest(aclEntries, this.userName, this.primaryUserGroup);
            AbfsPermission fsPermission = permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions);
            AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
            aclStatusBuilder.owner(transformedOwner);
            aclStatusBuilder.group(transformedGroup);
            aclStatusBuilder.setPermission(fsPermission);
            aclStatusBuilder.stickyBit(fsPermission.getStickyBit());
            aclStatusBuilder.addEntries(aclEntries);
            perfInfo.registerSuccess(true);
            AclStatus aclStatus = aclStatusBuilder.build();
            return aclStatus;
        }
    }

    public void access(Path path, FsAction mode, TracingContext tracingContext) throws AzureBlobFileSystemException {
        LOG.debug("access for filesystem: {}, path: {}, mode: {}", new Object[]{this.getClient().getFileSystem(), path, mode});
        if (!this.abfsConfiguration.isCheckAccessEnabled() || !this.getIsNamespaceEnabled(tracingContext)) {
            LOG.debug("Returning; either check access is not enabled or the account used is not namespace enabled");
            return;
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("access", "checkAccess");){
            AbfsRestOperation op = this.getClient().checkAccess(this.getRelativePath(path), mode.SYMBOL, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public boolean isInfiniteLeaseKey(String key) {
        if (this.azureInfiniteLeaseDirSet.isEmpty()) {
            return false;
        }
        return UriUtils.isKeyForDirectorySet(key, this.azureInfiniteLeaseDirSet);
    }

    private void initializeClient(URI uri, String fileSystemName, String accountName, boolean isSecure) throws IOException {
        URL baseUrl;
        if (this.getClient() != null) {
            return;
        }
        URIBuilder uriBuilder = this.getURIBuilder(accountName, isSecure);
        String url = uriBuilder.toString() + "/" + fileSystemName;
        try {
            baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InvalidUriException(uri.toString());
        }
        SharedKeyCredentials creds = null;
        AccessTokenProvider tokenProvider = null;
        SASTokenProvider sasTokenProvider = null;
        if (this.authType == AuthType.OAuth) {
            AzureADAuthenticator.init(this.abfsConfiguration);
        }
        if (this.authType == AuthType.SharedKey) {
            LOG.trace("Fetching SharedKey credentials");
            int dotIndex = accountName.indexOf(".");
            if (dotIndex <= 0) {
                throw new InvalidUriException(uri.toString() + " - account name is not fully qualified.");
            }
            creds = new SharedKeyCredentials(accountName.substring(0, dotIndex), this.abfsConfiguration.getStorageAccountKey());
        } else if (this.authType == AuthType.SAS) {
            LOG.trace("Fetching SAS Token Provider");
            sasTokenProvider = this.abfsConfiguration.getSASTokenProvider();
        } else {
            LOG.trace("Fetching token provider");
            tokenProvider = this.abfsConfiguration.getTokenProvider();
            ExtensionHelper.bind(tokenProvider, uri, this.abfsConfiguration.getRawConfiguration());
        }
        EncryptionContextProvider encryptionContextProvider = null;
        if (isSecure) {
            encryptionContextProvider = this.abfsConfiguration.createEncryptionContextProvider();
            if (encryptionContextProvider != null) {
                if (this.abfsConfiguration.getEncodedClientProvidedEncryptionKey() != null) {
                    throw new PathIOException(uri.getPath(), "Both global key and encryption context are set, only one allowed");
                }
                encryptionContextProvider.initialize(this.abfsConfiguration.getRawConfiguration(), accountName, fileSystemName);
            } else if (this.abfsConfiguration.getEncodedClientProvidedEncryptionKey() != null && this.abfsConfiguration.getEncodedClientProvidedEncryptionKeySHA() == null) {
                throw new PathIOException(uri.getPath(), "Encoded SHA256 hash must be provided for global encryption");
            }
        }
        LOG.trace("Initializing AbfsClient for {}", (Object)baseUrl);
        this.clientHandler = tokenProvider != null ? new AbfsClientHandler(baseUrl, creds, this.abfsConfiguration, tokenProvider, encryptionContextProvider, this.populateAbfsClientContext()) : new AbfsClientHandler(baseUrl, creds, this.abfsConfiguration, sasTokenProvider, encryptionContextProvider, this.populateAbfsClientContext());
        this.setClient(this.getClientHandler().getClient());
        LOG.trace("AbfsClient init complete");
    }

    private AbfsServiceType getAbfsServiceTypeFromUrl() {
        if (this.uri.toString().contains(".blob.")) {
            return AbfsServiceType.BLOB;
        }
        LOG.debug("Falling back to default service type DFS");
        return AbfsServiceType.DFS;
    }

    private AbfsClientContext populateAbfsClientContext() {
        return new AbfsClientContextBuilder().withExponentialRetryPolicy(new ExponentialRetryPolicy(this.abfsConfiguration)).withStaticRetryPolicy(new StaticRetryPolicy(this.abfsConfiguration)).withAbfsCounters(this.abfsCounters).withAbfsPerfTracker(this.abfsPerfTracker).build();
    }

    public String getRelativePath(Path path) {
        Preconditions.checkNotNull(path, "path");
        String relPath = path.toUri().getPath();
        if (relPath.isEmpty()) {
            relPath = "/";
        }
        return relPath;
    }

    private long extractContentLength(AbfsHttpOperation op) {
        String contentLengthHeader = op.getResponseHeader("Content-Length");
        long contentLength = !StringUtils.isEmpty(contentLengthHeader) ? Long.parseLong(contentLengthHeader) : 0L;
        return contentLength;
    }

    private boolean parseIsDirectory(String resourceType) {
        return resourceType != null && resourceType.equalsIgnoreCase("directory");
    }

    private Hashtable<String, String> parseCommaSeparatedXmsProperties(String xMsProperties) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        CharsetDecoder decoder = Charset.forName(XMS_PROPERTIES_ENCODING).newDecoder();
        if (xMsProperties != null && !xMsProperties.isEmpty()) {
            String[] userProperties = xMsProperties.split(",");
            if (userProperties.length == 0) {
                return properties;
            }
            for (String property : userProperties) {
                String value;
                if (property.isEmpty()) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                String[] nameValue = property.split("=", 2);
                if (nameValue.length != 2) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                byte[] decodedValue = Base64.decode(nameValue[1]);
                try {
                    value = decoder.decode(ByteBuffer.wrap(decodedValue)).toString();
                }
                catch (CharacterCodingException ex) {
                    throw new InvalidAbfsRestOperationException(ex);
                }
                properties.put(nameValue[0], value);
            }
        }
        return properties;
    }

    private AbfsPerfInfo startTracking(String callerName, String calleeName) {
        return new AbfsPerfInfo(this.abfsPerfTracker, callerName, calleeName);
    }

    @VisibleForTesting
    public AbfsClient getClient() {
        return this.client;
    }

    @VisibleForTesting
    public AbfsClient getClient(AbfsServiceType serviceType) {
        return this.getClientHandler().getClient(serviceType);
    }

    @VisibleForTesting
    public AbfsClientHandler getClientHandler() {
        return this.clientHandler;
    }

    @VisibleForTesting
    void setClient(AbfsClient client) {
        this.client = client;
    }

    @VisibleForTesting
    void setClientHandler(AbfsClientHandler clientHandler) {
        this.clientHandler = clientHandler;
    }

    @VisibleForTesting
    DataBlocks.BlockFactory getBlockFactory() {
        return this.blockFactory;
    }

    @VisibleForTesting
    void setNamespaceEnabled(Trilean isNamespaceEnabled) {
        this.isNamespaceEnabled = isNamespaceEnabled;
    }

    @VisibleForTesting
    public URI getUri() {
        return this.uri;
    }

    private void updateInfiniteLeaseDirs() {
        this.azureInfiniteLeaseDirSet = new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAzureInfiniteLeaseDirs().split(",")));
        this.azureInfiniteLeaseDirSet.remove("");
    }

    private AbfsLease maybeCreateLease(String relativePath, TracingContext tracingContext) throws AzureBlobFileSystemException {
        boolean enableInfiniteLease = this.isInfiniteLeaseKey(relativePath);
        if (!enableInfiniteLease) {
            return null;
        }
        AbfsLease lease = new AbfsLease(this.getClient(), relativePath, true, -1L, null, tracingContext);
        this.leaseRefs.put(lease, null);
        return lease;
    }

    @VisibleForTesting
    boolean areLeasesFreed() {
        for (AbfsLease lease : this.leaseRefs.keySet()) {
            if (lease == null || lease.isFreed()) continue;
            return false;
        }
        return true;
    }

    public static String extractEtagHeader(AbfsHttpOperation result) {
        String etag = result.getResponseHeader("ETag");
        if (etag != null) {
            if (etag.startsWith("W/\"")) {
                etag = etag.substring(3);
            } else if (etag.startsWith("\"")) {
                etag = etag.substring(1);
            }
            if (etag.endsWith("\"")) {
                etag = etag.substring(0, etag.length() - 1);
            }
        }
        return etag;
    }

    private void populateRenameRecoveryStatistics(AbfsClientRenameResult abfsClientRenameResult) {
        if (abfsClientRenameResult.isRenameRecovered()) {
            this.abfsCounters.incrementCounter(AbfsStatistic.RENAME_RECOVERY, 1L);
        }
        if (abfsClientRenameResult.isIncompleteMetadataState()) {
            this.abfsCounters.incrementCounter(AbfsStatistic.METADATA_INCOMPLETE_RENAME_FAILURES, 1L);
        }
    }

    public static final class AzureBlobFileSystemStoreBuilder {
        private URI uri;
        private boolean isSecureScheme;
        private Configuration configuration;
        private AbfsCounters abfsCounters;
        private DataBlocks.BlockFactory blockFactory;
        private int blockOutputActiveBlocks;
        private BackReference fsBackRef;

        public AzureBlobFileSystemStoreBuilder withUri(URI value) {
            this.uri = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withSecureScheme(boolean value) {
            this.isSecureScheme = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withConfiguration(Configuration value) {
            this.configuration = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withAbfsCounters(AbfsCounters value) {
            this.abfsCounters = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withBlockFactory(DataBlocks.BlockFactory value) {
            this.blockFactory = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withBlockOutputActiveBlocks(int value) {
            this.blockOutputActiveBlocks = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withBackReference(BackReference fsBackRef) {
            this.fsBackRef = fsBackRef;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder build() {
            return this;
        }
    }

    public static final class Permissions {
        private final String permission;
        private final String umask;

        Permissions(boolean isNamespaceEnabled, FsPermission permission, FsPermission umask) {
            if (isNamespaceEnabled) {
                this.permission = this.getOctalNotation(permission);
                this.umask = this.getOctalNotation(umask);
            } else {
                this.permission = null;
                this.umask = null;
            }
        }

        private String getOctalNotation(FsPermission fsPermission) {
            Preconditions.checkNotNull(fsPermission, "fsPermission");
            return String.format("%04d", fsPermission.toOctal());
        }

        public Boolean hasPermission() {
            return this.permission != null && !this.permission.isEmpty();
        }

        public Boolean hasUmask() {
            return this.umask != null && !this.umask.isEmpty();
        }

        public String getPermission() {
            return this.permission;
        }

        public String getUmask() {
            return this.umask;
        }

        public String toString() {
            return String.format("{\"permission\":%s, \"umask\":%s}", this.permission, this.umask);
        }
    }
}

