/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.FileSystemConfigurations;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.annotations.ConfigurationValidationAnnotations;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConfigurationPropertyNotFoundException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.SASTokenProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TokenAccessProviderException;
import org.apache.hadoop.fs.azurebfs.diagnostics.Base64StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.BooleanConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.IntegerConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.LongConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.RefreshTokenBasedTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.UserPasswordTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.WorkloadIdentityTokenProvider;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.FixedSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.KeyProvider;
import org.apache.hadoop.fs.azurebfs.services.SimpleKeyProvider;
import org.apache.hadoop.fs.azurebfs.utils.MetricFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AbfsConfiguration {
    private final Configuration rawConfig;
    private final String accountName;
    private String fsName;
    private final AbfsServiceType fsConfiguredServiceType;
    private final boolean isSecure;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsConfiguration.class);
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.hns.enabled", DefaultValue="")
    private String isNamespaceEnabledAccount;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.dfstoblob.fallback", DefaultValue=false)
    private boolean isDfsToBlobFallbackEnabled;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.max.concurrent.requests", DefaultValue=-1)
    private int writeMaxConcurrentRequestCount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.max.requests.to.queue", DefaultValue=-1)
    private int maxWriteRequestsToQueue;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.request.size", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x800000)
    private int writeBufferSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.enableappendwithflush", DefaultValue=false)
    private boolean enableSmallWriteOptimization;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.smallfilescompletely", DefaultValue=false)
    private boolean readSmallFilesCompletely;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.optimizefooterread", DefaultValue=true)
    private boolean optimizeFooterRead;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.footer.read.request.size", DefaultValue=524288)
    private int footerReadBufferSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.expect.header.enabled", DefaultValue=true)
    private boolean isExpectHeaderEnabled;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.throttling.enabled", DefaultValue=true)
    private boolean accountThrottlingEnabled;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.request.size", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x400000)
    private int readBufferSize;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.readahead.range", MinValue=16384, MaxValue=0x6400000, DefaultValue=65536)
    private int readAheadRange;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.min.backoff.interval", DefaultValue=500)
    private int minBackoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.max.backoff.interval", DefaultValue=25000)
    private int maxBackoffInterval;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.static.retry.for.connection.timeout.enabled", DefaultValue=true)
    private boolean staticRetryForConnectionTimeoutEnabled;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.static.retry.interval", DefaultValue=1000)
    private int staticRetryInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.backoff.interval", DefaultValue=500)
    private int backoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.max.retries", MinValue=0, DefaultValue=30)
    private int maxIoRetries;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.custom.token.fetch.retry.count", MinValue=0, DefaultValue=3)
    private int customTokenFetchRetryCount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.http.connection.timeout", DefaultValue=2000)
    private int httpConnectionTimeout;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.http.read.timeout", DefaultValue=30000)
    private int httpReadTimeout;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.max.retries", MinValue=0, DefaultValue=5)
    private int oauthTokenFetchRetryCount;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.min.backoff.interval", MinValue=0, DefaultValue=0)
    private int oauthTokenFetchRetryMinBackoff;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.max.backoff.interval", MinValue=0, DefaultValue=60000)
    private int oauthTokenFetchRetryMaxBackoff;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.oauth.token.fetch.retry.delta.backoff", MinValue=0, DefaultValue=2)
    private int oauthTokenFetchRetryDeltaBackoff;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.block.size", MinValue=0L, MaxValue=0x10000000L, DefaultValue=0x10000000L)
    private long azureBlockSize;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.block.location.impersonatedhost", DefaultValue="localhost")
    private String azureBlockLocationHost;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.concurrentRequestCount.out", MinValue=1, DefaultValue=8)
    private int maxConcurrentWriteThreads;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.list.max.results", MinValue=1, DefaultValue=5000)
    private int listMaxResults;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.concurrentRequestCount.in", MinValue=1, DefaultValue=12)
    private int maxConcurrentReadThreads;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.read.tolerate.concurrent.append", DefaultValue=false)
    private boolean tolerateOobAppends;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.atomic.rename.key", DefaultValue="/hbase")
    private String azureAtomicDirs;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.conditional.create.overwrite", DefaultValue=true)
    private boolean enableConditionalCreateOverwrite;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.mkdir.overwrite", DefaultValue=true)
    private boolean mkdirOverwrite;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.appendblob.directories", DefaultValue="")
    private String azureAppendBlobDirs;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.infinite-lease.directories", DefaultValue="")
    private String azureInfiniteLeaseDirs;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.lease.threads", MinValue=0, DefaultValue=0)
    private int numLeaseThreads;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.createRemoteFileSystemDuringInitialization", DefaultValue=false)
    private boolean createRemoteFileSystemDuringInitialization;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.skipUserGroupMetadataDuringInitialization", DefaultValue=false)
    private boolean skipUserGroupMetadataDuringInitialization;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.readaheadqueue.depth", DefaultValue=2)
    private int readAheadQueueDepth;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.readahead.blocksize", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x400000)
    private int readAheadBlockSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.alwaysReadBufferSize", DefaultValue=false)
    private boolean alwaysReadBufferSize;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.flush", DefaultValue=true)
    private boolean enableFlush;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.disable.outputstream.flush", DefaultValue=true)
    private boolean disableOutputStreamFlush;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.autothrottling", DefaultValue=false)
    private boolean enableAutoThrottling;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.metric.idle.timeout", DefaultValue=60000)
    private int metricIdleTimeout;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.metric.analysis.timeout", DefaultValue=60000)
    private int metricAnalysisTimeout;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.metric.uri", DefaultValue="")
    private String metricUri;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.metric.account.name", DefaultValue="")
    private String metricAccount;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.metric.account.key", DefaultValue="")
    private String metricAccountKey;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.account.operation.idle.timeout", DefaultValue=60000)
    private int accountOperationIdleTimeout;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.analysis.period", DefaultValue=10000)
    private int analysisPeriod;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.rate.limit", MinValue=0, DefaultValue=1000)
    private int rateLimit;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.user.agent.prefix", DefaultValue="")
    private String userAgentId;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.cluster.name", DefaultValue="UNKNOWN")
    private String clusterName;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.cluster.type", DefaultValue="UNKNOWN")
    private String clusterType;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.client.correlationid", DefaultValue="")
    private String clientCorrelationId;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.delegation.token", DefaultValue=false)
    private boolean enableDelegationToken;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.always.use.https", DefaultValue=true)
    private boolean alwaysUseHttps;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.use.upn", DefaultValue=false)
    private boolean useUpn;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.check.access", DefaultValue=true)
    private boolean isCheckAccessEnabled;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.abfs.latency.track", DefaultValue=false)
    private boolean trackLatency;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.readahead", DefaultValue=true)
    private boolean enabledReadAhead;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.sas.token.renew.period.for.streams", MinValue=0L, DefaultValue=120L)
    private long sasTokenRenewPeriodForStreamsInSeconds;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.abfslistiterator", DefaultValue=true)
    private boolean enableAbfsListIterator;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.rename.resilience", DefaultValue=true)
    private boolean renameResilience;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.checksum.validation", DefaultValue=false)
    private boolean isChecksumValidationEnabled;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.paginated.delete", DefaultValue=false)
    private boolean isPaginatedDeleteEnabled;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.copy.progress.wait.millis", DefaultValue=1000L)
    private long blobCopyProgressPollWaitMillis;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.copy.max.wait.millis", DefaultValue=300000L)
    private long blobCopyProgressMaxWaitMillis;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.atomic.rename.lease.refresh.duration", DefaultValue=60000L)
    private long blobAtomicRenameLeaseRefreshDuration;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.dir.list.producer.queue.max.size", DefaultValue=10000)
    private int producerQueueMaxSize;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.dir.list.consumer.max.lag", DefaultValue=5000)
    private int listingMaxConsumptionLag;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.dir.rename.max.thread", DefaultValue=5)
    private int blobRenameDirConsumptionParallelism;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.blob.dir.delete.max.thread", DefaultValue=5)
    private int blobDeleteDirConsumptionParallelism;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.apache.http.client.max.io.exception.retries", DefaultValue=3)
    private int maxApacheHttpClientIoExceptionsRetries;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.apache.http.client.idle.connection.ttl", DefaultValue=5000L)
    private long maxApacheHttpClientConnectionIdleTime;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.client.transaction.id", DefaultValue=true)
    private boolean enableClientTransactionId;
    private String clientProvidedEncryptionKey;
    private String clientProvidedEncryptionKeySHA;

    public AbfsConfiguration(Configuration rawConfig, String accountName, AbfsServiceType fsConfiguredServiceType) throws IllegalAccessException, IOException {
        Field[] fields;
        this.rawConfig = ProviderUtils.excludeIncompatibleCredentialProviders(rawConfig, AzureBlobFileSystem.class);
        this.accountName = accountName;
        this.fsConfiguredServiceType = fsConfiguredServiceType;
        this.isSecure = this.getBoolean("fs.azure.secure.mode", false);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateInt(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerWithOutlierConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateIntWithOutlier(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateLong(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateString(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateBase64String(field));
                continue;
            }
            if (!field.isAnnotationPresent(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class)) continue;
            field.set(this, this.validateBoolean(field));
        }
    }

    public AbfsConfiguration(Configuration rawConfig, String accountName, String fsName, AbfsServiceType fsConfiguredServiceType) throws IllegalAccessException, IOException {
        this(rawConfig, accountName, fsConfiguredServiceType);
        this.fsName = fsName;
    }

    public AbfsConfiguration(Configuration rawConfig, String accountName) throws IllegalAccessException, IOException {
        this(rawConfig, accountName, AbfsServiceType.DFS);
    }

    public Trilean getIsNamespaceEnabledAccount() {
        return Trilean.getTrilean(this.getString("fs.azure.account.hns.enabled", this.isNamespaceEnabledAccount));
    }

    public AbfsServiceType getFsConfiguredServiceType() {
        return this.getCaseInsensitiveEnum("fs.azure.fns.account.service.type", this.fsConfiguredServiceType);
    }

    public AbfsServiceType getConfiguredServiceTypeForFNSAccounts() {
        return this.getCaseInsensitiveEnum("fs.azure.fns.account.service.type", null);
    }

    public AbfsServiceType getIngressServiceType() {
        return this.getCaseInsensitiveEnum("fs.azure.ingress.service.type", this.getFsConfiguredServiceType());
    }

    public boolean isDfsToBlobFallbackEnabled() {
        return this.isDfsToBlobFallbackEnabled;
    }

    public void validateConfiguredServiceType(boolean isHNSEnabled) throws InvalidConfigurationValueException {
        if (isHNSEnabled && this.getConfiguredServiceTypeForFNSAccounts() == AbfsServiceType.BLOB) {
            throw new InvalidConfigurationValueException("fs.azure.fns.account.service.type", "Service Type Cannot be BLOB for HNS Account");
        }
        if (isHNSEnabled && this.fsConfiguredServiceType == AbfsServiceType.BLOB) {
            throw new InvalidConfigurationValueException("fs.defaultFS", "Blob Endpoint Url Cannot be used to initialize filesystem for HNS Account");
        }
        if (this.getFsConfiguredServiceType() == AbfsServiceType.BLOB && this.getIngressServiceType() == AbfsServiceType.DFS) {
            throw new InvalidConfigurationValueException("fs.azure.ingress.service.type", "Ingress Type Cannot be DFS for Blob endpoint configured filesystem.");
        }
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getClientCorrelationId() {
        return this.clientCorrelationId;
    }

    public String accountConf(String key) {
        return key + "." + this.accountName;
    }

    public String containerConf(String key) {
        return key + "." + this.fsName + "." + this.accountName;
    }

    public String get(String key) {
        return this.rawConfig.get(this.accountConf(key), this.rawConfig.get(key));
    }

    public String getString(String key, String defaultValue) {
        return this.rawConfig.get(this.accountConf(key), this.rawConfig.get(key, defaultValue));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.rawConfig.getBoolean(this.accountConf(key), this.rawConfig.getBoolean(key, defaultValue));
    }

    public long getLong(String key, long defaultValue) {
        return this.rawConfig.getLong(this.accountConf(key), this.rawConfig.getLong(key, defaultValue));
    }

    public int getInt(String key, int defaultValue) {
        return this.rawConfig.getInt(this.accountConf(key), this.rawConfig.getInt(key, defaultValue));
    }

    public String getPasswordString(String key) throws IOException {
        char[] passchars;
        char[] cArray = this.rawConfig.getPassword(this.containerConf(key)) != null ? this.rawConfig.getPassword(this.containerConf(key)) : (passchars = this.rawConfig.getPassword(this.accountConf(key)) != null ? this.rawConfig.getPassword(this.accountConf(key)) : this.rawConfig.getPassword(key));
        if (passchars != null) {
            return new String(passchars);
        }
        return null;
    }

    private String getMandatoryPasswordString(String key) throws IOException {
        String value = this.getPasswordString(key);
        if (value == null) {
            throw new ConfigurationPropertyNotFoundException(key);
        }
        return value;
    }

    public <U> Class<? extends U> getTokenProviderClass(AuthType authType, String name, Class<? extends U> defaultValue, Class<U> xface) {
        Class<U> tokenProviderClass = this.getAccountSpecificClass(name, defaultValue, xface);
        if (tokenProviderClass == null && authType == this.getAccountAgnosticEnum("fs.azure.account.auth.type", AuthType.SharedKey)) {
            tokenProviderClass = this.getAccountAgnosticClass(name, defaultValue, xface);
        }
        return tokenProviderClass == null ? null : tokenProviderClass.asSubclass(xface);
    }

    public <U> Class<? extends U> getAccountSpecificClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.rawConfig.getClass(this.accountConf(name), defaultValue, xface);
    }

    public <U> Class<? extends U> getAccountAgnosticClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.rawConfig.getClass(name, defaultValue, xface);
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        return this.rawConfig.getEnum(this.accountConf(name), this.rawConfig.getEnum(name, defaultValue));
    }

    public <T extends Enum<T>> T getCaseInsensitiveEnum(String name, T defaultValue) {
        String configValue = this.getString(name, null);
        if (configValue != null) {
            for (Enum enumConstant : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
                if (!enumConstant.name().equalsIgnoreCase(configValue)) continue;
                return (T)enumConstant;
            }
            throw new IllegalArgumentException("No enum constant " + defaultValue.getDeclaringClass().getCanonicalName() + "." + configValue);
        }
        return defaultValue;
    }

    public <T extends Enum<T>> T getAccountAgnosticEnum(String name, T defaultValue) {
        return this.rawConfig.getEnum(name, defaultValue);
    }

    public void unset(String key) {
        this.rawConfig.unset(key);
    }

    public void set(String key, String value) {
        this.rawConfig.set(key, value);
    }

    public void setBoolean(String key, boolean value) {
        this.rawConfig.setBoolean(key, value);
    }

    public boolean isSecureMode() {
        return this.isSecure;
    }

    public String getStorageAccountKey() throws AzureBlobFileSystemException {
        KeyProvider keyProvider;
        String keyProviderClass = this.get("fs.azure.account.keyprovider");
        if (keyProviderClass == null) {
            keyProvider = new SimpleKeyProvider();
        } else {
            Object keyProviderObject;
            try {
                Class<?> clazz = this.rawConfig.getClassByName(keyProviderClass);
                keyProviderObject = clazz.newInstance();
            }
            catch (Exception e) {
                throw new KeyProviderException("Unable to load key provider class.", (Throwable)e);
            }
            if (!(keyProviderObject instanceof KeyProvider)) {
                throw new KeyProviderException(keyProviderClass + " specified in config is not a valid KeyProvider class.");
            }
            keyProvider = (KeyProvider)keyProviderObject;
        }
        String key = keyProvider.getStorageAccountKey(this.accountName, this.rawConfig);
        if (key == null) {
            throw new ConfigurationPropertyNotFoundException(this.accountName);
        }
        return key;
    }

    public Configuration getRawConfiguration() {
        return this.rawConfig;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean isSmallWriteOptimizationEnabled() {
        return this.enableSmallWriteOptimization;
    }

    public boolean readSmallFilesCompletely() {
        return this.readSmallFilesCompletely;
    }

    public boolean optimizeFooterRead() {
        return this.optimizeFooterRead;
    }

    public int getFooterReadBufferSize() {
        return this.footerReadBufferSize;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getMinBackoffIntervalMilliseconds() {
        return this.minBackoffInterval;
    }

    public int getMaxBackoffIntervalMilliseconds() {
        return this.maxBackoffInterval;
    }

    public boolean getStaticRetryForConnectionTimeoutEnabled() {
        return this.staticRetryForConnectionTimeoutEnabled;
    }

    public int getStaticRetryInterval() {
        return this.staticRetryInterval;
    }

    public int getBackoffIntervalMilliseconds() {
        return this.backoffInterval;
    }

    public int getMaxIoRetries() {
        return this.maxIoRetries;
    }

    public int getCustomTokenFetchRetryCount() {
        return this.customTokenFetchRetryCount;
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public long getAzureBlockSize() {
        return this.azureBlockSize;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public long getSasTokenRenewPeriodForStreamsInSeconds() {
        return this.sasTokenRenewPeriodForStreamsInSeconds;
    }

    public String getAzureBlockLocationHost() {
        return this.azureBlockLocationHost;
    }

    public int getMaxConcurrentWriteThreads() {
        return this.maxConcurrentWriteThreads;
    }

    public int getMaxConcurrentReadThreads() {
        return this.maxConcurrentReadThreads;
    }

    public int getListMaxResults() {
        return this.listMaxResults;
    }

    public boolean getTolerateOobAppends() {
        return this.tolerateOobAppends;
    }

    public String getAzureAtomicRenameDirs() {
        return this.azureAtomicDirs;
    }

    public boolean isConditionalCreateOverwriteEnabled() {
        return this.enableConditionalCreateOverwrite;
    }

    public boolean isEnabledMkdirOverwrite() {
        return this.mkdirOverwrite;
    }

    public String getAppendBlobDirs() {
        return this.azureAppendBlobDirs;
    }

    public boolean isExpectHeaderEnabled() {
        return this.isExpectHeaderEnabled;
    }

    public boolean accountThrottlingEnabled() {
        return this.accountThrottlingEnabled;
    }

    public String getAzureInfiniteLeaseDirs() {
        return this.azureInfiniteLeaseDirs;
    }

    public int getNumLeaseThreads() {
        return this.numLeaseThreads;
    }

    public boolean getCreateRemoteFileSystemDuringInitialization() {
        return this.createRemoteFileSystemDuringInitialization && this.getAuthType(this.accountName) != AuthType.SAS;
    }

    public boolean getSkipUserGroupMetadataDuringInitialization() {
        return this.skipUserGroupMetadataDuringInitialization;
    }

    public int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    public int getReadAheadBlockSize() {
        return this.readAheadBlockSize;
    }

    public boolean shouldReadBufferSizeAlways() {
        return this.alwaysReadBufferSize;
    }

    public boolean isFlushEnabled() {
        return this.enableFlush;
    }

    public boolean isOutputStreamFlushDisabled() {
        return this.disableOutputStreamFlush;
    }

    public boolean isAutoThrottlingEnabled() {
        return this.enableAutoThrottling;
    }

    public int getMetricIdleTimeout() {
        return this.metricIdleTimeout;
    }

    public int getMetricAnalysisTimeout() {
        return this.metricAnalysisTimeout;
    }

    public String getMetricUri() {
        return this.metricUri;
    }

    public String getMetricAccount() {
        return this.metricAccount;
    }

    public String getMetricAccountKey() {
        return this.metricAccountKey;
    }

    public int getAccountOperationIdleTimeout() {
        return this.accountOperationIdleTimeout;
    }

    public int getAnalysisPeriod() {
        return this.analysisPeriod;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public String getCustomUserAgentPrefix() {
        return this.userAgentId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public DelegatingSSLSocketFactory.SSLChannelMode getPreferredSSLFactoryOption() {
        return this.getEnum("fs.azure.ssl.channel.mode", FileSystemConfigurations.DEFAULT_FS_AZURE_SSL_CHANNEL_MODE);
    }

    public HttpOperationType getPreferredHttpOperationType() {
        return this.getEnum("fs.azure.networking.library", FileSystemConfigurations.DEFAULT_NETWORKING_LIBRARY);
    }

    public int getMaxApacheHttpClientIoExceptionsRetries() {
        return this.maxApacheHttpClientIoExceptionsRetries;
    }

    public long getMaxApacheHttpClientConnectionIdleTime() {
        return this.maxApacheHttpClientConnectionIdleTime;
    }

    public boolean getIsClientTransactionIdEnabled() {
        return this.enableClientTransactionId;
    }

    public TracingHeaderFormat getTracingHeaderFormat() {
        return this.getEnum("fs.azure.tracingheader.format", TracingHeaderFormat.ALL_ID_FORMAT);
    }

    public MetricFormat getMetricFormat() {
        return this.getEnum("fs.azure.metric.format", MetricFormat.EMPTY);
    }

    public AuthType getAuthType(String accountName) {
        return this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
    }

    public boolean isDelegationTokenManagerEnabled() {
        return this.enableDelegationToken;
    }

    public AbfsDelegationTokenManager getDelegationTokenManager() throws IOException {
        return new AbfsDelegationTokenManager(this.getRawConfiguration());
    }

    public boolean isHttpsAlwaysUsed() {
        return this.alwaysUseHttps;
    }

    public boolean isUpnUsed() {
        return this.useUpn;
    }

    public boolean shouldTrackLatency() {
        return this.trackLatency;
    }

    public AccessTokenProvider getTokenProvider() throws TokenAccessProviderException {
        AuthType authType = this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
        if (authType == AuthType.OAuth) {
            try {
                AccessTokenProvider tokenProvider;
                Class<AccessTokenProvider> tokenProviderClass = this.getTokenProviderClass(authType, "fs.azure.account.oauth.provider.type", null, AccessTokenProvider.class);
                if (tokenProviderClass == ClientCredsTokenProvider.class) {
                    String authEndpoint = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.endpoint");
                    String clientId = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.id");
                    String clientSecret = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.secret");
                    tokenProvider = new ClientCredsTokenProvider(authEndpoint, clientId, clientSecret);
                    LOG.trace("ClientCredsTokenProvider initialized");
                } else if (tokenProviderClass == UserPasswordTokenProvider.class) {
                    String authEndpoint = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.endpoint");
                    String username = this.getMandatoryPasswordString("fs.azure.account.oauth2.user.name");
                    String password = this.getMandatoryPasswordString("fs.azure.account.oauth2.user.password");
                    tokenProvider = new UserPasswordTokenProvider(authEndpoint, username, password);
                    LOG.trace("UserPasswordTokenProvider initialized");
                } else if (tokenProviderClass == MsiTokenProvider.class) {
                    String authEndpoint = this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.endpoint", "http://169.254.169.254/metadata/identity/oauth2/token");
                    String tenantGuid = this.getPasswordString("fs.azure.account.oauth2.msi.tenant");
                    String clientId = this.getPasswordString("fs.azure.account.oauth2.client.id");
                    String authority = this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.authority", "https://login.microsoftonline.com/");
                    authority = this.appendSlashIfNeeded(authority);
                    tokenProvider = new MsiTokenProvider(authEndpoint, tenantGuid, clientId, authority);
                    LOG.trace("MsiTokenProvider initialized");
                } else if (tokenProviderClass == RefreshTokenBasedTokenProvider.class) {
                    String authEndpoint = this.getTrimmedPasswordString("fs.azure.account.oauth2.refresh.token.endpoint", "https://login.microsoftonline.com/Common/oauth2/token");
                    String refreshToken = this.getMandatoryPasswordString("fs.azure.account.oauth2.refresh.token");
                    String clientId = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.id");
                    tokenProvider = new RefreshTokenBasedTokenProvider(authEndpoint, clientId, refreshToken);
                    LOG.trace("RefreshTokenBasedTokenProvider initialized");
                } else if (tokenProviderClass == WorkloadIdentityTokenProvider.class) {
                    String authority = this.appendSlashIfNeeded(this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.authority", "https://login.microsoftonline.com/"));
                    String tenantGuid = this.getMandatoryPasswordString("fs.azure.account.oauth2.msi.tenant");
                    String clientId = this.getMandatoryPasswordString("fs.azure.account.oauth2.client.id");
                    String tokenFile = this.getTrimmedPasswordString("fs.azure.account.oauth2.token.file", "/var/run/secrets/azure/tokens/azure-identity-token");
                    tokenProvider = new WorkloadIdentityTokenProvider(authority, tenantGuid, clientId, tokenFile);
                    LOG.trace("WorkloadIdentityTokenProvider initialized");
                } else {
                    throw new IllegalArgumentException("Failed to initialize " + tokenProviderClass);
                }
                return tokenProvider;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TokenAccessProviderException("Unable to load OAuth token provider class.", (Throwable)e);
            }
        }
        if (authType == AuthType.Custom) {
            try {
                String configKey = "fs.azure.account.oauth.provider.type";
                Class<CustomTokenProviderAdaptee> customTokenProviderClass = this.getTokenProviderClass(authType, configKey, null, CustomTokenProviderAdaptee.class);
                if (customTokenProviderClass == null) {
                    throw new IllegalArgumentException(String.format("The configuration value for \"%s\" is invalid.", configKey));
                }
                CustomTokenProviderAdaptee azureTokenProvider = ReflectionUtils.newInstance(customTokenProviderClass, this.rawConfig);
                if (azureTokenProvider == null) {
                    throw new IllegalArgumentException("Failed to initialize " + customTokenProviderClass);
                }
                LOG.trace("Initializing {}", (Object)customTokenProviderClass.getName());
                azureTokenProvider.initialize(this.rawConfig, this.accountName);
                LOG.trace("{} init complete", (Object)customTokenProviderClass.getName());
                return new CustomTokenProviderAdapter(azureTokenProvider, this.getCustomTokenFetchRetryCount());
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TokenAccessProviderException("Unable to load custom token provider class: " + e, (Throwable)e);
            }
        }
        throw new TokenAccessProviderException(String.format("Invalid auth type: %s is being used, expecting OAuth", new Object[]{authType}));
    }

    public SASTokenProvider getSASTokenProvider() throws AzureBlobFileSystemException {
        AuthType authType = this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
        if (authType != AuthType.SAS) {
            throw new SASTokenProviderException(String.format("Invalid auth type: %s is being used, expecting SAS.", new Object[]{authType}));
        }
        try {
            Class<SASTokenProvider> customSasTokenProviderImplementation = this.getTokenProviderClass(authType, "fs.azure.sas.token.provider.type", null, SASTokenProvider.class);
            String configuredFixedToken = this.getTrimmedPasswordString("fs.azure.sas.fixed.token", "");
            if (customSasTokenProviderImplementation == null && configuredFixedToken.isEmpty()) {
                throw new SASTokenProviderException(String.format("At least one of the \"%s\" and \"%s\" must be set.", "fs.azure.sas.token.provider.type", "fs.azure.sas.fixed.token"));
            }
            if (customSasTokenProviderImplementation != null) {
                LOG.trace("Using Custom SASTokenProvider implementation because it is given precedence when it is set.");
                SASTokenProvider sasTokenProvider = ReflectionUtils.newInstance(customSasTokenProviderImplementation, this.rawConfig);
                if (sasTokenProvider == null) {
                    throw new SASTokenProviderException(String.format("Failed to initialize %s", customSasTokenProviderImplementation));
                }
                LOG.trace("Initializing {}", (Object)customSasTokenProviderImplementation.getName());
                sasTokenProvider.initialize(this.rawConfig, this.accountName);
                LOG.trace("{} init complete", (Object)customSasTokenProviderImplementation.getName());
                return sasTokenProvider;
            }
            LOG.trace("Using FixedSASTokenProvider implementation");
            FixedSASTokenProvider fixedSASTokenProvider = new FixedSASTokenProvider(configuredFixedToken);
            return fixedSASTokenProvider;
        }
        catch (SASTokenProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SASTokenProviderException("Unable to load SAS token provider class: " + e, (Throwable)e);
        }
    }

    public EncryptionContextProvider createEncryptionContextProvider() {
        try {
            String configKey = "fs.azure.encryption.context.provider.type";
            if (this.get(configKey) == null) {
                return null;
            }
            Class<EncryptionContextProvider> encryptionContextClass = this.getAccountSpecificClass(configKey, null, EncryptionContextProvider.class);
            Preconditions.checkArgument(encryptionContextClass != null, "The configuration value for %s is invalid, or config key is not account-specific", configKey);
            EncryptionContextProvider encryptionContextProvider = ReflectionUtils.newInstance(encryptionContextClass, this.rawConfig);
            Preconditions.checkArgument(encryptionContextProvider != null, "Failed to initialize %s", encryptionContextClass);
            LOG.trace("{} init complete", (Object)encryptionContextClass.getName());
            return encryptionContextProvider;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load encryption context provider class: ", e);
        }
    }

    public boolean isReadAheadEnabled() {
        return this.enabledReadAhead;
    }

    @VisibleForTesting
    void setReadAheadEnabled(boolean enabledReadAhead) {
        this.enabledReadAhead = enabledReadAhead;
    }

    public int getReadAheadRange() {
        return this.readAheadRange;
    }

    int validateInt(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class);
        String value = this.get(validator.ConfigurationKey());
        return new IntegerConfigurationBasicValidator(validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    int validateIntWithOutlier(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.IntegerWithOutlierConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.IntegerWithOutlierConfigurationValidatorAnnotation.class);
        String value = this.get(validator.ConfigurationKey());
        return new IntegerConfigurationBasicValidator(validator.OutlierValue(), validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    long validateLong(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new LongConfigurationBasicValidator(validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    String validateString(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new StringConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    String validateBase64String(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new Base64StringConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    boolean validateBoolean(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new BooleanConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    public ExponentialRetryPolicy getOauthTokenFetchRetryPolicy() {
        return new ExponentialRetryPolicy(this.oauthTokenFetchRetryCount, this.oauthTokenFetchRetryMinBackoff, this.oauthTokenFetchRetryMaxBackoff, this.oauthTokenFetchRetryDeltaBackoff);
    }

    public int getWriteMaxConcurrentRequestCount() {
        if (this.writeMaxConcurrentRequestCount < 1) {
            return 4 * Runtime.getRuntime().availableProcessors();
        }
        return this.writeMaxConcurrentRequestCount;
    }

    public int getMaxWriteRequestsToQueue() {
        if (this.maxWriteRequestsToQueue < 1) {
            return 2 * this.getWriteMaxConcurrentRequestCount();
        }
        return this.maxWriteRequestsToQueue;
    }

    public boolean enableAbfsListIterator() {
        return this.enableAbfsListIterator;
    }

    public String getEncodedClientProvidedEncryptionKey() {
        if (this.clientProvidedEncryptionKey == null) {
            String accSpecEncKey = this.accountConf("fs.azure.encryption.encoded.client-provided-key");
            this.clientProvidedEncryptionKey = this.rawConfig.get(accSpecEncKey, null);
        }
        return this.clientProvidedEncryptionKey;
    }

    public String getEncodedClientProvidedEncryptionKeySHA() {
        if (this.clientProvidedEncryptionKeySHA == null) {
            String accSpecEncKey = this.accountConf("fs.azure.encryption.encoded.client-provided-key-sha");
            this.clientProvidedEncryptionKeySHA = this.rawConfig.get(accSpecEncKey, null);
        }
        return this.clientProvidedEncryptionKeySHA;
    }

    @VisibleForTesting
    void setReadBufferSize(int bufferSize) {
        this.readBufferSize = bufferSize;
    }

    @VisibleForTesting
    void setWriteBufferSize(int bufferSize) {
        this.writeBufferSize = bufferSize;
    }

    @VisibleForTesting
    void setEnableFlush(boolean enableFlush) {
        this.enableFlush = enableFlush;
    }

    @VisibleForTesting
    void setDisableOutputStreamFlush(boolean disableOutputStreamFlush) {
        this.disableOutputStreamFlush = disableOutputStreamFlush;
    }

    @VisibleForTesting
    void setListMaxResults(int listMaxResults) {
        this.listMaxResults = listMaxResults;
    }

    @VisibleForTesting
    public void setMaxIoRetries(int maxIoRetries) {
        this.maxIoRetries = maxIoRetries;
    }

    @VisibleForTesting
    void setMaxBackoffIntervalMilliseconds(int maxBackoffInterval) {
        this.maxBackoffInterval = maxBackoffInterval;
    }

    @VisibleForTesting
    void setIsNamespaceEnabledAccount(String isNamespaceEnabledAccount) {
        this.isNamespaceEnabledAccount = isNamespaceEnabledAccount;
    }

    public boolean isFixedSASTokenProviderConfigured() {
        try {
            return this.getSASTokenProvider() instanceof FixedSASTokenProvider;
        }
        catch (AzureBlobFileSystemException e) {
            LOG.debug("Failed to get SAS token provider", e);
            return false;
        }
    }

    private String getTrimmedPasswordString(String key, String defaultValue) throws IOException {
        String value = this.getPasswordString(key);
        if (StringUtils.isBlank(value)) {
            value = defaultValue;
        }
        return value.trim();
    }

    private String appendSlashIfNeeded(String authority) {
        if (!authority.endsWith("/")) {
            authority = authority + "/";
        }
        return authority;
    }

    @VisibleForTesting
    public void setReadSmallFilesCompletely(boolean readSmallFilesCompletely) {
        this.readSmallFilesCompletely = readSmallFilesCompletely;
    }

    @VisibleForTesting
    public void setOptimizeFooterRead(boolean optimizeFooterRead) {
        this.optimizeFooterRead = optimizeFooterRead;
    }

    @VisibleForTesting
    public void setEnableAbfsListIterator(boolean enableAbfsListIterator) {
        this.enableAbfsListIterator = enableAbfsListIterator;
    }

    public boolean getRenameResilience() {
        return this.renameResilience;
    }

    public boolean isPaginatedDeleteEnabled() {
        return this.isPaginatedDeleteEnabled;
    }

    public boolean getIsChecksumValidationEnabled() {
        return this.isChecksumValidationEnabled;
    }

    @VisibleForTesting
    public void setIsChecksumValidationEnabled(boolean isChecksumValidationEnabled) {
        this.isChecksumValidationEnabled = isChecksumValidationEnabled;
    }

    public long getBlobCopyProgressPollWaitMillis() {
        return this.blobCopyProgressPollWaitMillis;
    }

    public long getBlobCopyProgressMaxWaitMillis() {
        return this.blobCopyProgressMaxWaitMillis;
    }

    public long getAtomicRenameLeaseRefreshDuration() {
        return this.blobAtomicRenameLeaseRefreshDuration;
    }

    public int getProducerQueueMaxSize() {
        return this.producerQueueMaxSize;
    }

    public int getListingMaxConsumptionLag() {
        return this.listingMaxConsumptionLag;
    }

    public int getBlobRenameDirConsumptionParallelism() {
        return this.blobRenameDirConsumptionParallelism;
    }

    public int getBlobDeleteDirConsumptionParallelism() {
        return this.blobDeleteDirConsumptionParallelism;
    }
}

