/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.blob.PageRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.LocalSASKeyGeneratorImpl;
import org.apache.hadoop.fs.azure.RemoteSASKeyGeneratorImpl;
import org.apache.hadoop.fs.azure.SASKeyGenerationException;
import org.apache.hadoop.fs.azure.SASKeyGeneratorInterface;
import org.apache.hadoop.fs.azure.SecureModeException;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureStorageInterfaceImpl
extends StorageInterface {
    public static final Logger LOG = LoggerFactory.getLogger(SecureStorageInterfaceImpl.class);
    public static final String SAS_ERROR_CODE = "SAS Error";
    private SASKeyGeneratorInterface sasKeyGenerator;
    private String storageAccount;
    private RetryPolicyFactory retryPolicy;
    private int timeoutIntervalInMs;
    private boolean useContainerSasKeyForAllAccess;
    public static final String KEY_USE_CONTAINER_SASKEY_FOR_ALL_ACCESS = "fs.azure.saskey.usecontainersaskeyforallaccess";

    public SecureStorageInterfaceImpl(boolean useLocalSASKeyMode, Configuration conf) throws SecureModeException {
        if (useLocalSASKeyMode) {
            LOG.debug("Authenticating with SecureStorage and local SAS key");
            this.sasKeyGenerator = new LocalSASKeyGeneratorImpl(conf);
        } else {
            LOG.debug("Authenticating with SecureStorage and remote SAS key generation");
            RemoteSASKeyGeneratorImpl remoteSasKeyGenerator = new RemoteSASKeyGeneratorImpl(conf);
            try {
                remoteSasKeyGenerator.initialize(conf);
            }
            catch (IOException ioe) {
                throw new SecureModeException("Remote SAS Key mode could not be initialized", ioe);
            }
            this.sasKeyGenerator = remoteSasKeyGenerator;
        }
        this.useContainerSasKeyForAllAccess = conf.getBoolean(KEY_USE_CONTAINER_SASKEY_FOR_ALL_ACCESS, true);
        LOG.debug("Container SAS key {} be used for all access", (Object)(this.useContainerSasKeyForAllAccess ? "will" : "will not"));
    }

    @Override
    public void setTimeoutInMs(int timeoutInMs) {
        this.timeoutIntervalInMs = timeoutInMs;
    }

    @Override
    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicy = retryPolicyFactory;
    }

    @Override
    public void createBlobClient(CloudStorageAccount account) {
        String errorMsg = "createBlobClient is an invalid operation in SAS Key Mode";
        LOG.error(errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public void createBlobClient(URI baseUri) {
        String errorMsg = "createBlobClient is an invalid operation in SAS Key Mode";
        LOG.error(errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public void createBlobClient(URI baseUri, StorageCredentials credentials) {
        String errorMsg = "createBlobClient is an invalid operation in SAS Key Mode";
        LOG.error(errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public StorageCredentials getCredentials() {
        String errorMsg = "getCredentials is an invalid operation in SAS Key Mode";
        LOG.error(errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public StorageInterface.CloudBlobContainerWrapper getContainerReference(String name) throws URISyntaxException, StorageException {
        try {
            CloudBlobContainer container = new CloudBlobContainer(this.sasKeyGenerator.getContainerSASUri(this.storageAccount, name));
            if (this.retryPolicy != null) {
                container.getServiceClient().getDefaultRequestOptions().setRetryPolicyFactory(this.retryPolicy);
            }
            if (this.timeoutIntervalInMs > 0) {
                container.getServiceClient().getDefaultRequestOptions().setTimeoutIntervalInMs(this.timeoutIntervalInMs);
            }
            return this.useContainerSasKeyForAllAccess ? new SASCloudBlobContainerWrapperImpl(this.storageAccount, container, null) : new SASCloudBlobContainerWrapperImpl(this.storageAccount, container, this.sasKeyGenerator);
        }
        catch (SASKeyGenerationException sasEx) {
            String errorMsg = "Encountered SASKeyGeneration exception while generating SAS Key for container : " + name + " inside Storage account : " + this.storageAccount;
            LOG.error(errorMsg);
            throw new StorageException(SAS_ERROR_CODE, errorMsg, sasEx);
        }
    }

    public void setStorageAccountName(String storageAccount) {
        this.storageAccount = storageAccount;
    }

    static class SASCloudPageBlobWrapperImpl
    extends SASCloudBlobWrapperImpl
    implements StorageInterface.CloudPageBlobWrapper {
        public SASCloudPageBlobWrapperImpl(CloudPageBlob blob) {
            super(blob);
        }

        @Override
        public void create(long length, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            ((CloudPageBlob)this.getBlob()).create(length, null, options, opContext);
        }

        @Override
        public void uploadPages(InputStream sourceStream, long offset, long length, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            ((CloudPageBlob)this.getBlob()).uploadPages(sourceStream, offset, length, null, options, opContext);
        }

        @Override
        public ArrayList<PageRange> downloadPageRanges(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudPageBlob)this.getBlob()).downloadPageRanges(null, options, opContext);
        }
    }

    static class SASCloudBlockBlobWrapperImpl
    extends SASCloudBlobWrapperImpl
    implements StorageInterface.CloudBlockBlobWrapper {
        public SASCloudBlockBlobWrapperImpl(CloudBlockBlob blob) {
            super(blob);
        }

        @Override
        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudBlockBlob)this.getBlob()).openOutputStream(null, options, opContext);
        }

        @Override
        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().upload(sourceStream, 0L, null, null, opContext);
        }

        public void uploadProperties(OperationContext opContext) throws StorageException {
            this.getBlob().uploadProperties(null, null, opContext);
        }

        @Override
        public List<BlockEntry> downloadBlockList(BlockListingFilter filter, BlobRequestOptions options, OperationContext opContext) throws IOException, StorageException {
            return ((CloudBlockBlob)this.getBlob()).downloadBlockList(filter, null, options, opContext);
        }

        @Override
        public void uploadBlock(String blockId, AccessCondition accessCondition, InputStream sourceStream, long length, BlobRequestOptions options, OperationContext opContext) throws IOException, StorageException {
            ((CloudBlockBlob)this.getBlob()).uploadBlock(blockId, sourceStream, length, accessCondition, options, opContext);
        }

        @Override
        public void commitBlockList(List<BlockEntry> blockList, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws IOException, StorageException {
            ((CloudBlockBlob)this.getBlob()).commitBlockList(blockList, accessCondition, options, opContext);
        }
    }

    static abstract class SASCloudBlobWrapperImpl
    implements StorageInterface.CloudBlobWrapper {
        private final CloudBlob blob;

        @Override
        public CloudBlob getBlob() {
            return this.blob;
        }

        @Override
        public URI getUri() {
            return this.getBlob().getUri();
        }

        protected SASCloudBlobWrapperImpl(CloudBlob blob) {
            this.blob = blob;
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.getBlob().getMetadata();
        }

        @Override
        public void delete(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            this.getBlob().delete(DeleteSnapshotsOption.NONE, this.getLeaseCondition(lease), null, opContext);
        }

        private AccessCondition getLeaseCondition(SelfRenewingLease lease) {
            AccessCondition leaseCondition = null;
            if (lease != null) {
                leaseCondition = AccessCondition.generateLeaseCondition(lease.getLeaseID());
            }
            return leaseCondition;
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.getBlob().exists(null, null, opContext);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.getBlob().downloadAttributes(null, null, opContext);
        }

        @Override
        public BlobProperties getProperties() {
            return this.getBlob().getProperties();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.getBlob().setMetadata(metadata);
        }

        @Override
        public InputStream openInputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return this.getBlob().openInputStream(null, options, opContext);
        }

        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudBlockBlob)this.getBlob()).openOutputStream(null, options, opContext);
        }

        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().upload(sourceStream, 0L, null, null, opContext);
        }

        @Override
        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.getBlob().getContainer();
        }

        @Override
        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.getBlob().getParent();
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.uploadMetadata(null, null, opContext);
        }

        @Override
        public void uploadMetadata(AccessCondition accessConditions, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            this.getBlob().uploadMetadata(accessConditions, options, opContext);
        }

        @Override
        public void uploadProperties(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            this.getBlob().uploadProperties(this.getLeaseCondition(lease), null, opContext);
        }

        @Override
        public int getStreamMinimumReadSizeInBytes() {
            return this.getBlob().getStreamMinimumReadSizeInBytes();
        }

        @Override
        public void setStreamMinimumReadSizeInBytes(int minimumReadSizeBytes) {
            this.getBlob().setStreamMinimumReadSizeInBytes(minimumReadSizeBytes);
        }

        @Override
        public void setWriteBlockSizeInBytes(int writeBlockSizeBytes) {
            this.getBlob().setStreamWriteSizeInBytes(writeBlockSizeBytes);
        }

        @Override
        public StorageUri getStorageUri() {
            return this.getBlob().getStorageUri();
        }

        @Override
        public CopyState getCopyState() {
            return this.getBlob().getCopyState();
        }

        @Override
        public void startCopyFromBlob(StorageInterface.CloudBlobWrapper sourceBlob, BlobRequestOptions options, OperationContext opContext, boolean overwriteDestination) throws StorageException, URISyntaxException {
            AccessCondition dstAccessCondition = overwriteDestination ? null : AccessCondition.generateIfNotExistsCondition();
            this.getBlob().startCopy(sourceBlob.getBlob().getQualifiedUri(), null, dstAccessCondition, options, opContext);
        }

        @Override
        public void downloadRange(long offset, long length, OutputStream outStream, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().downloadRange(offset, length, outStream, null, options, opContext);
        }

        @Override
        public SelfRenewingLease acquireLease() throws StorageException {
            return new SelfRenewingLease(this, false);
        }
    }

    @InterfaceAudience.Private
    static class SASCloudBlobDirectoryWrapperImpl
    extends StorageInterface.CloudBlobDirectoryWrapper {
        private final CloudBlobDirectory directory;

        public SASCloudBlobDirectoryWrapperImpl(CloudBlobDirectory directory) {
            this.directory = directory;
        }

        @Override
        public URI getUri() {
            return this.directory.getUri();
        }

        @Override
        public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
            return SASWrappingIterator.wrap(this.directory.listBlobs(prefix, useFlatBlobListing, listingDetails, options, opContext));
        }

        @Override
        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.directory.getContainer();
        }

        @Override
        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.directory.getParent();
        }

        @Override
        public StorageUri getStorageUri() {
            return this.directory.getStorageUri();
        }
    }

    private static class SASWrappingIterator
    implements Iterator<ListBlobItem> {
        private final Iterator<ListBlobItem> present;

        public SASWrappingIterator(Iterator<ListBlobItem> present) {
            this.present = present;
        }

        public static Iterable<ListBlobItem> wrap(final Iterable<ListBlobItem> present) {
            return new Iterable<ListBlobItem>(){

                @Override
                public Iterator<ListBlobItem> iterator() {
                    return new SASWrappingIterator(present.iterator());
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.present.hasNext();
        }

        @Override
        public ListBlobItem next() {
            ListBlobItem unwrapped = this.present.next();
            if (unwrapped instanceof CloudBlobDirectory) {
                return new SASCloudBlobDirectoryWrapperImpl((CloudBlobDirectory)unwrapped);
            }
            if (unwrapped instanceof CloudBlockBlob) {
                return new SASCloudBlockBlobWrapperImpl((CloudBlockBlob)unwrapped);
            }
            if (unwrapped instanceof CloudPageBlob) {
                return new SASCloudPageBlobWrapperImpl((CloudPageBlob)unwrapped);
            }
            return unwrapped;
        }

        @Override
        public void remove() {
            this.present.remove();
        }
    }

    @InterfaceAudience.Private
    static class SASCloudBlobContainerWrapperImpl
    extends StorageInterface.CloudBlobContainerWrapper {
        private final CloudBlobContainer container;
        private String storageAccount;
        private SASKeyGeneratorInterface sasKeyGenerator;

        public SASCloudBlobContainerWrapperImpl(String storageAccount, CloudBlobContainer container, SASKeyGeneratorInterface sasKeyGenerator) {
            this.storageAccount = storageAccount;
            this.container = container;
            this.sasKeyGenerator = sasKeyGenerator;
        }

        @Override
        public String getName() {
            return this.container.getName();
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.container.exists(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void create(OperationContext opContext) throws StorageException {
            this.container.create(null, opContext);
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.container.getMetadata();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.container.setMetadata(metadata);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.container.downloadAttributes(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.container.uploadMetadata(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public StorageInterface.CloudBlobDirectoryWrapper getDirectoryReference(String relativePath) throws URISyntaxException, StorageException {
            CloudBlobDirectory dir = this.container.getDirectoryReference(relativePath);
            return new SASCloudBlobDirectoryWrapperImpl(dir);
        }

        @Override
        public StorageInterface.CloudBlobWrapper getBlockBlobReference(String relativePath) throws URISyntaxException, StorageException {
            try {
                CloudBlockBlob blob = this.sasKeyGenerator != null ? new CloudBlockBlob(this.sasKeyGenerator.getRelativeBlobSASUri(this.storageAccount, this.getName(), relativePath)) : this.container.getBlockBlobReference(relativePath);
                blob.getServiceClient().setDefaultRequestOptions(this.container.getServiceClient().getDefaultRequestOptions());
                return new SASCloudBlockBlobWrapperImpl(blob);
            }
            catch (SASKeyGenerationException sasEx) {
                String errorMsg = "Encountered SASKeyGeneration exception while generating SAS Key for relativePath : " + relativePath + " inside container : " + this.getName() + " Storage account : " + this.storageAccount;
                LOG.error(errorMsg);
                throw new StorageException(SecureStorageInterfaceImpl.SAS_ERROR_CODE, errorMsg, sasEx);
            }
        }

        @Override
        public StorageInterface.CloudBlobWrapper getPageBlobReference(String relativePath) throws URISyntaxException, StorageException {
            try {
                CloudPageBlob blob = this.sasKeyGenerator != null ? new CloudPageBlob(this.sasKeyGenerator.getRelativeBlobSASUri(this.storageAccount, this.getName(), relativePath)) : this.container.getPageBlobReference(relativePath);
                blob.getServiceClient().setDefaultRequestOptions(this.container.getServiceClient().getDefaultRequestOptions());
                return new SASCloudPageBlobWrapperImpl(blob);
            }
            catch (SASKeyGenerationException sasEx) {
                String errorMsg = "Encountered SASKeyGeneration exception while generating SAS Key for relativePath : " + relativePath + " inside container : " + this.getName() + " Storage account : " + this.storageAccount;
                LOG.error(errorMsg);
                throw new StorageException(SecureStorageInterfaceImpl.SAS_ERROR_CODE, errorMsg, sasEx);
            }
        }
    }
}

