/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.AzureADAuthenticator;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPasswordTokenProvider
extends AccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger("com.microsoft.azure.datalake.store.oauth2.UserPasswordTokenProvider");
    private final String clientId;
    private final String username;
    private final String password;

    public UserPasswordTokenProvider(String clientId, String username, String password) {
        this.clientId = clientId;
        this.username = username;
        this.password = password;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        log.debug("AADToken: refreshing user-password based token");
        return AzureADAuthenticator.getTokenUsingClientCreds(this.clientId, this.username, this.password);
    }
}

