/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.io.Writable;

public abstract class WritableSerializerHook<T extends Writable>
implements SerializerHook<T> {
    private final Class<T> clazz;
    private final Supplier<T> constructor;
    private final int typeId;

    protected WritableSerializerHook(Class<T> clazz, Supplier<T> constructor, int typeId) {
        this.clazz = clazz;
        this.constructor = constructor;
        this.typeId = typeId;
    }

    public Class<T> getSerializationType() {
        return this.clazz;
    }

    public Serializer createSerializer() {
        return new StreamSerializer<Writable>(){

            public int getTypeId() {
                return WritableSerializerHook.this.typeId;
            }

            public void write(ObjectDataOutput out, Writable writable) throws IOException {
                writable.write((DataOutput)out);
            }

            public Writable read(ObjectDataInput in) throws IOException {
                Writable writable = (Writable)WritableSerializerHook.this.constructor.get();
                writable.readFields((DataInput)in);
                return writable;
            }
        };
    }

    public boolean isOverwritable() {
        return true;
    }
}

