/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl.transports.grpc;

import com.google.protobuf.ByteString;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.usercode.UserCodeConfig;
import com.hazelcast.usercode.impl.MessageBase;
import com.hazelcast.usercode.impl.RuntimeInitArgs;
import com.hazelcast.usercode.impl.UserCodeException;
import com.hazelcast.usercode.impl.UserCodeProperties;
import com.hazelcast.usercode.impl.transports.MultiplexTransportBase;
import com.hazelcast.usercode.impl.transports.grpc.Empty;
import com.hazelcast.usercode.impl.transports.grpc.EndResponse;
import com.hazelcast.usercode.impl.transports.grpc.GrpcUtil;
import com.hazelcast.usercode.impl.transports.grpc.InitRequest;
import com.hazelcast.usercode.impl.transports.grpc.InitResponse;
import com.hazelcast.usercode.impl.transports.grpc.TransformRequest;
import com.hazelcast.usercode.impl.transports.grpc.TransformResponse;
import com.hazelcast.usercode.impl.transports.grpc.UserCodeRuntimeGrpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GrpcTransport
extends MultiplexTransportBase {
    private final String address;
    private final String runtimeName;
    private final int port;
    private final ILogger logger;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private ManagedChannel channel;
    private StreamObserver<TransformRequest> transformStream;
    private UserCodeRuntimeGrpc.UserCodeRuntimeBlockingStub initStub;
    private UserCodeRuntimeGrpc.UserCodeRuntimeBlockingStub endStub;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private volatile Throwable exceptionInOutputObserver;
    private final CompletableFuture<MessageBase> terminatedFuture;

    public GrpcTransport(String address, String runtimeName, HazelcastProperties hzProperties, UserCodeConfig config, ILogger logger) {
        super(config, hzProperties);
        this.address = address;
        this.port = hzProperties.getInteger(UserCodeProperties.USERCODE_RUNTIME_PORT);
        this.logger = logger;
        this.runtimeName = runtimeName;
        this.terminatedFuture = new CompletableFuture();
    }

    @Override
    public CompletableFuture<Void> initTransport() throws InterruptedException {
        this.logger.fine("Open gRPC transport (" + this.address + ":" + this.port + ") for [" + this.config.getName() + "]");
        this.waitUntilTargetUpOr(this.address, this.port, this.hzProperties.getMillis(UserCodeProperties.USERCODE_CONTROLLER_DEADLINE_FOR_INVOCATION_SECONDS));
        this.logger.info("Detected gRPC server at (" + this.address + ":" + this.port + ") for [" + this.config.getName() + "]");
        Object channelBuilder = ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(this.address, this.port).keepAliveTime(this.hzProperties.getSeconds(UserCodeProperties.USERCODE_RUNTIME_KEEP_ALIVE_SECONDS), TimeUnit.SECONDS)).keepAliveTimeout(this.hzProperties.getSeconds(UserCodeProperties.USERCODE_RUNTIME_KEEP_ALIVE_TIMEOUT_SECONDS), TimeUnit.SECONDS)).keepAliveWithoutCalls(true)).usePlaintext();
        this.channel = ((ManagedChannelBuilder)channelBuilder).build();
        this.initStub = UserCodeRuntimeGrpc.newBlockingStub(this.channel);
        this.endStub = UserCodeRuntimeGrpc.newBlockingStub(this.channel);
        UserCodeRuntimeGrpc.UserCodeRuntimeStub stub = UserCodeRuntimeGrpc.newStub(this.channel);
        this.transformStream = stub.transform(new MessageReceiver());
        this.logger.info("Opened Grpc transport (" + this.address + ":" + this.port + ") for [" + this.config.getName() + "]");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> initRuntime(RuntimeInitArgs message) {
        InitRequest.Builder initRequestBuilder = InitRequest.newBuilder().setJobId(message.getJobId()).setServerAddress(message.getMemberAddress()).setServerPort(message.getPort()).setModuleName(message.getModule());
        if (message.getResource() != null && message.getResource().exists()) {
            try (FileInputStream in = new FileInputStream(message.getResource());){
                initRequestBuilder.setResource(ByteString.copyFrom(in.readAllBytes()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InitResponse response = ((UserCodeRuntimeGrpc.UserCodeRuntimeBlockingStub)((UserCodeRuntimeGrpc.UserCodeRuntimeBlockingStub)this.initStub.withDeadlineAfter(this.hzProperties.getSeconds(UserCodeProperties.USERCODE_RUNTIME_DEADLINE_FOR_INVOCATION_SECONDS), TimeUnit.SECONDS)).withWaitForReady()).init(initRequestBuilder.build());
            if (response.getError().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture((Throwable)((Object)new UserCodeException(response.getError())));
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    private void waitUntilTargetUpOr(String host, int port, long timeoutMs) throws InterruptedException {
        long elapsed;
        long backoff = this.hzProperties.getMillis(UserCodeProperties.USERCODE_RUNTIME_TIMEOUT_INITIAL_BACKOFF_MILLISECONDS);
        for (elapsed = 0L; elapsed < timeoutMs && !this.destroyed.get(); elapsed += backoff) {
            try (Socket s22 = new Socket();){
                InetSocketAddress endPoint = new InetSocketAddress(host, port);
                s22.connect(endPoint, (int)backoff);
                return;
            }
            catch (IOException s22) {
                try {
                    TimeUnit.MILLISECONDS.sleep(backoff);
                    continue;
                }
                catch (InterruptedException ex) {
                    this.logger.fine("While waiting for runtime container interrupted. Destroying thr transport", (Throwable)ex);
                    this.destroy();
                    throw new InterruptedException("Grpc transport interrupted while waiting the runtime container to be available." + ex.getMessage());
                }
            }
        }
        throw new UserCodeException("Failed to detect listening gRPC server at (" + host + ":" + port + ") after " + elapsed + "ms trying.");
    }

    @Override
    public synchronized CompletableFuture<TransformResponse> invokeTransform(long id, byte[] message) {
        TransformRequest input = TransformRequest.newBuilder().setId(id).setData(ByteString.copyFrom(message)).build();
        CompletableFuture<TransformResponse> future = this.createFuture(id);
        try {
            this.transformStream.onNext(input);
        }
        catch (Exception ex) {
            this.transformStream.onError(ex);
            this.logger.severe("Exception thrown while handling [invokeTransform] call for runtime " + this.runtimeName, (Throwable)ex);
            this.failFuture(id, ex);
            throw ex;
        }
        return future;
    }

    @Override
    public CompletableFuture<MessageBase> destroy() {
        Object errorInRuntimeShutdown;
        if (!this.destroyed.compareAndSet(false, true)) {
            return this.terminatedFuture;
        }
        try {
            errorInRuntimeShutdown = this.end();
        }
        catch (StatusRuntimeException ex) {
            errorInRuntimeShutdown = "GRPC call failed -> " + String.valueOf(ex.getStatus()) + ". " + ex.getMessage();
        }
        if (!((String)errorInRuntimeShutdown).isEmpty()) {
            this.logger.warning("User code runtime [" + this.runtimeName + "] failed on [onShutdown]." + (String)errorInRuntimeShutdown);
        }
        try {
            this.transformStream.onCompleted();
            this.completionLatch.await(this.timeout, TimeUnit.SECONDS);
            GrpcUtil.shutdownChannel(this.channel, null, this.timeout);
            if (this.exceptionInOutputObserver != null) {
                this.logger.warning(" Exception observed on the stream while destroying the user code grpc transport.", this.exceptionInOutputObserver);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.terminatedFuture.complete(new MessageBase((String)errorInRuntimeShutdown));
        return this.terminatedFuture;
    }

    private String end() {
        EndResponse response = ((UserCodeRuntimeGrpc.UserCodeRuntimeBlockingStub)this.endStub.withDeadlineAfter(this.timeout, TIMEOUT_UNIT)).end(Empty.newBuilder().build());
        return response.getError();
    }

    private class MessageReceiver
    implements StreamObserver<TransformResponse> {
        private MessageReceiver() {
        }

        @Override
        public void onNext(TransformResponse response) {
            GrpcTransport.this.logger.finest("Transport received message [" + response.getId() + "]");
            try {
                GrpcTransport.this.completeFuture(response);
            }
            catch (Exception e) {
                GrpcTransport.this.exceptionInOutputObserver = e;
                GrpcTransport.this.completionLatch.countDown();
            }
        }

        @Override
        public void onError(Throwable e) {
            GrpcTransport.this.logger.severe("Transport error", e);
            try {
                GrpcTransport.this.exceptionInOutputObserver = e;
                GrpcTransport.this.failFutures(e);
            }
            finally {
                GrpcTransport.this.completionLatch.countDown();
            }
        }

        @Override
        public void onCompleted() {
            GrpcTransport.this.logger.info("Transport completed for runtime " + GrpcTransport.this.runtimeName);
            GrpcTransport.this.failFutures((Throwable)((Object)new UserCodeException("Completion of transport signaled before the future was completed.")));
            GrpcTransport.this.completionLatch.countDown();
        }
    }
}

