/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl.transports;

import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.usercode.UserCodeConfig;
import com.hazelcast.usercode.impl.UserCodeProperties;
import com.hazelcast.usercode.impl.UserCodeTransport;
import com.hazelcast.usercode.impl.transports.grpc.TransformResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public abstract class MultiplexTransportBase
implements UserCodeTransport {
    protected static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    protected final int timeout;
    protected final HazelcastProperties hzProperties;
    protected UserCodeConfig config;
    private final Map<Long, CompletableFuture<TransformResponse>> futures;
    private final TransformResponse.Builder timeoutMessageBuilder;

    protected MultiplexTransportBase(UserCodeConfig config, HazelcastProperties hzProperties) {
        this.config = config;
        this.hzProperties = hzProperties;
        this.timeout = this.hzProperties.getSeconds(UserCodeProperties.USERCODE_RUNTIME_DEADLINE_FOR_INVOCATION_SECONDS);
        this.timeoutMessageBuilder = TransformResponse.newBuilder().setError("The transform request timed out!");
        this.futures = new ConcurrentHashMap<Long, CompletableFuture<TransformResponse>>();
    }

    protected CompletableFuture<TransformResponse> createFuture(long id) {
        TransformResponse timeoutMessage = this.timeoutMessageBuilder.setId(id).build();
        CompletableFuture<TransformResponse> future = new CompletableFuture<TransformResponse>().completeOnTimeout(timeoutMessage, this.timeout, TIMEOUT_UNIT);
        this.futures.put(id, future);
        return future;
    }

    protected void completeFuture(TransformResponse response) {
        CompletableFuture<TransformResponse> future = this.futures.remove(response.getId());
        if (future != null) {
            future.complete(response);
        }
    }

    protected void failFuture(long id, Throwable t2) {
        CompletableFuture<TransformResponse> future = this.futures.remove(id);
        if (future != null) {
            future.completeExceptionally(t2);
        }
    }

    protected void failFutures(Throwable t2) {
        for (Map.Entry<Long, CompletableFuture<TransformResponse>> entry : this.futures.entrySet()) {
            entry.getValue().completeExceptionally(t2);
        }
    }
}

