/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import com.hazelcast.spi.impl.servicemanager.ServiceManager;
import com.hazelcast.spi.impl.servicemanager.impl.ServiceManagerImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.usercode.impl.ContainerUserCodeRuntimeControllerProxy;
import com.hazelcast.usercode.impl.ContainerUserCodeService;
import com.hazelcast.usercode.impl.UserCodeService;
import java.util.function.Function;

public class UserCodeServiceFactory {
    private UserCodeServiceFactory() {
    }

    private static ContainerUserCodeService create(HazelcastInstance hazelcastInstance) {
        HazelcastProperties props = Util.getNodeEngine((HazelcastInstance)hazelcastInstance).getProperties();
        SerializationService serializationService = Util.getNodeEngine((HazelcastInstance)hazelcastInstance).getSerializationService();
        ContainerUserCodeRuntimeControllerProxy runtimeController = new ContainerUserCodeRuntimeControllerProxy(props, hazelcastInstance.getLoggingService().getLogger(ContainerUserCodeRuntimeControllerProxy.class));
        return new ContainerUserCodeService(runtimeController, props, serializationService, hazelcastInstance.getLoggingService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserCodeService getOrCreateService(HazelcastInstance hazelcastInstance, String name, Function<HazelcastInstance, UserCodeService> factory) {
        UserCodeService service;
        ServiceManager svcMgr;
        NodeEngineImpl node = Util.getNodeEngine((HazelcastInstance)hazelcastInstance);
        ServiceManager serviceManager = svcMgr = node.getServiceManager();
        synchronized (serviceManager) {
            ServiceInfo info = svcMgr.getServiceInfo(name);
            if (info == null) {
                service = factory.apply(hazelcastInstance);
                ((ServiceManagerImpl)svcMgr).registerService(name, (Object)service);
            } else {
                service = (UserCodeService)info.getService();
            }
        }
        return service;
    }

    public static UserCodeService getOrCreateContainerService(HazelcastInstance hazelcastInstance) {
        return UserCodeServiceFactory.getOrCreateService(hazelcastInstance, "hz:impl:containerUserCodeService", UserCodeServiceFactory::create);
    }
}

