/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.usercode.impl.UserCodeException;
import com.hazelcast.usercode.impl.UserCodeProperties;
import com.hazelcast.usercode.impl.grpc.controller.ControllerGrpc;
import com.hazelcast.usercode.impl.grpc.controller.CreateRequest;
import com.hazelcast.usercode.impl.grpc.controller.CreateResponse;
import com.hazelcast.usercode.impl.grpc.controller.DeleteRequest;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;

final class ContainerUserCodeRuntimeControllerProxy {
    private final ILogger logger;
    private final ManagedChannel channel;
    private final HazelcastProperties hzProperties;
    private final ControllerGrpc.ControllerFutureStub futureStub;
    private final ControllerGrpc.ControllerBlockingStub blockingStub;

    ContainerUserCodeRuntimeControllerProxy(HazelcastProperties hzProperties, ILogger logger) {
        this.logger = logger;
        this.hzProperties = hzProperties;
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(hzProperties.getString(UserCodeProperties.USERCODE_CONTROLLER_ADDRESS), hzProperties.getInteger(UserCodeProperties.USERCODE_CONTROLLER_PORT)).keepAliveTime(hzProperties.getSeconds(UserCodeProperties.USERCODE_CONTROLLER_KEEP_ALIVE_SECONDS), TimeUnit.SECONDS)).keepAliveTimeout(hzProperties.getSeconds(UserCodeProperties.USERCODE_CONTROLLER_KEEP_ALIVE_TIMEOUT_SECONDS), TimeUnit.SECONDS)).keepAliveWithoutCalls(true)).enableRetry()).usePlaintext()).build();
        this.futureStub = ControllerGrpc.newFutureStub(this.channel);
        this.blockingStub = ControllerGrpc.newBlockingStub(this.channel);
    }

    public String createContainer(String image) {
        CreateRequest request = CreateRequest.newBuilder().setImage(image).build();
        int timeoutSeconds = this.hzProperties.getSeconds(UserCodeProperties.USERCODE_CONTROLLER_DEADLINE_FOR_INVOCATION_SECONDS);
        try {
            CreateResponse response = (timeoutSeconds > 0 ? (ControllerGrpc.ControllerBlockingStub)this.blockingStub.withDeadlineAfter(timeoutSeconds, TimeUnit.SECONDS) : this.blockingStub).create(request);
            return response.getName();
        }
        catch (Exception ex) {
            String msg = "Failed to create a new user code container runtime. Check whether controller is alive.";
            this.logger.severe(msg, (Throwable)ex);
            throw new UserCodeException(msg, ex);
        }
    }

    public void deleteContainer(String name) {
        DeleteRequest request = DeleteRequest.newBuilder().setName(name).build();
        ((ControllerGrpc.ControllerFutureStub)((ControllerGrpc.ControllerFutureStub)this.futureStub.withDeadlineAfter(this.hzProperties.getSeconds(UserCodeProperties.USERCODE_CONTROLLER_DEADLINE_FOR_INVOCATION_SECONDS), TimeUnit.SECONDS)).withWaitForReady()).delete(request);
    }

    public void shutdown() {
        try {
            this.channel.shutdown().awaitTermination(this.hzProperties.getLong(UserCodeProperties.USERCODE_CONTROLLER_DEADLINE_FOR_INVOCATION_SECONDS), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.fine("shutdown interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

