/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.usercode.impl.UserCodeException;
import com.hazelcast.usercode.impl.UserCodeRuntime;
import com.hazelcast.usercode.impl.UserCodeService;
import com.hazelcast.usercode.impl.UserCodeTransport;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class ContainerUserCodeRuntime
implements UserCodeRuntime {
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong();
    private final String containerName;
    private final UserCodeService userCodeService;
    private final AtomicLong ids = new AtomicLong();
    private final UserCodeTransport transport;
    private final SerializationService serializationService;

    public ContainerUserCodeRuntime(UserCodeService userCodeService, UserCodeTransport transport, SerializationService serializationService, String containerName) {
        this.userCodeService = userCodeService;
        this.transport = transport;
        this.serializationService = serializationService;
        this.containerName = containerName;
        INSTANCE_COUNT.incrementAndGet();
    }

    public static long getInitializedInstanceCount() {
        return INSTANCE_COUNT.get();
    }

    @Override
    public String getName() {
        return this.containerName;
    }

    @Override
    public UserCodeTransport getTransport() {
        return this.transport;
    }

    @Override
    public UserCodeService getUserCodeService() {
        return this.userCodeService;
    }

    @Override
    public <R> CompletableFuture<R> applyTransform(Object payload) {
        byte[] serializedPayload = payload == null ? new byte[]{} : this.serializationService.toData(payload).toByteArray();
        return this.applyTransform(serializedPayload).thenApply(x -> this.serializationService.toObject((Object)new HeapData(x)));
    }

    @Override
    public CompletableFuture<byte[]> applyTransform(byte[] payload) {
        long id = this.ids.getAndIncrement();
        return this.transport.invokeTransform(id, payload).thenApply(m4 -> {
            if (m4.hasError()) {
                throw new UserCodeException("Runtime exception at " + this.getName() + ". " + m4.getError());
            }
            return m4.getData().toByteArray();
        });
    }
}

