/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode;

import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;

public final class UserCodeConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String imageName;
    private String name;
    private String moduleName = "transformation.transform";

    public UserCodeConfig() {
    }

    public UserCodeConfig(String imageName, String name) {
        this.imageName = imageName;
        this.name = name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public UserCodeConfig setModuleName(String moduleName) {
        this.moduleName = Preconditions.checkHasText((String)moduleName, (String)"moduleName");
        return this;
    }

    public String getImageName() {
        return this.imageName;
    }

    public UserCodeConfig setImageName(String imageName) {
        this.imageName = Preconditions.checkHasText((String)imageName, (String)"image");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public UserCodeConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return "UserCodeConfig{ name=" + this.getName() + ", imageName=" + this.getImageName() + ", moduleName=" + this.getModuleName() + "}";
    }

    public UserCodeConfig clone() {
        UserCodeConfig clone = null;
        try {
            clone = (UserCodeConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new UserCodeConfig();
        }
        clone.setImageName(this.getImageName());
        clone.setName(this.getName());
        clone.setModuleName(this.getModuleName());
        return clone;
    }
}

