#!/bin/bash

if [[ $# -ne 2 ]]; then
  echo "Usage: ./prometheus-crawler.sh <mc-base-url> <mc-process-id>"
  exit 1
fi

cd "$(realpath $(dirname $0))"

check-command-exists() {
  export c=$1
  if [[ $(type $c >/dev/null ; echo $?) != "0" ]]; then
    echo "Command $c was not found. Exiting."
    exit 1
  fi
}

check-command-exists gzip
check-command-exists du
check-command-exists curl
check-command-exists uptime
check-command-exists cut
check-command-exists tail

export MC_BASE_URL="$1"
export MC_PID="$2"
export PROM_ENDPOINT="${MC_BASE_URL}/metrics"
export DATA_DIR="./data"
export SCRAPE_DELAY=10

export JSTACK_INSTALLED=$(type jstack >/dev/null ; echo $?)
if [[ "$JSTACK_INSTALLED" == "1" ]]; then
  echo "warning: jstack is not installed, will not generate thread dumps"
fi

echo "scraping ${PROM_ENDPOINT} in every ${SCRAPE_DELAY} seconds"

seq=1

if [[ ! -d $DATA_DIR ]]; then
  mkdir $DATA_DIR
fi

rm -r $DATA_DIR/* 2>/dev/null

while [ $(du -sc $DATA_DIR | cut -f 1 | tail -n 1) -lt 10000000 ]; do
  sleep $SCRAPE_DELAY
  output_file="${DATA_DIR}/$seq.curl.txt.gz"
  curl -s -XGET $PROM_ENDPOINT | gzip >$output_file
  code=$?
  if [[ $code -ne 0 ]]; then
    echo "warning: GET ${PROM_ENDPOINT} exit code was ${code}"
  fi
  uptime >"${DATA_DIR}/$seq.uptime.out"
  gzip </proc/meminfo >"${DATA_DIR}/$seq.meminfo.gz"
  if [[ "$JSTACK_INSTALLED" == "0" ]]; then
    jstack $MC_PID | gzip >"${DATA_DIR}/$seq.jstack.gz"
  fi
  seq=$((seq + 1))
done
