CREATE TABLE IF NOT EXISTS client_filtering_configs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    cluster VARCHAR NOT NULL UNIQUE,
    status VARCHAR NOT NULL,
    type VARCHAR(255) NOT NULL,
    etag VARCHAR(255),
    FOREIGN KEY (cluster) REFERENCES clusters (name)
);

-- clean up entries copied to 'deployed list'
DELETE FROM client_bw_list_entries
WHERE list_id IN (SELECT id FROM CLIENT_BW_LISTS WHERE deployed IS TRUE);

-- copy the existing configurations for clusters with configured CF
-- JOIN to clusters table to skip leftover configs of deleted clusters
INSERT INTO client_filtering_configs (cluster, type, etag, status)
SELECT cl.cluster, cl.type, cl.deployed_etag, CASE
                                                  WHEN cl.status = 'ACTIVE' THEN 'ENABLED'
                                                  ELSE 'DISABLED'
                                              END
FROM  client_bw_lists cl INNER JOIN clusters c ON cl.deployed_key = c.name
WHERE cl.deployed IS TRUE;

-- insert default configs for clusters without configured CF
INSERT INTO client_filtering_configs (cluster, type, etag, status)
SELECT c.name, 'ALLOWLIST', '00000000-0000-0000-0000-000000000000', 'DISABLED'
FROM  clusters c LEFT JOIN client_bw_lists cl ON c.name = cl.deployed_key
WHERE cl.deployed_key IS NULL;

-- remove 'deployed' lists
DELETE FROM client_bw_lists
WHERE deployed IS TRUE;

DROP INDEX IF EXISTS client_bw_lists_cluster_indx;

ALTER TABLE client_bw_lists DROP COLUMN IF EXISTS deployed;
ALTER TABLE client_bw_lists DROP COLUMN IF EXISTS deployed_key;
ALTER TABLE client_bw_lists DROP COLUMN IF EXISTS deployed_etag;

ALTER TABLE client_bw_lists
RENAME TO client_filtering_lists;

ALTER TABLE client_bw_list_entries
RENAME TO client_filtering_list_entries;
