/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.DelegatingInputFormat;
import org.apache.avro.mapred.DelegatingMapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroMultipleInputs {
    private static final Logger LOG = LoggerFactory.getLogger(AvroMultipleInputs.class);
    private static final String SCHEMA_KEY = "avro.mapreduce.input.multipleinputs.dir.schemas";
    private static final String MAPPERS_KEY = "avro.mapreduce.input.multipleinputs.dir.mappers";

    private static void addInputPath(JobConf conf, Path path, Schema inputSchema) {
        String schemaMapping = path.toString() + ";" + AvroMultipleInputs.toBase64(inputSchema.toString());
        String schemas = conf.get(SCHEMA_KEY);
        conf.set(SCHEMA_KEY, schemas == null ? schemaMapping : schemas + "," + schemaMapping);
        conf.setInputFormat(DelegatingInputFormat.class);
    }

    public static void addInputPath(JobConf conf, Path path, Class<? extends AvroMapper> mapperClass, Schema inputSchema) {
        AvroMultipleInputs.addInputPath(conf, path, inputSchema);
        String mapperMapping = path.toString() + ";" + mapperClass.getName();
        LOG.info(mapperMapping);
        String mappers = conf.get(MAPPERS_KEY);
        conf.set(MAPPERS_KEY, mappers == null ? mapperMapping : mappers + "," + mapperMapping);
        conf.setMapperClass(DelegatingMapper.class);
    }

    static Map<Path, Class<? extends AvroMapper>> getMapperTypeMap(JobConf conf) {
        String[] pathMappings;
        if (conf.get(MAPPERS_KEY) == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Class<? extends AvroMapper>> m4 = new HashMap<Path, Class<? extends AvroMapper>>();
        for (String pathMapping : pathMappings = conf.get(MAPPERS_KEY).split(",")) {
            Class<?> mapClass;
            String[] split = pathMapping.split(";");
            try {
                mapClass = conf.getClassByName(split[1]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m4.put(new Path(split[0]), mapClass);
        }
        return m4;
    }

    static Map<Path, Schema> getInputSchemaMap(JobConf conf) {
        if (conf.get(SCHEMA_KEY) == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Schema> m4 = new HashMap<Path, Schema>();
        String[] schemaMappings = conf.get(SCHEMA_KEY).split(",");
        Schema.Parser schemaParser = new Schema.Parser();
        for (String schemaMapping : schemaMappings) {
            Schema inputSchema;
            String[] split = schemaMapping.split(";");
            String schemaString = AvroMultipleInputs.fromBase64(split[1]);
            try {
                inputSchema = schemaParser.parse(schemaString);
            }
            catch (SchemaParseException e) {
                throw new RuntimeException(e);
            }
            m4.put(new Path(split[0]), inputSchema);
        }
        return m4;
    }

    private static String toBase64(String rawString) {
        byte[] buf = rawString.getBytes(StandardCharsets.UTF_8);
        return new String(Base64.getMimeEncoder().encode(buf), StandardCharsets.UTF_8);
    }

    private static String fromBase64(String base64String) {
        byte[] buf = base64String.getBytes(StandardCharsets.UTF_8);
        return new String(Base64.getMimeDecoder().decode(buf), StandardCharsets.UTF_8);
    }
}

