/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.AbstractTemporalConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;

public abstract class AbstractTimestampWithTimezoneConverter
extends AbstractTemporalConverter {
    protected AbstractTimestampWithTimezoneConverter(int id) {
        super(id, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
    }

    @Override
    public Class<?> getNormalizedValueClass() {
        return OffsetDateTime.class;
    }

    @Override
    public final String asVarchar(Object val) {
        return this.asTimestampWithTimezone(val).toString();
    }

    @Override
    public final LocalDate asDate(Object val) {
        return this.asTimestamp(val).toLocalDate();
    }

    @Override
    public final LocalTime asTime(Object val) {
        return this.asTimestamp(val).toLocalTime();
    }

    @Override
    public final LocalDateTime asTimestamp(Object val) {
        return AbstractTimestampWithTimezoneConverter.timestampWithTimezoneToTimestamp(this.asTimestampWithTimezone(val));
    }

    @Override
    public final Object asObject(Object val) {
        return this.asTimestampWithTimezone(val);
    }

    @Override
    public final Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asTimestampWithTimezone(val);
    }
}

