/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.loginimpl;

import com.hazelcast.config.Config;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.security.ClusterLoginModule;
import com.hazelcast.security.ClusterNameCallback;
import com.hazelcast.security.ConfigCallback;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.CredentialsCallback;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class DefaultLoginModule
extends ClusterLoginModule
implements LoginModule {
    private String name;

    @Override
    public boolean onLogin() throws LoginException {
        CredentialsCallback credcb = new CredentialsCallback();
        ConfigCallback ccb = new ConfigCallback();
        ClusterNameCallback cncb = new ClusterNameCallback();
        try {
            this.callbackHandler.handle(new Callback[]{credcb, ccb, cncb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            this.logger.warning("Retrieving the password failed.", e);
            throw new LoginException("Unable to retrieve the password");
        }
        Credentials credentials = credcb.getCredentials();
        String clusterName = cncb.getClusterName();
        this.name = credentials.getName();
        Config cfg = ccb.getConfig();
        if (cfg == null) {
            throw new LoginException("Cluster Configuration is not available.");
        }
        UsernamePasswordCredentials upCreds = this.getCredentialsFromRealm(cfg.getSecurityConfig());
        if (upCreds != null) {
            if (upCreds.equals(credentials)) {
                this.addRole(this.name);
                return true;
            }
        } else if (clusterName != null && clusterName.equals(cfg.getClusterName())) {
            this.logger.fine("Username-password identity is not configured, only the cluster names are compared!");
            this.name = clusterName;
            this.addRole(this.name);
            return true;
        }
        throw new FailedLoginException("Username/password provided don't match the expected values.");
    }

    private UsernamePasswordCredentials getCredentialsFromRealm(SecurityConfig securityConfig) {
        String memberRealm = securityConfig.getMemberRealm();
        if (memberRealm == null) {
            this.logger.warning("Member Realm name is not configured.");
            return null;
        }
        ICredentialsFactory cf = securityConfig.getRealmCredentialsFactory(memberRealm);
        if (cf == null) {
            this.logger.warning("Member realm name " + memberRealm + " is missing an identity configuration.");
            return null;
        }
        Credentials creds = cf.newCredentials(null);
        if (!(creds instanceof UsernamePasswordCredentials)) {
            this.logger.warning("Member realm '" + memberRealm + "' doesn't have username-password identity configured. Only cluster-name comparison will be used for authentication.");
            return null;
        }
        return (UsernamePasswordCredentials)creds;
    }

    @Override
    protected String getName() {
        return this.name;
    }
}

