/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.loginimpl;

import com.hazelcast.config.security.LdapRoleMappingMode;
import com.hazelcast.config.security.LdapSearchScope;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.security.ClusterLoginModule;
import com.hazelcast.security.impl.LdapUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class BasicLdapLoginModule
extends ClusterLoginModule {
    public static final String PLACEHOLDER_DN = "{memberDN}";
    public static final String OPTION_USER_NAME_ATTRIBUTE = "userNameAttribute";
    public static final String OPTION_PARSE_DN = "parseDN";
    public static final String OPTION_ROLE_MAPPING_MODE = "roleMappingMode";
    public static final String OPTION_ROLE_MAPPING_ATTRIBUTE = "roleMappingAttribute";
    public static final String OPTION_ROLE_CONTEXT = "roleContext";
    public static final String OPTION_ROLE_FILTER = "roleFilter";
    public static final String OPTION_ROLE_RECURSION_MAX_DEPTH = "roleRecursionMaxDepth";
    public static final String OPTION_ROLE_NAME_ATTRIBUTE = "roleNameAttribute";
    public static final String OPTION_ROLE_SEARCH_SCOPE = "roleSearchScope";
    public static final String DEFAULT_USER_NAME_ATTRIBUTE = "uid";
    public static final boolean DEFAULT_PARSE_DN = false;
    public static final int DEFAULT_ROLE_RECURSION_MAX_DEPTH = 1;
    protected String name;
    protected String login;
    protected String password;
    protected String userDN;
    protected String userNameAttribute;
    protected String roleMappingAttribute;
    protected LdapRoleMappingMode roleMappingMode;
    protected String roleNameAttribute;
    protected String roleFilter;
    protected String roleContext;
    protected LdapSearchScope roleSearchScope;
    protected boolean parseFromDN;
    protected int maxRecursionDepth;
    protected Attributes userAttributes;
    protected LdapContext ctx;
    protected Set<String> visitedRoleDns;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.userNameAttribute = this.getStringOption(OPTION_USER_NAME_ATTRIBUTE, DEFAULT_USER_NAME_ATTRIBUTE);
        this.roleNameAttribute = this.getStringOption(OPTION_ROLE_NAME_ATTRIBUTE, null);
        this.roleMappingAttribute = this.getStringOption(OPTION_ROLE_MAPPING_ATTRIBUTE, null);
        this.roleMappingMode = this.getRoleMappingMode(OPTION_ROLE_MAPPING_MODE);
        this.roleFilter = this.getStringOption(OPTION_ROLE_FILTER, "(" + this.roleMappingAttribute + "=" + PLACEHOLDER_DN + ")");
        this.roleContext = this.getStringOption(OPTION_ROLE_CONTEXT, "");
        this.roleSearchScope = this.getSearchScope(OPTION_ROLE_SEARCH_SCOPE);
        this.parseFromDN = this.getBoolOption(OPTION_PARSE_DN, false);
        this.maxRecursionDepth = this.getIntOption(OPTION_ROLE_RECURSION_MAX_DEPTH, 1);
        this.visitedRoleDns = new HashSet<String>();
        this.verifyOptions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onLogin() throws LoginException {
        this.initAuthentication();
        try {
            this.ctx = this.createLdapContext();
            try {
                this.userAttributes = this.setUserDnAndGetAttributes();
                this.name = LdapUtils.getAttributeValue(this.userAttributes, this.userNameAttribute);
                if (this.isSkipRole()) return true;
                switch (this.roleMappingMode) {
                    case ATTRIBUTE: {
                        this.addRolesFromAttribute();
                        return true;
                    }
                    case DIRECT: {
                        this.addRolesDirectMapping(1, LdapUtils.getAttributeValues(this.userAttributes, this.roleMappingAttribute));
                        return true;
                    }
                    case REVERSE: {
                        this.addRolesReverseMapping(1, this.userDN);
                        return true;
                    }
                    default: {
                        throw new LoginException("Unexpected Role Mapping mode");
                    }
                }
            }
            finally {
                this.ctx.close();
            }
        }
        catch (NamingException e) {
            this.logger.finest("Naming exception", e);
            throw new FailedLoginException("Naming problem occured: " + e.getMessage());
        }
    }

    protected void initAuthentication() throws FailedLoginException {
        NameCallback ncb = new NameCallback("Name");
        PasswordCallback pcb = new PasswordCallback("Password", false);
        try {
            this.callbackHandler.handle(new Callback[]{ncb, pcb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            this.logger.finest(e);
            throw new FailedLoginException("Handling callbacks failed.. " + e.getMessage());
        }
        char[] pass = pcb.getPassword();
        this.login = ncb.getName();
        this.password = pass == null ? null : new String(pass);
        pcb.clearPassword();
        if (StringUtil.isNullOrEmpty(this.password) || StringUtil.isNullOrEmpty(this.login)) {
            throw new FailedLoginException("Both the login name and the password have to be provided.");
        }
    }

    protected void verifyOptions() {
        this.logger.finest("Verifying provided options and credentials");
        this.checkOptionInMappingMode(OPTION_PARSE_DN, LdapRoleMappingMode.ATTRIBUTE);
        this.checkOptionInMappingMode(OPTION_ROLE_CONTEXT, LdapRoleMappingMode.REVERSE);
        this.checkOptionInMappingMode(OPTION_ROLE_FILTER, LdapRoleMappingMode.REVERSE);
        this.checkOptionInMappingMode(OPTION_ROLE_RECURSION_MAX_DEPTH, LdapRoleMappingMode.DIRECT, LdapRoleMappingMode.REVERSE);
    }

    private void checkOptionInMappingMode(String optionName, LdapRoleMappingMode ... supportedModes) {
        boolean optionConfigured;
        if (!this.logger.isWarningEnabled()) {
            return;
        }
        boolean bl = optionConfigured = this.getStringOption(optionName, null) != null;
        if (optionConfigured) {
            boolean optionSupported = false;
            for (LdapRoleMappingMode mode : supportedModes) {
                optionSupported |= this.roleMappingMode == mode;
            }
            if (!optionSupported) {
                this.logger.warning("Login module option " + optionName + " is not supported when roleMappingMode==" + this.roleMappingMode.toString() + ". It's only supported in following mapping mode(s): " + Arrays.toString((Object[])supportedModes));
            }
        }
    }

    protected Attributes setUserDnAndGetAttributes() throws NamingException, FailedLoginException {
        this.userDN = this.login;
        return this.ctx.getAttributes(this.userDN);
    }

    protected LdapContext createLdapContext() throws NamingException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", "ignore");
        env.putAll((Map<?, ?>)this.options);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.login);
        env.put("java.naming.security.credentials", this.password);
        this.logLdapContextProperties(env);
        return new InitialLdapContext(env, null);
    }

    protected void logLdapContextProperties(Properties env) {
        this.logger.fine("Creating an LDAP context");
        if (this.logger.isFinestEnabled()) {
            Properties filteredProps = env;
            if (filteredProps.containsKey("java.naming.security.credentials")) {
                filteredProps = new Properties();
                filteredProps.putAll((Map<?, ?>)env);
                filteredProps.put("java.naming.security.credentials", "***");
            }
            this.logger.finest("LDAP context properties: " + filteredProps);
        }
    }

    private void addRolesFromAttribute() throws NamingException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Searching role names in user attribute: " + this.roleMappingAttribute);
        }
        for (String roleAttrVal : LdapUtils.getAttributeValues(this.userAttributes, this.roleMappingAttribute)) {
            if (this.parseFromDN) {
                for (String role : LdapUtils.getAttributeValues(new LdapName(roleAttrVal), this.roleNameAttribute)) {
                    this.addRole(role);
                }
                continue;
            }
            this.addRole(roleAttrVal);
        }
    }

    private void addRolesDirectMapping(int level, Collection<String> dns) throws NamingException {
        if (level > this.maxRecursionDepth) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("The roleRecursionMaxDepth==" + this.maxRecursionDepth + " was reached.");
            }
            return;
        }
        for (String dn : dns) {
            if (this.visitedRoleDns.contains(dn)) continue;
            this.visitedRoleDns.add(dn);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Searching roles within LDAP object: " + dn);
            }
            Attributes roleObjectAttributes = this.ctx.getAttributes(new LdapName(dn));
            for (String role : LdapUtils.getAttributeValues(roleObjectAttributes, this.roleNameAttribute)) {
                this.addRole(role);
            }
            if (level >= this.maxRecursionDepth) continue;
            this.addRolesDirectMapping(level + 1, LdapUtils.getAttributeValues(roleObjectAttributes, this.roleMappingAttribute));
        }
    }

    private void addRolesReverseMapping(int level, String dn) throws NamingException {
        if (level > this.maxRecursionDepth) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("The roleRecursionMaxDepth==" + this.maxRecursionDepth + " was reached.");
            }
            return;
        }
        if (!this.visitedRoleDns.contains(dn)) {
            this.visitedRoleDns.add(dn);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Searching roles which contains mapping to LDAP object: " + dn);
            }
            String filter = LdapUtils.replacePlaceholders(this.roleFilter, PLACEHOLDER_DN, dn);
            SearchControls roleSearchControls = new SearchControls();
            roleSearchControls.setSearchScope(this.roleSearchScope.toSearchControlValue());
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Searching role objects with reverse mapping using filter: " + filter);
            }
            NamingEnumeration<SearchResult> roleSearchResultEnum = this.ctx.search(this.roleContext, filter, roleSearchControls);
            while (this.hasMoreIgnorePartResEx(roleSearchResultEnum)) {
                SearchResult roleSearchResult = roleSearchResultEnum.next();
                if (!roleSearchResult.isRelative()) continue;
                for (String role : LdapUtils.getAttributeValues(roleSearchResult.getAttributes(), this.roleNameAttribute)) {
                    this.addRole(role);
                }
                if (level >= this.maxRecursionDepth) continue;
                String roleDN = roleSearchResult.getName();
                if (!StringUtil.isNullOrEmpty(this.roleContext)) {
                    roleDN = roleDN + "," + this.roleContext;
                }
                this.addRolesReverseMapping(level + 1, roleDN);
            }
            roleSearchResultEnum.close();
        }
    }

    protected boolean hasMoreIgnorePartResEx(NamingEnumeration<SearchResult> namingEnum) throws NamingException {
        try {
            return namingEnum.hasMore();
        }
        catch (PartialResultException pre) {
            this.logger.fine("Ignoring PartialResultException", pre);
            return false;
        }
    }

    protected LdapSearchScope getSearchScope(String optionName) {
        return LdapSearchScope.getSearchScope(this.getStringOption(optionName, null));
    }

    private LdapRoleMappingMode getRoleMappingMode(String optionName) {
        return LdapRoleMappingMode.getRoleMappingMode(this.getStringOption(optionName, null));
    }

    @Override
    protected String getName() {
        return this.name;
    }
}

