/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.IPermissionPolicy;
import com.hazelcast.security.Parameters;
import com.hazelcast.security.SecureCallable;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.SecurityInterceptor;
import com.hazelcast.security.impl.ClusterCallbackHandler;
import com.hazelcast.security.impl.DefaultCredentialsFactory;
import com.hazelcast.security.impl.EmptyParametersImpl;
import com.hazelcast.security.impl.LoginConfigurationDelegate;
import com.hazelcast.security.impl.NodeCallbackHandler;
import com.hazelcast.security.impl.ParametersImpl;
import com.hazelcast.security.impl.SecureCallableImpl;
import com.hazelcast.security.impl.SecurityServiceImpl;
import com.hazelcast.security.impl.SqlSecurityContextImpl;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class SecurityContextImpl
implements SecurityContext {
    private static final ThreadLocal<ParametersImpl> THREAD_LOCAL_PARAMETERS = new ThreadLocal();
    private final Map<String, Map<String, String>> serviceToMethod = new HashMap<String, Map<String, String>>();
    private final ILogger logger;
    private final Node node;
    private final IPermissionPolicy policy;
    private final ICredentialsFactory credentialsFactory;
    private final Configuration memberConfiguration;
    private final Configuration clientConfiguration;
    private final List<SecurityInterceptor> interceptors;
    private final Parameters emptyParameters = new EmptyParametersImpl();
    private final AtomicBoolean refreshPermissionsInProgress = new AtomicBoolean();

    public SecurityContextImpl(Node node) {
        IPermissionPolicy tmpPolicy;
        this.node = node;
        this.logger = node.getLogger("com.hazelcast.security");
        this.logger.log(Level.INFO, "Initializing Hazelcast Enterprise security context.");
        SecurityConfig securityConfig = node.config.getSecurityConfig();
        PermissionPolicyConfig policyConfig = securityConfig.getClientPolicyConfig();
        if (policyConfig.getClassName() == null) {
            policyConfig.setClassName("com.hazelcast.security.impl.DefaultPermissionPolicy");
        }
        if ((tmpPolicy = policyConfig.getImplementation()) == null) {
            tmpPolicy = (IPermissionPolicy)this.createImplInstance(node.getConfigClassLoader(), policyConfig.getClassName());
        }
        this.policy = tmpPolicy;
        this.policy.configure(node.config, policyConfig.getProperties());
        String memberRealm = this.checkRealmExists(securityConfig.getMemberRealm(), securityConfig, "Member");
        String clientRealm = this.checkRealmExists(securityConfig.getClientRealm(), securityConfig, "Client");
        ICredentialsFactory credsFact = securityConfig.getRealmCredentialsFactory(memberRealm);
        if (credsFact == null) {
            credsFact = new DefaultCredentialsFactory();
        }
        this.credentialsFactory = credsFact;
        this.credentialsFactory.configure(new NodeCallbackHandler(node));
        this.memberConfiguration = new LoginConfigurationDelegate(securityConfig.getRealmLoginModuleConfigs(memberRealm));
        this.clientConfiguration = new LoginConfigurationDelegate(securityConfig.getRealmLoginModuleConfigs(clientRealm));
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Member Login configuration: " + this.memberConfiguration);
            this.logger.fine("Client Login configuration: " + this.clientConfiguration);
        }
        List<SecurityInterceptorConfig> interceptorConfigs = securityConfig.getSecurityInterceptorConfigs();
        this.interceptors = new ArrayList<SecurityInterceptor>(interceptorConfigs.size());
        for (SecurityInterceptorConfig interceptorConfig : interceptorConfigs) {
            this.addInterceptors(interceptorConfig);
        }
        this.fillServiceToMethodMap();
    }

    private String checkRealmExists(String realmName, SecurityConfig securityConfig, String mappingName) {
        if (realmName == null || securityConfig.isRealm(realmName)) {
            return realmName;
        }
        throw new InvalidConfigurationException("Realm name '" + realmName + "' used in " + mappingName + " configuration doesn't exists");
    }

    private void fillServiceToMethodMap() {
        Properties properties = new Properties();
        ClassLoader cl = SecureCallableImpl.class.getClassLoader();
        InputStream stream = cl.getResourceAsStream("permission-mapping.properties");
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(stream);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String action = (String)entry.getValue();
            int dotIndex = key.indexOf(46);
            if (dotIndex == -1) continue;
            String structure = key.substring(0, dotIndex);
            String method = key.substring(dotIndex + 1);
            Map methodMap = this.serviceToMethod.computeIfAbsent(structure, k -> new HashMap());
            methodMap.put(method, action);
        }
    }

    public Map<String, Map<String, String>> getServiceToMethod() {
        return this.serviceToMethod;
    }

    @Override
    public void interceptBefore(Credentials credentials, String objectType, String objectName, String methodName, Object[] args) throws AccessControlException {
        if (this.interceptors.isEmpty()) {
            return;
        }
        Parameters parameters = this.getArguments(args);
        for (SecurityInterceptor interceptor : this.interceptors) {
            try {
                interceptor.before(credentials, objectType, objectName, methodName, parameters);
            }
            catch (Throwable t) {
                throw new AccessControlException(t.getMessage());
            }
        }
    }

    @Override
    public void interceptAfter(Credentials credentials, String objectType, String objectName, String methodName) {
        if (this.interceptors.isEmpty()) {
            return;
        }
        Parameters parameters = SecurityContextImpl.getArguments();
        for (SecurityInterceptor interceptor : this.interceptors) {
            try {
                interceptor.after(credentials, objectType, objectName, methodName, parameters);
            }
            catch (Throwable t) {
                this.logger.warning("Exception during interceptor.after " + interceptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginContext createMemberLoginContext(String clusterName, Credentials credentials, Connection connection) throws LoginException {
        this.logger.log(Level.FINEST, "Creating Member LoginContext for: " + credentials);
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(SecurityContextImpl.class.getClassLoader());
            String name = this.node.getConfig().getClusterName();
            ClusterCallbackHandler callbackHandler = new ClusterCallbackHandler(clusterName, credentials, connection, this.node);
            LoginContext loginContext = new LoginContext(name, new Subject(), callbackHandler, this.memberConfiguration);
            return loginContext;
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginContext createClientLoginContext(String clusterName, Credentials credentials, Connection connection) throws LoginException {
        this.logger.log(Level.FINEST, "Creating Client LoginContext for: " + credentials);
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        try {
            String name = this.node.getConfig().getClusterName();
            ClusterCallbackHandler callbackHandler = new ClusterCallbackHandler(clusterName, credentials, connection, this.node);
            LoginContext loginContext = new LoginContext(name, new Subject(), callbackHandler, this.clientConfiguration);
            return loginContext;
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    @Override
    public ICredentialsFactory getCredentialsFactory() {
        return this.credentialsFactory;
    }

    @Override
    public void checkPermission(Subject subject, Permission permission) throws SecurityException {
        boolean b;
        PermissionCollection coll = this.policy.getPermissions(subject, (permission = this.stripJetInternalPrefix(permission)).getClass());
        boolean bl = b = coll != null && coll.implies(permission);
        if (!b) {
            throw new AccessControlException("Permission " + permission + " denied!", permission);
        }
    }

    @Override
    public <V> SecureCallable<V> createSecureCallable(Subject subject, Callable<V> callable) {
        return new SecureCallableImpl<V>(subject, callable, this.serviceToMethod);
    }

    @Override
    public <V> SecureCallable<?> createSecureCallable(Subject subject, Runnable runnable) {
        return new SecureCallableImpl(subject, runnable, this.serviceToMethod);
    }

    @Override
    public void destroy() {
        this.logger.log(Level.INFO, "Destroying Hazelcast Enterprise security context.");
        this.policy.destroy();
        this.credentialsFactory.destroy();
    }

    @Override
    public void refreshPermissions(Set<PermissionConfig> permissionConfigs) {
        if (!this.refreshPermissionsInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("Permissions could not be refreshed, another update is in progress.");
        }
        this.policy.refreshPermissions(SecurityServiceImpl.clonePermissionConfigs(permissionConfigs));
        SecurityServiceImpl securityService = (SecurityServiceImpl)this.node.getSecurityService();
        securityService.setPermissionConfigs(permissionConfigs);
        this.refreshPermissionsInProgress.set(false);
    }

    @Override
    public SqlSecurityContext createSqlContext(Subject subject) {
        return new SqlSecurityContextImpl(this, subject);
    }

    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    private void addInterceptors(SecurityInterceptorConfig interceptorConfig) {
        SecurityInterceptor interceptor = interceptorConfig.getImplementation();
        String className = interceptorConfig.getClassName();
        if (interceptor == null && className != null) {
            try {
                interceptor = (SecurityInterceptor)ClassLoaderUtil.newInstance(this.node.getConfigClassLoader(), className);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (interceptor != null) {
            this.interceptors.add(interceptor);
        }
    }

    private Parameters getArguments(Object[] args) {
        if (args == null) {
            return this.emptyParameters;
        }
        ParametersImpl params = THREAD_LOCAL_PARAMETERS.get();
        if (params == null) {
            params = new ParametersImpl(this.node.getSerializationService());
            THREAD_LOCAL_PARAMETERS.set(params);
        }
        params.setArgs(args);
        return params;
    }

    static Parameters getArguments() {
        return THREAD_LOCAL_PARAMETERS.get();
    }

    private Object createImplInstance(ClassLoader cl, String className) {
        try {
            return ClassLoaderUtil.newInstance(cl, className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create instance of '" + className + "', cause: " + e.getMessage(), e);
        }
    }

    private Permission stripJetInternalPrefix(Permission permission) {
        String name = permission.getName();
        if (name.startsWith("__jet.observables.")) {
            return new RingBufferPermission(name.substring("__jet.observables.".length()), permission.getActions());
        }
        return permission;
    }
}

