/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.security.ConfigCallback;
import com.hazelcast.security.HazelcastInstanceCallback;
import com.hazelcast.security.LoggingServiceCallback;
import com.hazelcast.security.RealmConfigCallback;
import com.hazelcast.security.TokenDeserializerCallback;
import com.hazelcast.security.impl.TokenDeserializerImpl;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NodeCallbackHandler
implements CallbackHandler {
    private final Node node;

    public NodeCallbackHandler(Node node) {
        this.node = node;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            this.handleCallback(cb);
        }
    }

    protected void handleCallback(Callback cb) throws UnsupportedCallbackException {
        if (cb instanceof ConfigCallback) {
            ((ConfigCallback)cb).setConfig(this.node != null ? this.node.getConfig() : null);
        } else if (cb instanceof RealmConfigCallback) {
            RealmConfigCallback realmCb = (RealmConfigCallback)cb;
            RealmConfig realmCfg = null;
            if (this.node != null && this.node.getConfig().getSecurityConfig() != null) {
                realmCfg = this.node.getConfig().getSecurityConfig().getRealmConfig(realmCb.getRealmName());
            }
            realmCb.setRealmConfig(realmCfg);
        } else if (cb instanceof TokenDeserializerCallback) {
            ((TokenDeserializerCallback)cb).setTokenDeserializer(new TokenDeserializerImpl(this.node.getSerializationService()));
        } else if (cb instanceof LoggingServiceCallback) {
            ((LoggingServiceCallback)cb).setLoggingService(this.node.getLoggingService());
        } else if (cb instanceof HazelcastInstanceCallback) {
            ((HazelcastInstanceCallback)cb).setHazelcastInstance(this.node.hazelcastInstance);
        } else {
            throw new UnsupportedCallbackException(cb);
        }
    }
}

