/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.SimpleTokenCredentials;
import com.hazelcast.security.TokenCredentials;
import com.hazelcast.security.impl.SecurityUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class KerberosCredentialsFactory
implements ICredentialsFactory {
    public static final String PROPERTY_SPN = "spn";
    public static final String PROPERTY_PREFIX = "serviceNamePrefix";
    public static final String PROPERTY_REALM = "realm";
    public static final String PROPERTY_SECURITY_REALM = "securityRealm";
    public static final String PROPERTY_USE_CANONICAL_HOSTNAME = "useCanonicalHostname";
    public static final String PROPERTY_KEYTAB_FILE = "keytabFile";
    public static final String PROPERTY_PRINCIPAL = "principal";
    public static final String DEFAULT_VALUE_PREFIX = "hz/";
    private static final Oid KRB5_OID;
    private static final AtomicBoolean KRB5_REALM_GENERATED_WARNING_PRINTED;
    private final ILogger logger = Logger.getLogger(KerberosCredentialsFactory.class);
    private volatile String spn;
    private volatile String serviceNamePrefix;
    private volatile String serviceRealm;
    private volatile boolean useCanonicalHostname;
    private volatile String securityRealm;
    private volatile String keytabFile;
    private volatile String principal;
    private volatile CallbackHandler callbackHandler;

    @Override
    public void configure(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void init(Properties properties) {
        this.spn = properties.getProperty(PROPERTY_SPN);
        this.serviceNamePrefix = properties.getProperty(PROPERTY_PREFIX);
        this.serviceRealm = properties.getProperty(PROPERTY_REALM);
        this.securityRealm = properties.getProperty(PROPERTY_SECURITY_REALM);
        this.keytabFile = properties.getProperty(PROPERTY_KEYTAB_FILE);
        this.principal = properties.getProperty(PROPERTY_PRINCIPAL);
        this.useCanonicalHostname = Boolean.parseBoolean(properties.getProperty(PROPERTY_USE_CANONICAL_HOSTNAME));
        if (this.spn != null && this.serviceNamePrefix != null) {
            throw new InvalidConfigurationException("Service name must not be configured together with the service name prefix.");
        }
        if (this.securityRealm != null && (this.principal != null || this.keytabFile != null)) {
            throw new InvalidConfigurationException("The principal and keytabFile must not be configured when securityRealm is used.");
        }
        if (this.serviceNamePrefix == null) {
            this.serviceNamePrefix = DEFAULT_VALUE_PREFIX;
        }
    }

    @Override
    public Credentials newCredentials(Address address) {
        Subject subject;
        String serviceName = this.spn;
        if (serviceName == null) {
            if (address == null) {
                throw new IllegalArgumentException("Kerberos Service principal name can't be generated without the address provided.");
            }
            serviceName = this.serviceNamePrefix + this.getSpnHostPart(address);
        }
        if (this.serviceRealm != null) {
            serviceName = serviceName + "@" + this.serviceRealm;
        }
        if (this.securityRealm != null) {
            subject = SecurityUtil.getRunAsSubject(this.callbackHandler, this.securityRealm);
        } else {
            RealmConfig realmConfig = SecurityUtil.createKerberosJaasRealmConfig(this.principal, this.keytabFile, true);
            if (realmConfig != null && KRB5_REALM_GENERATED_WARNING_PRINTED.compareAndSet(false, true)) {
                this.logger.warning("Using generated Kerberos initiator realm configuration is not intended for production use. It's recommended to properly configure the Krb5LoginModule manually to fit your needs. Following configuration was generated from provided keytab and principal properties:\n" + SecurityUtil.generateRealmConfigXml(realmConfig, "krb5Initiator"));
            }
            subject = SecurityUtil.getRunAsSubject(this.callbackHandler, realmConfig);
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Creating KerberosCredentials for serviceName=" + serviceName + ", Subject=" + subject);
        }
        TokenCredentials token = null;
        if (subject != null) {
            String tmpName = serviceName;
            token = Subject.doAs(subject, () -> this.createTokenCredentials(tmpName));
        } else {
            token = this.createTokenCredentials(serviceName);
        }
        return token;
    }

    protected String getSpnHostPart(Address address) {
        String host = address.getHost();
        if (this.useCanonicalHostname) {
            try {
                host = InetAddress.getByName(host).getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                this.logger.fine("Getting canonical hostname for the address failed: " + address, e);
            }
        }
        return host;
    }

    @Override
    public Credentials newCredentials() {
        return this.newCredentials(null);
    }

    @Override
    public void destroy() {
    }

    private TokenCredentials createTokenCredentials(String serviceName) {
        try {
            GSSManager manager = GSSManager.getInstance();
            GSSContext gssContext = manager.createContext(manager.createName(serviceName, null), KRB5_OID, null, 0);
            gssContext.requestMutualAuth(false);
            gssContext.requestConf(false);
            gssContext.requestInteg(false);
            byte[] token = gssContext.initSecContext(new byte[0], 0, 0);
            if (!gssContext.isEstablished()) {
                this.logger.warning("GSSContext was not established in a single step. The TokenCredentials won't be created.");
                return null;
            }
            return new SimpleTokenCredentials(token);
        }
        catch (GSSException e) {
            this.logger.warning("Establishing GSSContext failed", e);
            return null;
        }
    }

    static {
        try {
            KRB5_OID = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
        KRB5_REALM_GENERATED_WARNING_PRINTED = new AtomicBoolean(false);
    }
}

