/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.CertificatesCallback;
import com.hazelcast.security.ClusterNameCallback;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.CredentialsCallback;
import com.hazelcast.security.EndpointCallback;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.security.impl.NodeCallbackHandler;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ClusterCallbackHandler
extends NodeCallbackHandler {
    private final String clusterName;
    private final Credentials credentials;
    private final Connection connection;

    public ClusterCallbackHandler(String clusterName, Credentials credentials, Connection connection, Node node) {
        super(node);
        this.clusterName = clusterName;
        this.credentials = Objects.requireNonNull(credentials, "Credentials have to be provided.");
        this.connection = connection;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            this.handleCallback(cb);
        }
    }

    @Override
    protected void handleCallback(Callback cb) throws UnsupportedCallbackException {
        if (cb instanceof NameCallback) {
            ((NameCallback)cb).setName(this.credentials.getName());
        } else if (cb instanceof PasswordCallback) {
            this.handlePasswordCallback((PasswordCallback)cb);
        } else if (cb instanceof CredentialsCallback) {
            ((CredentialsCallback)cb).setCredentials(this.credentials);
        } else if (cb instanceof EndpointCallback) {
            this.handleEndpointCallback((EndpointCallback)cb);
        } else if (cb instanceof CertificatesCallback) {
            Certificate[] certificates = null;
            if (this.connection != null) {
                certificates = (Certificate[])this.connection.attributeMap().get(Certificate.class);
            }
            ((CertificatesCallback)cb).setCertificates(certificates);
        } else if (cb instanceof ClusterNameCallback) {
            ((ClusterNameCallback)cb).setClusterName(this.clusterName);
        } else {
            super.handleCallback(cb);
        }
    }

    private void handleEndpointCallback(EndpointCallback cb) {
        if (this.connection != null) {
            cb.setEndpoint(this.connection.getInetAddress().getHostAddress());
        }
    }

    private void handlePasswordCallback(PasswordCallback cb) {
        char[] password = null;
        if (this.credentials instanceof PasswordCredentials) {
            PasswordCredentials passwordCredentials = (PasswordCredentials)this.credentials;
            String pwdStr = passwordCredentials.getPassword();
            password = pwdStr == null ? null : pwdStr.toCharArray();
        }
        cb.setPassword(password);
    }
}

