/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.DefaultBPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BaseSingleValueIndexStore;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.HDBPlusTreeIndex;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class HDBaseConcurrentIndexStore
extends BaseSingleValueIndexStore {
    protected final HDBPlusTreeIndex<QueryableEntry> recordsWithNullValue;
    protected final HDBPlusTreeIndex<QueryableEntry> records;

    HDBaseConcurrentIndexStore(IndexCopyBehavior copyBehavior, EnterpriseSerializationService ess, MemoryAllocator keyAllocator, MemoryAllocator indexAllocator, BPlusTreeKeyComparator keyComparator, MapEntryFactory<QueryableEntry> entryFactory, int nodeSize, EntrySlotPayload entrySlotPayload, boolean tstore) {
        super(copyBehavior, false);
        this.recordsWithNullValue = new HDBPlusTreeIndex<QueryableEntry>(ess, keyAllocator, indexAllocator, entryFactory, keyComparator, new DefaultBPlusTreeKeyAccessor(ess), nodeSize, entrySlotPayload, tstore);
        try {
            this.records = new HDBPlusTreeIndex<QueryableEntry>(ess, keyAllocator, indexAllocator, entryFactory, keyComparator, new DefaultBPlusTreeKeyAccessor(ess), nodeSize, entrySlotPayload, tstore);
        }
        catch (NativeOutOfMemoryError e) {
            this.recordsWithNullValue.dispose();
            throw e;
        }
    }

    @Override
    Object insertInternal(Comparable attributeValue, QueryableEntry entry) {
        NativeMemoryData key = (NativeMemoryData)entry.getKeyData();
        MemoryBlock value = this.getValueToStore(entry);
        if (attributeValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.put(Long.valueOf(key.hash64()), key, value);
        }
        return this.records.put(attributeValue, key, value);
    }

    @Override
    Object removeInternal(Comparable attributeValue, Data key) {
        if (attributeValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.remove(Long.valueOf(key.hash64()), (NativeMemoryData)key);
        }
        return this.records.remove(attributeValue, (NativeMemoryData)key);
    }

    @Override
    public void clear() {
        this.recordsWithNullValue.clear();
        this.records.clear();
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    @Override
    public boolean isEvaluateOnly() {
        return false;
    }

    @Override
    public boolean canEvaluate(Class<? extends Predicate> predicateClass) {
        return false;
    }

    @Override
    public Set<QueryableEntry> evaluate(Predicate predicate, TypeConverter converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return this.doGetRecords(value);
    }

    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        HashSet<QueryableEntry> results = new HashSet<QueryableEntry>();
        for (Comparable value : values) {
            results.addAll(this.getRecords(value));
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable value) {
        return this.buildResultSet(this.getRecords0(comparison, value, false));
    }

    private void dispose() {
        this.recordsWithNullValue.dispose();
        this.records.dispose();
    }

    private MemoryBlock getValueToStore(QueryableEntry entry) {
        return (MemoryBlock)((Object)entry.getValueData());
    }

    private Set<QueryableEntry> doGetRecords(Comparable value) {
        if (value == AbstractIndex.NULL) {
            return this.buildResultSet(this.recordsWithNullValue.getKeysInRange(null, true, null, true, false));
        }
        return this.buildResultSet(this.records.lookup(value));
    }

    protected Set<QueryableEntry> buildResultSet(Iterator<QueryableEntry> it) {
        if (!it.hasNext()) {
            return Collections.emptySet();
        }
        HashSet<QueryableEntry> resultSet = new HashSet<QueryableEntry>();
        while (it.hasNext()) {
            resultSet.add(it.next());
        }
        return resultSet;
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(boolean descending) {
        return this.getRecords0(null, true, null, true, descending);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable value) {
        if (value == AbstractIndex.NULL) {
            return this.recordsWithNullValue.getKeysInRange(null, true, null, true, false);
        }
        return this.records.lookup(value);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable value, boolean descending) {
        return this.getRecords0(comparison, value, descending);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.getRecords0(from, fromInclusive, to, toInclusive, descending);
    }

    Iterator<QueryableEntry> getRecords0(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        if (from == null && to == null) {
            return new FullScanIterator(descending);
        }
        return this.records.getKeysInRange(from, fromInclusive, to, toInclusive, descending);
    }

    private Iterator<QueryableEntry> getRecords0(Comparison comparison, Comparable value, boolean descending) {
        Iterator<QueryableEntry> result;
        switch (comparison) {
            case LESS: {
                result = this.records.getKeysInRange(null, true, value, false, descending);
                break;
            }
            case LESS_OR_EQUAL: {
                result = this.records.getKeysInRange(null, true, value, true, descending);
                break;
            }
            case GREATER: {
                result = this.records.getKeysInRange(value, false, null, true, descending);
                break;
            }
            case GREATER_OR_EQUAL: {
                result = this.records.getKeysInRange(value, true, null, true, descending);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized comparison: " + (Object)((Object)comparison));
            }
        }
        return result;
    }

    int getNodeSize() {
        return this.records.getNodeSize();
    }

    static class ConcatIterator<T>
    implements Iterator<T> {
        private final Iterator<T>[] iterators;
        private int current;

        ConcatIterator(Iterator<T> ... iterators) {
            this.iterators = iterators;
            this.current = 0;
            this.moveNext();
        }

        private void moveNext() {
            while (this.current < this.iterators.length && !this.iterators[this.current].hasNext()) {
                ++this.current;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current >= this.iterators.length) {
                return false;
            }
            if (!this.iterators[this.current].hasNext()) {
                this.moveNext();
            }
            return this.current < this.iterators.length;
        }

        @Override
        public T next() {
            if (this.current == this.iterators.length) {
                throw new NoSuchElementException();
            }
            T res = this.iterators[this.current].next();
            this.moveNext();
            return res;
        }
    }

    class FullScanIterator
    implements Iterator<QueryableEntry> {
        private Iterator<QueryableEntry> iterator;
        private Iterator<QueryableEntry> nullValueIterator;
        private Iterator<QueryableEntry> nonNullValueIterator;
        private final boolean descending;

        FullScanIterator(boolean descending) {
            if (descending) {
                this.nonNullValueIterator = HDBaseConcurrentIndexStore.this.records.getKeysInRange(null, true, null, true, descending);
                this.iterator = this.nonNullValueIterator;
            } else {
                this.nullValueIterator = HDBaseConcurrentIndexStore.this.recordsWithNullValue.getKeysInRange(null, true, null, true, descending);
                this.iterator = this.nullValueIterator;
            }
            this.descending = descending;
        }

        @Override
        public boolean hasNext() {
            if (!this.iterator.hasNext()) {
                if (this.descending) {
                    if (this.nullValueIterator == null) {
                        this.nullValueIterator = HDBaseConcurrentIndexStore.this.recordsWithNullValue.getKeysInRange(null, true, null, true, this.descending);
                        this.iterator = this.nullValueIterator;
                        return this.iterator.hasNext();
                    }
                    return false;
                }
                if (this.nonNullValueIterator == null) {
                    this.nonNullValueIterator = HDBaseConcurrentIndexStore.this.records.getKeysInRange(null, true, null, true, this.descending);
                    this.iterator = this.nonNullValueIterator;
                    return this.iterator.hasNext();
                }
                return false;
            }
            return true;
        }

        @Override
        public QueryableEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }
    }
}

