/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.internal.tcnative.SSL;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class OpenSSLEngineFactory
extends SSLEngineFactorySupport
implements SSLEngineFactory {
    public static final String KEY_FILE = "keyFile";
    public static final String KEY_PASSWORD = "keyPassword";
    public static final String KEY_CERT_CHAIN_FILE = "keyCertChainFile";
    public static final String TRUST_CERT_COLLECTION_FILE = "trustCertCollectionFile";
    public static final String FIPS_MODE = "fipsMode";
    private final ILogger logger = Logger.getLogger(OpenSSLEngineFactory.class);
    private List<String> cipherSuites;
    private ClientAuth clientAuth;
    private String keyCertChainFile;
    private String keyFile;
    private String keyPassword;
    private String trustCertCollectionFile;

    List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void init(Properties properties, boolean forClient) throws Exception {
        this.load(properties);
        this.keyFile = OpenSSLEngineFactory.getProperty(properties, KEY_FILE);
        this.keyPassword = OpenSSLEngineFactory.getProperty(properties, KEY_PASSWORD);
        this.keyCertChainFile = OpenSSLEngineFactory.getProperty(properties, KEY_CERT_CHAIN_FILE);
        this.trustCertCollectionFile = OpenSSLEngineFactory.getProperty(properties, TRUST_CERT_COLLECTION_FILE);
        this.cipherSuites = this.loadCipherSuites(properties);
        this.protocol = this.loadProtocol(properties);
        this.clientAuth = this.loadClientAuth(properties);
        OpenSsl.ensureAvailability();
        if (Boolean.valueOf(OpenSSLEngineFactory.getProperty(properties, FIPS_MODE)).booleanValue()) {
            this.logger.info("Enabling OpenSSL in FIPS mode.");
            SSL.fipsModeSet((int)1);
            this.logger.info("OpenSSL is enabled in FIPS mode.");
        }
        this.logInit();
        this.sanityCheck(forClient);
    }

    private void logInit() {
        this.logger.info("Using OpenSSL for SSL encryption.");
        if (this.logger.isFineEnabled()) {
            this.logger.fine("ciphersuites: " + (this.cipherSuites.isEmpty() ? "default" : this.cipherSuites));
            this.logger.fine("clientAuth: " + this.clientAuth);
        }
    }

    private String loadProtocol(Properties properties) {
        String protocol = OpenSSLEngineFactory.getProperty(properties, "protocol", "TLSv1.2");
        if ("TLS".equals(protocol)) {
            protocol = "TLSv1.2";
            this.logger.warning("Protocol [TLS] has been cast to [TLSv1.2]");
        } else if ("SSL".equals(protocol)) {
            protocol = "SSLv3";
            this.logger.warning("Protocol [SSL] has been cast to [SSLv3]");
        }
        return protocol;
    }

    private void sanityCheck(boolean forClient) throws SSLException {
        if (forClient) {
            this.sanityCheck0(true);
        } else {
            this.sanityCheck0(false);
            this.sanityCheck0(true);
        }
    }

    private void sanityCheck0(boolean clientMode) throws SSLException {
        SSLEngine serverEngine = this.create(clientMode, null);
        serverEngine.closeInbound();
        serverEngine.closeOutbound();
    }

    private List<String> loadCipherSuites(Properties properties) {
        String[] items = OpenSSLEngineFactory.getProperty(properties, "ciphersuites", "").split(",");
        ArrayList<String> cipherSuites = new ArrayList<String>(items.length);
        for (String item : items) {
            String trim = item.trim();
            if (trim.length() <= 0) continue;
            cipherSuites.add(trim);
        }
        return cipherSuites;
    }

    private ClientAuth loadClientAuth(Properties properties) {
        String mutualAuthentication = OpenSSLEngineFactory.getProperty(properties, "mutualAuthentication");
        if (mutualAuthentication == null) {
            return ClientAuth.NONE;
        }
        if ("REQUIRED".equals(mutualAuthentication)) {
            return ClientAuth.REQUIRE;
        }
        if ("OPTIONAL".equals(mutualAuthentication)) {
            return ClientAuth.OPTIONAL;
        }
        throw new IllegalArgumentException(String.format("Unrecognized value [%s] for [%s]", mutualAuthentication, "javax.net.ssl.mutualAuthentication"));
    }

    @Override
    public SSLEngine create(boolean clientMode, Address peerAddress) {
        try {
            SslContext context = this.createSslContext(clientMode);
            SSLEngine engine = peerAddress == null ? context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT) : context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, peerAddress.getHost(), peerAddress.getPort());
            engine.setEnabledProtocols(new String[]{this.protocol});
            return engine;
        }
        catch (SSLException e) {
            if (e.getMessage() != null && e.getMessage().contains("cipher suite")) {
                throw new InvalidConfigurationException(e.getMessage(), e);
            }
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().contains("Protocol") && e.getMessage().contains("is not supported")) {
                throw new InvalidConfigurationException(e.getMessage(), e);
            }
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    protected SslContext createSslContext(boolean clientMode) throws SSLException {
        SslContextBuilder builder = this.createSslContextBuilder(clientMode);
        if (this.trustCertCollectionFile != null) {
            builder.trustManager(new File(this.trustCertCollectionFile));
        } else {
            builder.trustManager(this.tmf);
        }
        if (!this.cipherSuites.isEmpty()) {
            builder.ciphers(this.cipherSuites);
        }
        builder.sslProvider(SslProvider.OPENSSL);
        return builder.build();
    }

    private SslContextBuilder createSslContextBuilder(boolean clientMode) {
        SslContextBuilder builder;
        File key;
        File certChain = this.keyCertChainFile != null ? new File(this.keyCertChainFile) : null;
        File file = key = this.keyFile != null ? new File(this.keyFile) : null;
        if (clientMode) {
            builder = SslContextBuilder.forClient();
            if (key != null) {
                builder.keyManager(certChain, key, this.keyPassword);
            } else {
                builder.keyManager(this.kmf);
            }
        } else {
            builder = key != null ? SslContextBuilder.forServer((File)certChain, (File)key, (String)this.keyPassword) : SslContextBuilder.forServer((KeyManagerFactory)this.kmf);
            builder.clientAuth(this.clientAuth);
        }
        return builder;
    }
}

