/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class WanEnterpriseMapEvent<T>
implements InternalWanEvent<T> {
    private Set<String> clusterNames = new HashSet<String>();
    private String mapName;
    private int backupCount;
    private long creationTime;

    public WanEnterpriseMapEvent(String mapName, int backupCount) {
        this.mapName = mapName;
        this.backupCount = backupCount;
        this.creationTime = Clock.currentTimeMillis();
    }

    public WanEnterpriseMapEvent() {
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public int getBackupCount() {
        return this.backupCount;
    }

    @Override
    @Nonnull
    public Set<String> getClusterNames() {
        return this.clusterNames;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeInt(this.backupCount);
        out.writeInt(this.clusterNames.size());
        for (String clusterName : this.clusterNames) {
            out.writeString(clusterName);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.backupCount = in.readInt();
        int clusterNameCount = in.readInt();
        for (int i = 0; i < clusterNameCount; ++i) {
            this.clusterNames.add(in.readString());
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    @Nonnull
    public String getObjectName() {
        return this.mapName;
    }

    @Override
    @Nonnull
    public String getServiceName() {
        return "hz:impl:mapService";
    }
}

