/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.wan.MapWanEventFilter;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MapFilterProvider {
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<String, MapWanEventFilter> filterByClassName;
    private final ConstructorFunction<String, MapWanEventFilter> filterConstructorFunction = new ConstructorFunction<String, MapWanEventFilter>(){

        @Override
        public MapWanEventFilter createNew(String className) {
            try {
                return (MapWanEventFilter)ClassLoaderUtil.newInstance(MapFilterProvider.this.nodeEngine.getConfigClassLoader(), className);
            }
            catch (Exception e) {
                MapFilterProvider.this.nodeEngine.getLogger(this.getClass()).severe(e);
                throw ExceptionUtil.rethrow(e);
            }
        }
    };

    public MapFilterProvider(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.filterByClassName = new ConcurrentHashMap<String, MapWanEventFilter>();
    }

    public MapWanEventFilter getFilter(String className) {
        Preconditions.checkNotNull(className, "Class name is mandatory!");
        return ConcurrencyUtil.getOrPutIfAbsent(this.filterByClassName, className, this.filterConstructorFunction);
    }
}

