/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreHelper;
import com.hazelcast.internal.hotrestart.RecordDataSink;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.hotrestart.impl.SimpleHandleOffHeap;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.EnterpriseRecordStore;
import com.hazelcast.map.impl.recordstore.HotRestartHDStorageImpl;
import com.hazelcast.map.impl.recordstore.HotRestartStorage;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.memory.NativeOutOfMemoryError;

public class HDMapRamStoreImpl
implements RamStore {
    private static final int REMOVE_NULL_ENTRIES_BATCH_SIZE = 1024;
    private final EnterpriseRecordStore recordStore;
    private final HazelcastMemoryManager memoryManager;
    private final HotRestartHDStorageImpl storage;
    private final Object mutex;
    private final ExpirySystem expirySystem;

    public HDMapRamStoreImpl(EnterpriseRecordStore recordStore, HazelcastMemoryManager memoryManager) {
        this.recordStore = recordStore;
        this.memoryManager = memoryManager;
        this.storage = (HotRestartHDStorageImpl)recordStore.getStorage();
        this.mutex = this.storage.getMutex();
        this.expirySystem = this.storage.expirySystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyEntry(KeyHandle keyHandle, int expectedSize, RecordDataSink sink) throws HotRestartException {
        KeyHandleOffHeap kh = (KeyHandleOffHeap)keyHandle;
        Object object = this.mutex;
        synchronized (object) {
            NativeMemoryData key = RamStoreHelper.validateAndGetKey(kh, this.memoryManager);
            if (key == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
            HDRecord record = (HDRecord)this.storage.getIfSameKey(key);
            return record != null && RamStoreHelper.copyEntry(kh, key, record, expectedSize, sink);
        }
    }

    @Override
    public KeyHandle toKeyHandle(byte[] keyBytes) {
        HeapData keyData = new HeapData(keyBytes);
        long nativeKeyAddress = this.storage.getNativeKeyAddress(keyData);
        if (nativeKeyAddress != 0L) {
            return this.readExistingKeyHandle(nativeKeyAddress);
        }
        return this.newKeyHandle(keyData);
    }

    private KeyHandleOffHeap readExistingKeyHandle(long nativeKeyAddress) {
        NativeMemoryData keyData = new NativeMemoryData().reset(nativeKeyAddress);
        HDRecord record = (HDRecord)this.storage.get(keyData);
        return new SimpleHandleOffHeap(keyData.address(), record.getSequence());
    }

    private KeyHandleOffHeap newKeyHandle(HeapData keyData) {
        NativeMemoryData nativeKey = null;
        try {
            nativeKey = this.storage.toNative(keyData);
            long now = Clock.currentTimeMillis();
            Record record = this.recordStore.createRecord(nativeKey, null, now);
            this.storage.putTransient(nativeKey, (HDRecord)record);
            this.expirySystem.add((Data)nativeKey, record.getLastUpdateTime(), now);
            SimpleHandleOffHeap simpleHandleOffHeap = new SimpleHandleOffHeap(nativeKey.address(), record.getSequence());
            return simpleHandleOffHeap;
        }
        catch (NativeOutOfMemoryError e) {
            if (nativeKey != null && nativeKey.address() != 0L) {
                this.storage.getStorageImpl().getRecordProcessor().disposeData(keyData);
            }
            throw e;
        }
        finally {
            this.storage.disposeDeferredBlocks();
        }
    }

    @Override
    public void removeNullEntries(SetOfKeyHandle keyHandles) {
        SetOfKeyHandle.KhCursor cursor = keyHandles.cursor();
        NativeMemoryData key = new NativeMemoryData();
        long removedCount = 0L;
        while (cursor.advance()) {
            KeyHandleOffHeap keyHandleOffHeap = (KeyHandleOffHeap)cursor.asKeyHandle();
            key.reset(keyHandleOffHeap.address());
            HDRecord record = (HDRecord)this.storage.get(key);
            assert (record != null);
            assert (record.getSequence() == keyHandleOffHeap.sequenceId());
            this.storage.removeTransient(key, record);
            this.expirySystem.removeKeyFromExpirySystem(key);
            if (++removedCount % 1024L != 0L) continue;
            this.storage.disposeDeferredBlocks();
        }
        this.storage.disposeDeferredBlocks();
    }

    @Override
    public void accept(KeyHandle kh, byte[] valueBytes) {
        HeapData value = new HeapData(valueBytes);
        HotRestartStorage storage = (HotRestartStorage)this.recordStore.getStorage();
        KeyHandleOffHeap keyHandleOffHeap = (KeyHandleOffHeap)kh;
        NativeMemoryData key = new NativeMemoryData().reset(keyHandleOffHeap.address());
        Record record = (Record)storage.get(key);
        assert (record != null);
        storage.updateTransient(key, record, value);
        this.expirySystem.add((Data)key, record.getLastUpdateTime(), Clock.currentTimeMillis());
        this.recordStore.disposeDeferredBlocks();
    }
}

