/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.map.NativeBehmSlotAccessorFactory;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.HDJsonMetadataRecordProcessor;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.map.impl.record.HDJsonMetadataRecord;
import com.hazelcast.map.impl.record.HDJsonMetadataRecordAccessor;
import com.hazelcast.map.impl.record.HDJsonMetadataRecordFactory;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.query.impl.JsonMetadata;

public class HDJsonMetadataStorageImpl
implements JsonMetadataStore {
    private final HDJsonMetadataRecordFactory recordFactory;
    private final HDJsonMetadataRecordProcessor recordProcessor;
    private final BinaryElasticHashMap<HDJsonMetadataRecord> store;

    public HDJsonMetadataStorageImpl(EnterpriseSerializationService ess, HiDensityStorageInfo storageInfo) {
        HDJsonMetadataRecordAccessor recordAccessor = new HDJsonMetadataRecordAccessor(ess);
        this.recordProcessor = new HDJsonMetadataRecordProcessor(ess, recordAccessor, storageInfo);
        this.recordFactory = new HDJsonMetadataRecordFactory(this.recordProcessor);
        NativeBehmSlotAccessorFactory behmSlotAccessorFactory = new NativeBehmSlotAccessorFactory();
        this.store = new BinaryElasticHashMap<HDJsonMetadataRecord>(128, 0.6f, behmSlotAccessorFactory, this.recordProcessor);
    }

    @Override
    public JsonMetadata get(Data key) {
        return (JsonMetadata)this.store.get(key);
    }

    @Override
    public void set(Data key, JsonMetadata metadata) {
        HDJsonMetadataRecord record = (HDJsonMetadataRecord)this.store.get(key);
        if (record == null) {
            HDJsonMetadataRecord metadataRecord = this.recordFactory.newRecord(metadata);
            this.store.put(key, metadataRecord);
        } else {
            this.recordProcessor.disposeMetadataKeyValue(record);
            Data keyData = this.recordProcessor.toData(metadata.getKeyMetadata(), DataType.NATIVE);
            Data valueData = this.recordProcessor.toData(metadata.getValueMetadata(), DataType.NATIVE);
            record.setKey(keyData);
            record.setValue(valueData);
        }
    }

    @Override
    public void setKey(Data key, Object metadataKey) {
        HDJsonMetadataRecord record = (HDJsonMetadataRecord)this.store.get(key);
        if (record == null) {
            if (metadataKey == null) {
                return;
            }
            HDJsonMetadataRecord metadataRecord = this.recordFactory.newRecord(metadataKey, true);
            this.store.put(key, metadataRecord);
        } else {
            this.recordProcessor.disposeMetadataKeyValue(record, true);
            Data keyData = this.recordProcessor.toData(metadataKey, DataType.NATIVE);
            record.setKey(keyData);
            if (record.getKeyAddress() == 0L && record.getValueAddress() == 0L) {
                this.store.remove(key);
                this.recordProcessor.dispose(record);
            }
        }
    }

    @Override
    public void setValue(Data key, Object metadataValue) {
        HDJsonMetadataRecord record = (HDJsonMetadataRecord)this.store.get(key);
        if (record == null) {
            if (metadataValue == null) {
                return;
            }
            HDJsonMetadataRecord metadataRecord = this.recordFactory.newRecord(metadataValue, false);
            this.store.put(key, metadataRecord);
        } else {
            this.recordProcessor.disposeMetadataKeyValue(record, false);
            Data valueData = this.recordProcessor.toData(metadataValue, DataType.NATIVE);
            record.setValue(valueData);
            if (record.getKeyAddress() == 0L && record.getValueAddress() == 0L) {
                this.store.delete(key);
            }
        }
    }

    @Override
    public void remove(Data key) {
        this.store.delete(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void destroy() {
        HazelcastMemoryManager memoryManager = this.recordProcessor.getMemoryManager();
        if (memoryManager == null || memoryManager.isDisposed()) {
            return;
        }
        this.store.dispose();
    }
}

