/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;

public class HDRecordWithStats
extends HDRecord
implements Record<Data> {
    static final int METADATA_SIZE = 28;
    static final int SIZE = 36;
    static final int VALUE_OFFSET = 0;
    static final int VERSION_OFFSET = 8;
    static final int CREATION_TIME_OFFSET = 12;
    static final int LAST_ACCESS_TIME_OFFSET = 16;
    static final int LAST_UPDATE_TIME_OFFSET = 20;
    static final int HITS_OFFSET = 24;
    static final int LAST_STORED_TIME_OFFSET = 28;
    static final int SEQUENCE_OFFSET = 32;

    public HDRecordWithStats(HiDensityRecordAccessor recordAccessor) {
        super(GlobalMemoryAccessorRegistry.AMEM, recordAccessor);
    }

    @Override
    protected int getSizeInternal() {
        return 36;
    }

    @Override
    public long getSequence() {
        return this.readInt(32L);
    }

    @Override
    public void setSequence(long sequence) {
        this.writeInt(32L, (int)sequence);
    }

    @Override
    public int getVersion() {
        return this.readInt(8L);
    }

    @Override
    public void setVersion(int version) {
        this.writeInt(8L, version);
    }

    @Override
    public long getCreationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(12L));
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.writeInt(12L, TimeStripUtil.stripBaseTime(creationTime));
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(16L));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.writeInt(16L, TimeStripUtil.stripBaseTime(lastAccessTime));
    }

    @Override
    public long getLastUpdateTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(20L));
    }

    @Override
    public void setLastUpdateTime(long lastUpdatedTime) {
        this.writeInt(20L, TimeStripUtil.stripBaseTime(lastUpdatedTime));
    }

    @Override
    public int getHits() {
        return this.readInt(24L);
    }

    @Override
    public void setHits(int hits) {
        this.writeInt(24L, hits);
    }

    @Override
    public long getLastStoredTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(28L));
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.writeInt(28L, TimeStripUtil.stripBaseTime(lastStoredTime));
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER;
    }

    @Override
    public int getRawCreationTime() {
        return this.readInt(12L);
    }

    @Override
    public void setRawCreationTime(int time) {
        this.writeInt(12L, time);
    }

    @Override
    public int getRawLastAccessTime() {
        return this.readInt(16L);
    }

    @Override
    public void setRawLastAccessTime(int time) {
        this.writeInt(16L, time);
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.readInt(20L);
    }

    @Override
    public void setRawLastUpdateTime(int time) {
        this.writeInt(20L, time);
    }

    @Override
    public int getRawLastStoredTime() {
        return this.readInt(28L);
    }

    @Override
    public void setRawLastStoredTime(int time) {
        this.writeInt(28L, time);
    }
}

