/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;

public enum DeleteOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            Record record = recordStore.getRecordOrNull(state.getKey(), false);
            state.setOldValue(record == null ? null : record.getValue());
            state.setRecordExistsInMemory(record != null);
            if (record != null) {
                Object oldValue = record.getValue();
                oldValue = mapServiceContext.interceptRemove(mapContainer.getInterceptorRegistry(), oldValue);
                if (oldValue != null) {
                    state.setOldValue(oldValue);
                }
            }
        }

        @Override
        public Step nextStep(State state) {
            return DELETE;
        }
    }
    ,
    DELETE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            if (recordStore.persistenceEnabledFor(state.getCallerProvenance())) {
                MapDataStore<Data, Object> mapDataStore = recordStore.getMapDataStore();
                mapDataStore.remove(state.getKey(), state.getNow(), state.getTxnId());
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.isRecordExistsInMemory() ? ON_DELETE : UtilSteps.SEND_RESPONSE;
        }
    }
    ,
    ON_DELETE{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            Record record = recordStore.getRecord(state.getKey());
            recordStore.removeRecord0(state.getKey(), record, false);
            recordStore.onStore(record);
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.SEND_RESPONSE;
        }
    };

}

