/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogReference;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogReferenceImpl;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.wan.impl.merkletree.ArrayMerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public class EnterprisePartitionContainer
extends PartitionContainer {
    private final ConcurrentMap<String, MerkleTree> merkleTrees;
    private final ConcurrentMap<String, HybridLogReferenceImpl> hybridLogRefs;
    private final ContextMutexFactory merkleTreesMutexFactory = new ContextMutexFactory();
    private final ContextMutexFactory hybridLogMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, MerkleTree> merkleTreeConstructor = mapName -> new ArrayMerkleTree(this.getMerkleTreeConfig((String)mapName).getDepth());

    public EnterprisePartitionContainer(MapService mapService, int partitionId) {
        super(mapService, partitionId);
        int expectedMerkleTrees = 0;
        Collection<MapConfig> mapConfigs = mapService.mapServiceContext.getNodeEngine().getConfig().getMapConfigs().values();
        for (MapConfig config : mapConfigs) {
            if (!mapService.mapServiceContext.shouldEnableMerkleTree(config, false)) continue;
            ++expectedMerkleTrees;
        }
        this.merkleTrees = MapUtil.createConcurrentHashMap(Math.max(expectedMerkleTrees, 1));
        int expectedHybridLogs = 0;
        for (MapConfig config : mapConfigs) {
            if (!config.getTieredStoreConfig().isEnabled()) continue;
            ++expectedHybridLogs;
        }
        this.hybridLogRefs = MapUtil.createConcurrentHashMap(Math.max(expectedHybridLogs, 1));
    }

    private MerkleTreeConfig getMerkleTreeConfig(String mapName) {
        MapServiceContext mapServiceContext = this.getMapService().getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        return nodeEngine.getConfig().findMapConfig(mapName).getMerkleTreeConfig();
    }

    @Override
    public void destroyMap(MapContainer mapContainer) {
        HybridLog hybridLog;
        super.destroyMap(mapContainer);
        this.merkleTrees.remove(mapContainer.getName());
        HybridLogReference hybridLogRef = (HybridLogReference)this.hybridLogRefs.remove(mapContainer.getName());
        if (hybridLogRef != null && (hybridLog = hybridLogRef.get()) != null) {
            hybridLog.dispose();
        }
    }

    public MerkleTree getOrCreateMerkleTree(String mapName) {
        MapConfig mapConfig = this.getMapService().mapServiceContext.getMapContainer((String)mapName).mapConfig;
        if (!this.getMapService().mapServiceContext.shouldEnableMerkleTree(mapConfig, true)) {
            return null;
        }
        return ConcurrencyUtil.getOrPutSynchronized(this.merkleTrees, mapName, this.merkleTreesMutexFactory, this.merkleTreeConstructor);
    }

    public MerkleTree getMerkleTreeOrNull(String mapName) {
        return (MerkleTree)this.merkleTrees.get(mapName);
    }

    public HybridLogReference getOrCreateHybridLogReference(String mapName) {
        MapConfig mapConfig = this.getMapService().mapServiceContext.getMapContainer((String)mapName).mapConfig;
        if (!mapConfig.getTieredStoreConfig().isEnabled()) {
            return null;
        }
        return ConcurrencyUtil.getOrPutSynchronized(this.hybridLogRefs, mapName, this.hybridLogMutexFactory, this::createHybridLogReference);
    }

    public HybridLog getHybridLogOrNull(String mapName) {
        MapConfig mapConfig = this.getMapService().mapServiceContext.getMapContainer((String)mapName).mapConfig;
        if (!mapConfig.getTieredStoreConfig().isEnabled()) {
            return null;
        }
        HybridLogReferenceImpl hybridLogRef = (HybridLogReferenceImpl)this.hybridLogRefs.get(mapName);
        return hybridLogRef != null ? hybridLogRef.get() : null;
    }

    private HybridLogReferenceImpl createHybridLogReference(String mapName) {
        return new HybridLogReferenceImpl(() -> (HybridLogImpl)this.createHybridLog(mapName));
    }

    @Override
    protected void cleanUpMap(String mapName) {
        this.merkleTrees.remove(mapName);
        HybridLogReferenceImpl hybridLogRef = (HybridLogReferenceImpl)this.hybridLogRefs.remove(mapName);
        if (hybridLogRef != null) {
            HybridLog hybridLog = hybridLogRef.get();
            if (hybridLog != null) {
                hybridLog.dispose();
            }
            hybridLogRef.clear();
        }
    }

    private HybridLog createHybridLog(String mapName) {
        MapServiceContext mapServiceContext = this.getMapService().mapServiceContext;
        NodeEngineImpl nodeEngine = (NodeEngineImpl)mapServiceContext.getNodeEngine();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
        TieredStoreService tieredStoreService = nodeExtension.getTieredStoreService();
        return tieredStoreService.createHybridLog(TieredStoreUser.IMAP, mapName, this.getPartitionId());
    }
}

