/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutor;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutorImpl;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePoolImpl;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogConfiguration;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.internal.tstore.service.impl.TieredStoreConfigValidator;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImplMetrics;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.memory.Capacity;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.File;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class TieredStoreServiceImpl
implements TieredStoreService,
DynamicMetricsProvider {
    static final String LOGGER_NAME = "TStore:Service";
    private static final int HLOG_PAGE_SIZE_BYTES = 0x100000;
    private static final double HLOG_READONLY_PERCENTAGE = 0.1;
    private static final int MAX_PENDING_OPS = 100;
    private static final int EPOCH_MAX_THREADS_SUPPORTED = 4 * Runtime.getRuntime().availableProcessors();
    private static final int MAX_DIR_CREATION_ATTEMPTS = 10;
    private final Node node;
    private final ILogger logger;
    private final Supplier<MemoryAllocator> memoryAllocatorSupplier;
    private final AtomicInteger storeIdSeq = new AtomicInteger();
    private final ConcurrentMap<String, DeviceOperationExecutor> deviceExecutors;
    private final ConcurrentMap<TStoreUserId, HybridLogFactory> hybridLogFactories;
    private final ConcurrentMap<TStoreUserId, HybridLogForGlobalIndexFactory> hybridLogForGlobalIndexFactories;
    private final ConcurrentMap<String, CompactionStats> deviceCompactionStats;
    private final ConcurrentMap<String, CompactionManager> deviceCompactionManagers;
    private final TieredStoreServiceImplMetrics metrics = new TieredStoreServiceImplMetrics();
    private volatile Epoch epoch;
    private volatile MemoryAllocator memoryAllocator;
    private volatile PagePool pagePool;

    TieredStoreServiceImpl(Node node, Supplier<MemoryAllocator> memoryAllocatorSupplier) {
        this.node = node;
        this.logger = node.getLogger(LOGGER_NAME);
        this.memoryAllocatorSupplier = memoryAllocatorSupplier;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Enabling tiered store");
        }
        Config config = node.getConfig();
        TieredStoreConfigValidator.validate(config);
        this.logMinimumClusterSize(config);
        this.deviceExecutors = MapUtil.createConcurrentHashMap(1);
        this.hybridLogFactories = MapUtil.createConcurrentHashMap(1);
        this.hybridLogForGlobalIndexFactories = MapUtil.createConcurrentHashMap(1);
        int deviceCnt = config.getDeviceConfigs().size();
        this.deviceCompactionStats = MapUtil.createConcurrentHashMap(deviceCnt);
        this.deviceCompactionManagers = MapUtil.createConcurrentHashMap(deviceCnt);
        config.getDeviceConfigs().values().forEach(this::addDevice);
    }

    private void logMinimumClusterSize(Config config) {
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        long totalMemoryRequiredClusterWide = config.getMapConfigs().values().stream().filter(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled()).mapToLong(mapConfig -> (long)(mapConfig.getTotalBackupCount() + 1) * mapConfig.getTieredStoreConfig().getMemoryTierConfig().getCapacity().bytes()).sum();
        double perMemberMemoryUsable = (double)nativeMemoryConfig.getSize().bytes() * ((100.0 - (double)nativeMemoryConfig.getMetadataSpacePercentage()) / 100.0) * 0.8;
        int requiredMembers = (int)Math.ceil((double)totalMemoryRequiredClusterWide / perMemberMemoryUsable);
        this.logger.info(String.format("Given the configured '%s' native memory, at least %d members should be in the cluster to prevent out of memory errors caused by tiered store operations", nativeMemoryConfig.getSize(), requiredMembers));
    }

    private void createHybridLogFactories() {
        Config config = this.node.getConfig();
        config.getMapConfigs().values().stream().filter(c -> c.getTieredStoreConfig().isEnabled()).forEach(mapConfig -> {
            String mapName = mapConfig.getName();
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("Enabling tiered store for map '%s' using device '%s'", mapName, mapConfig.getTieredStoreConfig().getDiskTierConfig().getDeviceName()));
            }
            int partitionCount = this.node.getPartitionService().getPartitionCount();
            this.metrics.registerMap(mapName);
            this.hybridLogFactories.put(new TStoreUserId(TieredStoreUser.IMAP, mapName), this.hybridLogFactory(mapConfig.getTieredStoreConfig(), TieredStoreUser.IMAP, partitionCount));
            for (IndexConfig indexConfig : mapConfig.getIndexConfigs()) {
                String indexName = IndexUtils.validateAndNormalize(mapName, indexConfig).getName();
                String btreeFactoryName = this.getActualNameForGlobalIndex(TieredStoreUser.BTREE, mapName, indexName);
                this.hybridLogForGlobalIndexFactories.put(new TStoreUserId(TieredStoreUser.BTREE, btreeFactoryName), this.hybridLogForGlobalIndexFactory(mapConfig.getTieredStoreConfig(), TieredStoreUser.BTREE));
            }
        });
    }

    @Nonnull
    private HybridLogFactory hybridLogFactory(TieredStoreConfig tieredStoreConfig, TieredStoreUser user, int partitionCount) {
        return (name, partitionId) -> {
            int pageSize = 0x100000;
            Capacity capacity = tieredStoreConfig.getMemoryTierConfig().getCapacity();
            long capacityBytes = capacity.bytes() / 2L;
            long perHybridLogCapacity = capacityBytes / (long)partitionCount;
            long desiredReadOnlyCapacity = (long)Math.ceil((double)perHybridLogCapacity * 0.1);
            int readOnlyPages = (int)Math.max(desiredReadOnlyCapacity / (long)pageSize, 1L);
            long desiredMutableCapacity = perHybridLogCapacity - desiredReadOnlyCapacity;
            int mutablePages = (int)Math.max(desiredMutableCapacity / (long)pageSize, 1L);
            HybridLogConfiguration config = new HybridLogConfiguration().setPageSize(pageSize).setReadOnlyPages(readOnlyPages).setMutablePages(mutablePages);
            int partitionDigits = (int)(Math.log10(partitionCount) + 1.0);
            String partitionIdStr = String.format("p%1$" + partitionDigits + "s", partitionId).replace(' ', '0');
            String hybridLogId = user.name().toLowerCase(Locale.ROOT) + File.separator + name + File.separator + partitionIdStr;
            return new HybridLogImpl(hybridLogId, config, this.epoch, this.pagePool, this.createDevice(tieredStoreConfig.getDiskTierConfig(), user, name, partitionId, partitionIdStr));
        };
    }

    @Nonnull
    private HybridLogForGlobalIndexFactory hybridLogForGlobalIndexFactory(TieredStoreConfig tieredStoreConfig, TieredStoreUser user) {
        return (mapName, indexConfig) -> {
            int pageSize = 0x100000;
            Capacity capacity = indexConfig.getBTreeIndexConfig().getMemoryTierConfig().getCapacity();
            long capacityBytes = capacity.bytes() / 2L;
            long desiredReadOnlyCapacity = (long)Math.ceil((double)capacityBytes * 0.1);
            int readOnlyPages = (int)Math.max(desiredReadOnlyCapacity / (long)pageSize, 1L);
            long desiredMutableCapacity = capacityBytes - desiredReadOnlyCapacity;
            int mutablePages = (int)Math.max(desiredMutableCapacity / (long)pageSize, 1L);
            HybridLogConfiguration config = new HybridLogConfiguration().setPageSize(pageSize).setReadOnlyPages(readOnlyPages).setMutablePages(mutablePages);
            String indexName = indexConfig.getName();
            String hybridLogId = user.name().toLowerCase(Locale.ROOT) + File.separator + mapName + File.separator + indexName;
            return new HybridLogImpl(hybridLogId, config, this.epoch, this.pagePool, this.createDevice(tieredStoreConfig.getDiskTierConfig(), user, mapName, 0, indexName));
        };
    }

    @Nonnull
    private Device createDevice(DiskTierConfig diskTierConfig, TieredStoreUser user, String name, int partitionId, String partitionIdStr) {
        String deviceName = diskTierConfig.getDeviceName();
        LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)this.node.getConfig().getDeviceConfig(deviceName);
        File storePath = Paths.get(localDeviceConfig.getBaseDir().getAbsolutePath(), user.name().toLowerCase(), name, partitionIdStr).toFile();
        for (int attempt = 0; attempt < 10 && !storePath.exists(); ++attempt) {
            if (!storePath.mkdirs() || !this.logger.isFineEnabled()) continue;
            this.logger.fine(String.format("Created directory '%s'", storePath));
        }
        if (!storePath.exists()) {
            throw new TStoreException(String.format("Unable to create directory '%s'", storePath));
        }
        CompactionStats compactionStats = (CompactionStats)Objects.requireNonNull(this.deviceCompactionStats.get(deviceName));
        int storeId = this.storeIdSeq.incrementAndGet();
        HybridLogFileHandlePoolImpl hybridLogFileHandlePool = new HybridLogFileHandlePoolImpl(storeId);
        return new LocalStorageDevice(storeId, new TStoreUserId(user, name), localDeviceConfig, 0x100000, storePath, hybridLogFileHandlePool, this.deviceOperationExecutor(deviceName), compactionStats, partitionId, true);
    }

    @Override
    @Nonnull
    public Epoch epoch() {
        return this.epoch;
    }

    @Override
    @Nonnull
    public DeviceOperationExecutor deviceOperationExecutor(String deviceName) {
        return (DeviceOperationExecutor)this.deviceExecutors.get(deviceName);
    }

    @Override
    public void addDevice(DeviceConfig deviceConfig) {
        if (this.logger.isFineEnabled() && deviceConfig.isLocal()) {
            LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
            this.logger.fine(String.format("Added local device '%s' with path '%s'", localDeviceConfig.getName(), localDeviceConfig.getBaseDir()));
        }
        ConcurrencyUtil.getOrPutIfAbsent(this.deviceExecutors, deviceConfig.getName(), deviceNameAsKey -> this.createDeviceOperationExecutor(deviceConfig));
        this.createCompactionManagersAndStats(deviceConfig);
        this.metrics.registerDevice(deviceConfig);
    }

    @Nonnull
    private DeviceOperationExecutorImpl createDeviceOperationExecutor(DeviceConfig deviceConfig) {
        assert (deviceConfig.isLocal());
        LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
        return new DeviceOperationExecutorImpl(localDeviceConfig.getWriteIOThreadCount(), localDeviceConfig.getReadIOThreadCount(), 100, localDeviceConfig.getBlockSize(), 0x100000, localDeviceConfig.getName());
    }

    @Override
    @Nonnull
    public HybridLog createHybridLog(TieredStoreUser user, String name, int partitionId) {
        HybridLogFactory factoryFn = this.getOrCreateHybridLog(user, name);
        return factoryFn.create(name, partitionId);
    }

    private HybridLogFactory getOrCreateHybridLog(TieredStoreUser user, String name) {
        String actualName = this.getActualName(user, name);
        TStoreUserId userId = new TStoreUserId(user, actualName);
        MapService mapService = (MapService)this.node.getNodeEngine().getService("hz:impl:mapService");
        int partitionCount = this.node.getNodeEngine().getPartitionService().getPartitionCount();
        TieredStoreConfig tstoreConfig = mapService.getMapServiceContext().getMapContainer(name).getMapConfig().getTieredStoreConfig();
        this.metrics.registerMap(actualName);
        return ConcurrencyUtil.getOrPutIfAbsent(this.hybridLogFactories, userId, k -> this.hybridLogFactory(tstoreConfig, user, partitionCount));
    }

    @Override
    @Nonnull
    public HybridLog createHybridLogForGlobalIndex(TieredStoreUser user, String name, IndexConfig indexConfig) {
        HybridLogForGlobalIndexFactory factoryFn = this.getOrCreateHybridLogForGlobalIndex(user, name, indexConfig);
        return factoryFn.create(name, indexConfig);
    }

    private HybridLogForGlobalIndexFactory getOrCreateHybridLogForGlobalIndex(TieredStoreUser user, String name, IndexConfig indexConfig) {
        String indexName = indexConfig.getName();
        String actualName = this.getActualNameForGlobalIndex(user, name, indexName);
        TStoreUserId userId = new TStoreUserId(user, actualName);
        MapService mapService = (MapService)this.node.getNodeEngine().getService("hz:impl:mapService");
        TieredStoreConfig tstoreConfig = mapService.getMapServiceContext().getMapContainer(name).getMapConfig().getTieredStoreConfig();
        return ConcurrencyUtil.getOrPutIfAbsent(this.hybridLogForGlobalIndexFactories, userId, k -> this.hybridLogForGlobalIndexFactory(tstoreConfig, user));
    }

    @Override
    public CompactionManager compactionManager(String deviceName) {
        return (CompactionManager)Objects.requireNonNull(this.deviceCompactionManagers.get(deviceName));
    }

    @Override
    public CompactionStats compactionStats(String deviceName) {
        return (CompactionStats)Objects.requireNonNull(this.deviceCompactionStats.get(deviceName));
    }

    private String getActualName(TieredStoreUser user, String name) {
        if (user == TieredStoreUser.IMAP) {
            MapConfig mapConfig = this.node.getConfig().findMapConfig(name);
            return mapConfig.getName();
        }
        throw new IllegalArgumentException(String.format("User '%s' is not supported", new Object[]{user}));
    }

    private String getActualNameForGlobalIndex(TieredStoreUser user, String mapName, String indexName) {
        if (user == TieredStoreUser.BTREE) {
            return mapName + "/" + indexName;
        }
        throw new IllegalArgumentException(String.format("User '%s' is not supported", new Object[]{user}));
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.memoryAllocator = this.memoryAllocatorSupplier.get();
        assert (this.memoryAllocator instanceof HazelcastMemoryManager);
        HazelcastMemoryManager memoryManager = (HazelcastMemoryManager)this.memoryAllocator;
        this.pagePool = new PagePool(memoryManager.getTieredStoreAllocator(), 0x100000, 1);
        this.epoch = new Epoch(EPOCH_MAX_THREADS_SUPPORTED, memoryManager.getSystemAllocator());
        this.createHybridLogFactories();
        ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        this.initCompactionManagersAndStats();
    }

    private void initCompactionManagersAndStats() {
        this.node.getConfig().getDeviceConfigs().values().forEach(this::createCompactionManagersAndStats);
    }

    private void createCompactionManagersAndStats(DeviceConfig deviceConfig) {
        String name = deviceConfig.getName();
        CompactionManager manager = ConcurrencyUtil.getOrPutIfAbsent(this.deviceCompactionManagers, name, k -> this.createCompactionManager());
        ConcurrencyUtil.getOrPutIfAbsent(this.deviceCompactionStats, name, k -> this.createCompactionStats(deviceConfig, manager));
    }

    private CompactionStats createCompactionStats(DeviceConfig deviceConfig, CompactionManager compactionManager) {
        return new CompactionStats(compactionManager, deviceConfig.getCapacity().bytes(), this.partitionCount());
    }

    private CompactionManager createCompactionManager() {
        return new CompactionManager(this.partitionCount());
    }

    private int partitionCount() {
        HazelcastProperties properties = this.node.getProperties();
        return properties.getInteger(ClusterProperty.PARTITION_COUNT);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.deviceExecutors.values().forEach(DeviceOperationExecutor::shutdown);
        this.deviceExecutors.clear();
        this.deviceCompactionManagers.values().forEach(CompactionManager::terminate);
        this.deviceCompactionManagers.clear();
        this.deviceCompactionStats.clear();
        this.hybridLogFactories.clear();
        this.hybridLogForGlobalIndexFactories.clear();
        this.metrics.clear();
        if (this.epoch != null) {
            this.epoch.close();
        }
        if (this.pagePool != null) {
            this.pagePool.close();
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Tiered store shutdown is completed");
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        this.metrics.provideDynamicMetrics(descriptor, context, this.node);
    }

    public Node getNode() {
        return this.node;
    }

    public TieredStoreServiceImplMetrics getMetrics() {
        return this.metrics;
    }

    public long getEpochAndPagePoolNativeCommit() {
        return this.pagePool.nativeMemoryConsumptionBytes() + this.epoch.nativeMemoryConsumptionBytes();
    }

    private static interface HybridLogForGlobalIndexFactory {
        public HybridLog create(String var1, IndexConfig var2);
    }

    private static interface HybridLogFactory {
        public HybridLog create(String var1, int var2);
    }
}

