/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.config.Config;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.impl.ThrowingTieredStoreServiceImpl;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.logging.ILogger;
import java.util.function.Supplier;

public final class TieredStoreServiceFactory {
    private TieredStoreServiceFactory() {
    }

    public static TieredStoreService create(Node node, Supplier<MemoryAllocator> memoryAllocatorSupplier) {
        ILogger logger = node.getLogger("TStore:Service");
        if (TieredStoreServiceFactory.tieredStoreEnabled(node.getConfig())) {
            return new TieredStoreServiceImpl(node, memoryAllocatorSupplier);
        }
        if (logger.isFineEnabled()) {
            logger.fine("Tiered store is disabled");
        }
        return new ThrowingTieredStoreServiceImpl();
    }

    private static boolean tieredStoreEnabled(Config config) {
        return config.getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
    }
}

