/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.tstore.hybridlog.HybridLogConfiguration;
import com.hazelcast.internal.tstore.hybridlog.impl.PageHeaderSupport;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import com.hazelcast.internal.tstore.hybridlog.impl.PageStateMachine;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.util.MutableLong;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;

class Pager
implements Disposable {
    static final AtomicIntegerFieldUpdater<Pager> FLUSHED_UNTIL_PAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Pager.class, "flushedUntilPage");
    static final AtomicIntegerFieldUpdater<Pager> FLUSHING_UNTIL_PAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Pager.class, "flushingUntilPage");
    static final AtomicIntegerFieldUpdater<Pager> TAIL_PAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Pager.class, "tailPage");
    static final AtomicIntegerFieldUpdater<Pager> HEAD_PAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Pager.class, "headPage");
    private static final int FREE_PAGE_SLOT = -1;
    final int pageSize;
    final int pageMask;
    final int offsetMask;
    final int totalPages;
    final int pageSizeBits;
    final int readOnlyPages;
    final int mutablePages;
    final int pagesCapacity;
    final AtomicInteger pinnedPages = new AtomicInteger();
    final PageStateMachine pageStateMachine;
    volatile int flushedUntilPage;
    volatile int flushingUntilPage;
    volatile int closedUntilPage;
    volatile int tailPage;
    volatile int headPage;
    private final AtomicLongArray pageTable;
    private final AtomicIntegerArray pageIdTable;
    private final AtomicInteger acquiredPages = new AtomicInteger();
    private final ILogger logger = Logger.getLogger(Pager.class);
    private final String hybridLogId;
    private final PagePool pagePool;

    Pager(String hybridLogId, PagePool pagePool, HybridLogConfiguration config) {
        this.hybridLogId = hybridLogId;
        this.pageSize = config.getPageSize();
        this.offsetMask = this.pageSize - 1;
        this.readOnlyPages = config.getReadOnlyPages();
        this.mutablePages = config.getMutablePages();
        this.pagePool = pagePool;
        this.totalPages = this.readOnlyPages + this.mutablePages;
        this.pageMask = ~this.offsetMask;
        this.pageSizeBits = QuickMath.log2(this.pageSize);
        this.pagesCapacity = config.getBorrowCapacityScale() * this.totalPages;
        this.pageTable = new AtomicLongArray(this.pagesCapacity);
        this.pageIdTable = new AtomicIntegerArray(this.pagesCapacity);
        this.pageStateMachine = new PageStateMachine(hybridLogId, this.pagesCapacity, this::prettyFormatPage);
        for (int i = 0; i < this.pagesCapacity; ++i) {
            this.pageIdTable.set(i, -1);
        }
    }

    long asLogicalAddress(int page, int offset) {
        return (long)page << this.pageSizeBits | (long)offset;
    }

    int page(long logicalAddress) {
        return (int)((logicalAddress & (long)this.pageMask) >> this.pageSizeBits);
    }

    int offset(long logicalAddress) {
        return (int)(logicalAddress & (long)this.offsetMask);
    }

    int pageIndex(int page) {
        return page % this.pagesCapacity;
    }

    long asPhysicalAddress(long logicalAddress) {
        int page = this.page(logicalAddress);
        int offset = this.offset(logicalAddress);
        long pageAddress = this.pageAddress(page);
        return pageAddress + (long)offset;
    }

    long pageAddress(int page) {
        return this.pageTable.get(this.pageIndex(page));
    }

    long pageFirstSlotAddress(int page) {
        assert (this.verifyPage(page));
        return this.asLogicalAddress(page, 8);
    }

    long pageLastSlotAddress(int page) {
        assert (this.verifyPage(page));
        int lastOffset = PageHeaderSupport.readLastAllocatedOffset(this.pageAddress(page));
        return this.asLogicalAddress(page, lastOffset);
    }

    PageStateMachine.PageState pageState(int page) {
        return this.pageStateMachine.pageState(this.pageIndex(page));
    }

    boolean preparePage(int page) {
        PageStateMachine.PageState pageState = this.pageState(page);
        return (pageState == PageStateMachine.PageState.READY && this.pageId(this.pageIndex(page)) == page || pageState == PageStateMachine.PageState.NOT_BACKED && this.assignPage(page)) && this.activatePage(page);
    }

    private boolean assignPage(int page) {
        int pageIndex = this.pageIndex(page);
        MutableLong addressToRelease = new MutableLong();
        return this.pageStateMachine.assign(page, pageIndex, () -> {
            long pagePhysicalAddress = this.acquirePage();
            if (pagePhysicalAddress == 0L) {
                this.logger.severe(String.format("%s - Unable to allocate physical page for hybrid log page %s", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page)));
                return false;
            }
            if (this.pageTable.compareAndSet(pageIndex, 0L, pagePhysicalAddress)) {
                this.pageIdTable.set(pageIndex, page);
                if (this.logger.isFineEnabled()) {
                    this.logger.fine(String.format("%s - Assigned physical page at %s to back logical %s", TStoreUtil.hybridLogStr(this.hybridLogId), TStoreUtil.prettyFormatPhysical(pagePhysicalAddress), this.prettyFormatPage(page)));
                }
                return true;
            }
            addressToRelease.value = pagePhysicalAddress;
            return false;
        }, () -> {
            if (addressToRelease.value != 0L) {
                this.releasePage(addressToRelease.value);
            }
        });
    }

    private boolean activatePage(int page) {
        boolean activated;
        boolean bl = activated = this.pageId(this.pageIndex(page)) == page && this.pageStateMachine.activate(page, this.pageIndex(page));
        if (activated) {
            TStoreUtil.monotonicUpdate(this, TAIL_PAGE_UPDATER, page);
        }
        return activated;
    }

    private int pageId(int pageIndex) {
        return this.pageIdTable.get(pageIndex);
    }

    void recyclePage(int page) {
        assert (this.verifyPage(page));
        try {
            boolean recycled = this.borrowedPages() > 0 ? this.releasePage(page) : this.recyclePage0(page);
            if (!recycled) {
                this.logger.severe(String.format("%s - Could not release physical page backing logical %s%nPager state: %s", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page), this.debugInfo()));
            }
        }
        catch (Exception ex) {
            this.logger.severe(this.debugInfo(), ex);
            throw ex;
        }
    }

    private boolean releasePage(int page) {
        int pageIndex = this.pageIndex(page);
        return this.pageStateMachine.release(page, pageIndex, () -> this.releasePage0(page, pageIndex, this.pageTable.get(pageIndex), true));
    }

    private void releasePage0(int page, int pageIndex, long pagePhysicalAddress, boolean hardRelease) {
        long pagePhysicalAddressInSlot;
        if (hardRelease) {
            if (pagePhysicalAddress == 0L) {
                throw new IllegalArgumentException(String.format("%s - Attempted to release physical page backing %s with physical page address %s", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page), TStoreUtil.prettyFormatPhysical(pagePhysicalAddress)));
            }
            this.releasePage(pagePhysicalAddress);
        }
        if (!this.pageTable.compareAndSet(pageIndex, pagePhysicalAddressInSlot = this.pageTable.get(pageIndex), 0L)) {
            throw new ConcurrentModificationException(String.format("%s - The physical address of %s was concurrently modified while releasing the page was ongoing", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page)));
        }
        this.pageIdTable.set(pageIndex, -1);
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("%s - Released physical page at %s backing logical %s", TStoreUtil.hybridLogStr(this.hybridLogId), TStoreUtil.prettyFormatPhysical(pagePhysicalAddress), this.prettyFormatPage(page)));
        }
        TStoreUtil.monotonicUpdate(this, HEAD_PAGE_UPDATER, page + 1);
    }

    private boolean recyclePage0(int page) {
        int recycledPageIndex = this.pageIndex(page);
        long pagePhysicalAddress = this.pageTable.get(recycledPageIndex);
        return this.pageStateMachine.release(page, recycledPageIndex, () -> {
            this.releasePage0(page, recycledPageIndex, pagePhysicalAddress, false);
            for (int probes = 0; this.borrowedPages() == 0 && probes < this.pagesCapacity - 1; ++probes) {
                int candidatePage = this.tailPage + probes;
                int candidatePageIndex = this.pageIndex(candidatePage);
                PageStateMachine.PageState candidatePageState = this.pageStateMachine.pageState(candidatePageIndex);
                long candidatePagePhysicalAddress = this.pageTable.get(candidatePageIndex);
                if (candidatePageState != PageStateMachine.PageState.NOT_BACKED || !this.pageStateMachine.assign(candidatePage, candidatePageIndex, () -> {
                    this.pageIdTable.set(candidatePageIndex, candidatePage);
                    return this.pageTable.compareAndSet(candidatePageIndex, 0L, pagePhysicalAddress);
                }, () -> {
                    this.pageIdTable.set(candidatePageIndex, -1);
                    String message = String.format("%s - Invalid state, there must not be any physical page assigned to logical %s, but page with physical address %s is assigned", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(candidatePage), TStoreUtil.prettyFormatPhysical(candidatePagePhysicalAddress));
                    this.logger.severe(message, new IllegalStateException(message));
                })) continue;
                PageHeaderSupport.resetHighestAllocatedOffset(pagePhysicalAddress);
                if (this.logger.isFineEnabled()) {
                    this.logger.fine(String.format("%s - Physical page at %s used to back logical %s has been re-assigned to logical %s", TStoreUtil.hybridLogStr(this.hybridLogId), TStoreUtil.prettyFormatPhysical(pagePhysicalAddress), this.prettyFormatPage(page), this.prettyFormatPage(candidatePage)));
                }
                return;
            }
            this.releasePage0(page, recycledPageIndex, pagePhysicalAddress, true);
        });
    }

    boolean markPageReadOnly(int page) {
        assert (this.verifyPage(page));
        return this.pageStateMachine.readonly(page, this.pageIndex(page));
    }

    void markPageFlushing(int page) {
        assert (this.verifyPage(page));
        this.pageStateMachine.flush(page, this.pageIndex(page));
    }

    void markPageFlushed(int page) {
        assert (this.verifyPage(page));
        this.pageStateMachine.flushed(page, this.pageIndex(page));
    }

    boolean markPageReleasable(int page) {
        assert (this.verifyPage(page));
        return this.pageStateMachine.releasable(page, this.pageIndex(page));
    }

    boolean pinPage(int page) {
        assert (this.verifyPage(page));
        PageStateMachine.PinSuccessState successState = this.pageStateMachine.pinPage(page, this.pageIndex(page));
        if (successState == PageStateMachine.PinSuccessState.PINNED) {
            this.pinnedPages.getAndIncrement();
        }
        return successState.endsInPinnedPage();
    }

    boolean pinPageForUpdate(int page) {
        assert (this.verifyPage(page));
        PageStateMachine.PinSuccessState successState = this.pageStateMachine.pinPageForUpdate(page, this.pageIndex(page));
        if (successState == PageStateMachine.PinSuccessState.PINNED) {
            this.pinnedPages.getAndIncrement();
        }
        return successState.endsInPinnedPage();
    }

    void unpinPage(int page) {
        assert (this.verifyPage(page));
        if (this.pageStateMachine.unpinPage(page, this.pageIndex(page))) {
            this.pinnedPages.getAndDecrement();
        }
    }

    private long acquirePage() {
        long address = this.pagePool.acquire();
        if (address != 0L) {
            PageHeaderSupport.resetHighestAllocatedOffset(address);
            this.acquiredPages.getAndIncrement();
        }
        return address;
    }

    private void releasePage(long pagePhysicalAddress) {
        this.pagePool.release(pagePhysicalAddress);
        this.acquiredPages.getAndDecrement();
    }

    int acquiredPages() {
        return this.acquiredPages.get();
    }

    int borrowedPages() {
        return Math.max(this.acquiredPages() - this.capacity(), 0);
    }

    int pinnedPages() {
        return this.pinnedPages.get();
    }

    int capacity() {
        return this.totalPages;
    }

    int extendedCapacity() {
        return this.pagesCapacity;
    }

    @Override
    public void dispose() {
        for (int pageIndex = 0; pageIndex < this.pagesCapacity; ++pageIndex) {
            long pageAddress = this.pageTable.get(pageIndex);
            if (pageAddress == 0L || !this.pageTable.compareAndSet(pageIndex, pageAddress, 0L)) continue;
            this.pagePool.release(pageAddress);
            this.pageStateMachine.forceSetNotBacked(pageIndex);
            this.acquiredPages.decrementAndGet();
        }
    }

    long pageStartLogicalAddress(int page) {
        return this.asLogicalAddress(page, 0);
    }

    long pageEndLogicalAddress(int page) {
        return this.asLogicalAddress(page, this.pageSize - 1);
    }

    long pagePhysicalAddressStart(int page) {
        long pageHeadLogicalAddress = this.asLogicalAddress(page, 0);
        return this.asPhysicalAddress(pageHeadLogicalAddress);
    }

    private long pagePhysicalAddressEnd(int page) {
        long pageHeadLogicalAddress = this.asLogicalAddress(page, 0);
        return this.asPhysicalAddress(pageHeadLogicalAddress) + (long)this.pageSize - 1L;
    }

    String prettyFormat(long logicalAddress) {
        if (logicalAddress != Long.MAX_VALUE) {
            return "log:0x0" + String.format("%08x", logicalAddress) + '(' + "page:" + this.page(logicalAddress) + ',' + "offset:" + this.offset(logicalAddress) + ')';
        }
        return "log:<inf>(page:<inf>,offset:<inf>)";
    }

    String prettyFormatPage(int page) {
        int pageIndex = this.pageIndex(page);
        int pageAtIndex = this.pageIdTable.get(pageIndex);
        return String.format("page %d (idx:%d->%s, %s, %s)", new Object[]{page, pageIndex, pageAtIndex == -1 ? "FREE" : "page:" + pageAtIndex, this.pageStateMachine.pageState(pageIndex), TStoreUtil.prettyFormatPhysical(this.pageTable.get(pageIndex))});
    }

    private String pageIdStr(int pageIndex) {
        int pageId = this.pageId(pageIndex);
        return pageId == -1 ? "FREE" : Integer.toString(pageId);
    }

    String debugInfo() {
        StringBuilder sb = new StringBuilder();
        String ln = System.lineSeparator();
        String tab = "\t";
        int headPageCopy = this.headPage;
        int tailPageCopy = this.tailPage;
        sb.append(Thread.currentThread().getName()).append(" -- Pager#debugInfo:").append(ln).append(tab).append("totalPages=").append(this.totalPages).append(ln).append(tab).append("acquiredPages=").append(this.acquiredPages()).append(ln).append(tab).append("borrowedPages=").append(this.borrowedPages()).append(ln).append(tab).append("flushedUntilPage=").append(this.flushedUntilPage).append(ln).append(tab).append("flushingUntilPage=").append(this.flushingUntilPage).append(ln).append(tab).append("closedUntilPage=").append(this.closedUntilPage).append(ln).append(tab).append("pages=").append(this.debugPages()).append(ln).append(tab).append("headPage=").append(headPageCopy).append(ln).append(tab).append("tailPage=").append(tailPageCopy).append(ln).append(tab).append("index of headPage=").append(this.pageIndex(headPageCopy)).append(tab).append("index of tailPage=").append(this.pageIndex(tailPageCopy)).append(ln);
        return sb.toString();
    }

    private String debugPages() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.pagesCapacity; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.pageIdStr(i)).append(":").append((Object)this.pageStateMachine.pageState(i));
        }
        sb.append(']');
        return sb.toString();
    }

    boolean verifyPage(int page) {
        int pageAtIndex = this.pageIdTable.get(this.pageIndex(page));
        if (page != pageAtIndex) {
            throw new IllegalArgumentException(String.format("%s - Illegal attempt to access %s", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page)));
        }
        return true;
    }

    boolean verifyAccess(int page, long physicalAddress) {
        this.verifyPage(page);
        long pagePhysicalAddress = this.pageTable.get(this.pageIndex(page));
        long pagePhysicalAddressStart = this.pagePhysicalAddressStart(page);
        long pagePhysicalAddressEnd = this.pagePhysicalAddressEnd(page);
        if (pagePhysicalAddressStart == 0L) {
            throw new IllegalArgumentException(String.format("%s - attempted to access %s with %s, but the given page is not backed with physical memory", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page), TStoreUtil.prettyFormatPhysical(physicalAddress)));
        }
        if (pagePhysicalAddress >= pagePhysicalAddressStart && pagePhysicalAddress <= pagePhysicalAddressEnd) {
            return true;
        }
        throw new IllegalArgumentException(String.format("%s - attempted to access %s with %s, but the given address is not within the address range of the page", TStoreUtil.hybridLogStr(this.hybridLogId), this.prettyFormatPage(page), TStoreUtil.prettyFormatPhysical(physicalAddress)));
    }
}

