/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;

public class HybridLogImplMetrics {
    private static final int INIT_VALUE = -1;
    private static final double HUNDRED = 100.0;
    private final long initNanos = System.nanoTime();
    private volatile long totalPageWrites;
    @Probe(name="tstore.hlog.pageWriteDuration.avg", unit=ProbeUnit.NS)
    private volatile long pageWriteDurationAvgNs = -1L;
    @Probe(name="tstore.hlog.pageWriteDuration.min", unit=ProbeUnit.NS)
    private volatile long pageWriteDurationMinNs = -1L;
    @Probe(name="tstore.hlog.pageWriteDuration.max", unit=ProbeUnit.NS)
    private volatile long pageWriteDurationMaxNs = -1L;
    private volatile long totalRecordsRead;
    @Probe(name="tstore.hlog.readRecordDuration.avg", unit=ProbeUnit.NS)
    private volatile long readRecordDurationAvgNs = -1L;
    @Probe(name="tstore.hlog.readRecordDuration.min", unit=ProbeUnit.NS)
    private volatile long readRecordDurationMinNs = -1L;
    @Probe(name="tstore.hlog.readRecordDuration.max", unit=ProbeUnit.NS)
    private volatile long readRecordDurationMaxNs = -1L;
    @Probe(name="tstore.hlog.readRecord.hits", unit=ProbeUnit.COUNT)
    private volatile long readRecordHits;
    @Probe(name="tstore.hlog.readRecord.hit.percent", unit=ProbeUnit.PERCENT)
    private volatile double readRecordHitPercent;
    @Probe(name="tstore.hlog.readRecord.misses", unit=ProbeUnit.COUNT)
    private volatile long readRecordMisses;
    @Probe(name="tstore.hlog.readRecord.miss.percent", unit=ProbeUnit.PERCENT)
    private volatile double readRecordMissesPercent;
    @Probe(name="tstore.hlog.allocation.stall.avg", unit=ProbeUnit.NS)
    private volatile long allocationStallAvgNs = -1L;
    @Probe(name="tstore.hlog.allocation.stall.min", unit=ProbeUnit.NS)
    private volatile long allocationStallMinNs = -1L;
    @Probe(name="tstore.hlog.allocation.stall.max", unit=ProbeUnit.NS)
    private volatile long allocationStallMaxNs = -1L;
    @Probe(name="tstore.hlog.allocation.stall.total", unit=ProbeUnit.NS)
    private volatile long allocationStallTotalNs = -1L;
    private volatile long totalAllocationStalls;
    private volatile long totalAllocations;
    private volatile long totalPageAllocations;
    @Probe(name="tstore.hlog.allocation.size.avg", unit=ProbeUnit.BYTES)
    private volatile long allocationSizeAvg = -1L;
    @Probe(name="tstore.hlog.allocation.size.min", unit=ProbeUnit.BYTES)
    private volatile long allocationSizeMin = -1L;
    @Probe(name="tstore.hlog.allocation.size.max", unit=ProbeUnit.BYTES)
    private volatile long allocationSizeMax = -1L;
    @Probe(name="tstore.hlog.allocation.size.total", unit=ProbeUnit.BYTES)
    private volatile long allocationSizeTotal;
    @Probe(name="tstore.hlog.waste.alignment.avg", unit=ProbeUnit.BYTES)
    private volatile long wasteAlignmentAvg = -1L;
    @Probe(name="tstore.hlog.waste.alignment.min", unit=ProbeUnit.BYTES)
    private volatile long wasteAlignmentMin = -1L;
    @Probe(name="tstore.hlog.waste.alignment.max", unit=ProbeUnit.BYTES)
    private volatile long wasteAlignmentMax = -1L;
    @Probe(name="tstore.hlog.waste.alignment.total", unit=ProbeUnit.BYTES)
    private volatile long wasteAlignmentTotal;
    @Probe(name="tstore.hlog.waste.paging.avg", unit=ProbeUnit.BYTES)
    private volatile long wastePagingAvg = -1L;
    @Probe(name="tstore.hlog.waste.paging.min", unit=ProbeUnit.BYTES)
    private volatile long wastePagingMin = -1L;
    @Probe(name="tstore.hlog.waste.paging.max", unit=ProbeUnit.BYTES)
    private volatile long wastePagingMax = -1L;
    @Probe(name="tstore.hlog.waste.paging.total", unit=ProbeUnit.BYTES)
    private volatile long wastePagingTotal;
    @Probe(name="tstore.hlog.allocation.per.page.avg", unit=ProbeUnit.COUNT)
    private volatile long allocationPerPageAvg;
    @Probe(name="tstore.hlog.allocation.per.page.min", unit=ProbeUnit.COUNT)
    private volatile long allocationPerPageMin = -1L;
    @Probe(name="tstore.hlog.allocation.per.page.max", unit=ProbeUnit.COUNT)
    private volatile long allocationPerPageMax = -1L;
    @Probe(name="tstore.hlog.paging.frequency.avg", unit=ProbeUnit.NS)
    private volatile long pagingFrequencyAvg = -1L;
    @Probe(name="tstore.hlog.paging.frequency.min", unit=ProbeUnit.NS)
    private volatile long pagingFrequencyMin = -1L;
    @Probe(name="tstore.hlog.paging.frequency.max", unit=ProbeUnit.NS)
    private volatile long pagingFrequencyMax = -1L;
    private volatile long pageOpenNanos = System.nanoTime();
    private volatile long pageCount;

    void onPageWritten(long startNanos) {
        long durationNs = HybridLogImplMetrics.durationNsSince(startNanos);
        if (durationNs < this.pageWriteDurationMinNs || this.pageWriteDurationMinNs == -1L) {
            this.pageWriteDurationMinNs = durationNs;
        }
        if (durationNs > this.pageWriteDurationMaxNs) {
            this.pageWriteDurationMaxNs = durationNs;
        }
        this.pageWriteDurationAvgNs = (this.totalPageWrites * this.pageWriteDurationAvgNs + durationNs) / (this.totalPageWrites + 1L);
        ++this.totalPageWrites;
    }

    private static long durationNsSince(long startNanos) {
        return System.nanoTime() - startNanos;
    }

    void onRecordReadFromDeviceCompleted(long startNanos) {
        long durationNs = HybridLogImplMetrics.durationNsSince(startNanos);
        if (durationNs < this.readRecordDurationMinNs || this.readRecordDurationMinNs == -1L) {
            this.readRecordDurationMinNs = durationNs;
        }
        if (durationNs > this.readRecordDurationMaxNs) {
            this.readRecordDurationMaxNs = durationNs;
        }
        long totalRecordsReadCopy = this.totalRecordsRead + 1L;
        long readRecordDurationAvgNsCopy = this.readRecordDurationAvgNs;
        this.readRecordDurationAvgNs = (readRecordDurationAvgNsCopy + durationNs) / totalRecordsReadCopy;
        this.totalRecordsRead = totalRecordsReadCopy;
    }

    void onReadRecordHit() {
        this.onReadRecordHit(true);
    }

    void onReadRecordMiss() {
        this.onReadRecordHit(false);
    }

    private void onReadRecordHit(boolean hit) {
        double newReadRecordHitPercent;
        long readRecordHitsCopy = this.readRecordHits;
        long readRecordMissesCopy = this.readRecordMisses;
        if (hit) {
            ++readRecordHitsCopy;
        } else {
            ++readRecordMissesCopy;
        }
        this.readRecordHitPercent = newReadRecordHitPercent = (double)readRecordHitsCopy / (double)(readRecordHitsCopy + readRecordMissesCopy);
        this.readRecordMissesPercent = 100.0 - newReadRecordHitPercent;
        this.readRecordHits = readRecordHitsCopy;
        this.readRecordMisses = readRecordMissesCopy;
    }

    void onAllocationStall(long startNanos) {
        long durationNs = HybridLogImplMetrics.durationNsSince(startNanos);
        if (durationNs < this.allocationStallMinNs || this.allocationStallMinNs == -1L) {
            this.allocationStallMinNs = durationNs;
        }
        if (durationNs > this.allocationStallMaxNs) {
            this.allocationStallMaxNs = durationNs;
        }
        long totalAllocationStallsCopy = this.totalAllocationStalls + 1L;
        long allocationStallTotalNsCopy = this.allocationStallTotalNs + durationNs;
        this.allocationStallAvgNs = allocationStallTotalNsCopy / totalAllocationStallsCopy;
        this.totalAllocationStalls = totalAllocationStallsCopy;
        this.allocationStallTotalNs = allocationStallTotalNsCopy;
    }

    void onPaging(int newPage, int wastedBytes) {
        long pageOpenNanosCopy = this.pageOpenNanos;
        long newPageOpenNanos = System.nanoTime();
        long pagingFrequencyNs = newPageOpenNanos - pageOpenNanosCopy;
        this.pageOpenNanos = newPageOpenNanos;
        int totalPaging = newPage - 1;
        long totalPageAllocationsCopy = this.totalPageAllocations + 1L;
        this.totalPageAllocations = 0L;
        if (totalPaging == 0) {
            return;
        }
        this.recordPagingFrequency(totalPaging, pagingFrequencyNs);
        this.recordWaste(totalPaging, wastedBytes);
        this.recordPageAllocations(totalPaging, totalPageAllocationsCopy);
        this.pageCount = newPage;
    }

    private void recordPageAllocations(int totalPaging, long pageAllocations) {
        if (pageAllocations < this.allocationPerPageMin || this.allocationPerPageMin == -1L) {
            this.allocationPerPageMin = pageAllocations;
        }
        if (pageAllocations > this.allocationPerPageMax) {
            this.allocationPerPageMax = pageAllocations;
        }
        this.allocationPerPageAvg = ((long)(totalPaging - 1) * this.allocationPerPageAvg + pageAllocations) / (long)totalPaging;
    }

    private void recordWaste(long totalPagingLocal, int wastedBytes) {
        if ((long)wastedBytes < this.wastePagingMin || this.wastePagingMin == -1L) {
            this.wastePagingMin = wastedBytes;
        }
        if ((long)wastedBytes > this.wastePagingMax) {
            this.wastePagingMax = wastedBytes;
        }
        long wastePagingTotalLocal = this.wastePagingTotal + (long)wastedBytes;
        this.wastePagingAvg = wastePagingTotalLocal / totalPagingLocal;
        this.wastePagingTotal = wastePagingTotalLocal;
    }

    private void recordPagingFrequency(long totalPagingLocal, long pagingFrequencyNs) {
        if (pagingFrequencyNs < this.pagingFrequencyMin || this.pagingFrequencyMin == -1L) {
            this.pagingFrequencyMin = pagingFrequencyNs;
        }
        if (pagingFrequencyNs > this.pagingFrequencyMax) {
            this.pagingFrequencyMax = pagingFrequencyNs;
        }
        this.pagingFrequencyAvg = HybridLogImplMetrics.durationNsSince(this.initNanos) / totalPagingLocal;
    }

    public void onAllocation(int size, int paddedSize) {
        int wastedBytes = paddedSize - size;
        long totalAllocationsLocal = this.totalAllocations + 1L;
        this.recordAllocationSize(paddedSize, totalAllocationsLocal);
        this.recordAlignmentWaste(wastedBytes, totalAllocationsLocal);
        ++this.totalPageAllocations;
        this.totalAllocations = totalAllocationsLocal;
    }

    private void recordAllocationSize(int size, long totalAllocationsLocal) {
        if ((long)size < this.allocationSizeMin || this.allocationSizeMin == -1L) {
            this.allocationSizeMin = size;
        }
        if ((long)size > this.allocationSizeMax) {
            this.allocationSizeMax = size;
        }
        long allocationSizeTotalLocal = this.allocationSizeTotal + (long)size;
        this.allocationSizeAvg = allocationSizeTotalLocal / totalAllocationsLocal;
        this.allocationSizeTotal = allocationSizeTotalLocal;
    }

    private void recordAlignmentWaste(int wastedBytes, long totalAllocationsLocal) {
        if ((long)wastedBytes < this.wasteAlignmentMin || this.wasteAlignmentMin == -1L) {
            this.wasteAlignmentMin = wastedBytes;
        }
        if ((long)wastedBytes > this.wasteAlignmentMax) {
            this.wasteAlignmentMax = wastedBytes;
        }
        this.wasteAlignmentTotal += (long)wastedBytes;
        this.wasteAlignmentAvg = this.wasteAlignmentTotal / totalAllocationsLocal;
    }

    public long getHybridLogLengthTotal() {
        return this.allocationSizeTotal + this.wastePagingTotal + this.pageCount * 8L;
    }
}

