/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.device.ChunkAccessor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.ImmutableOperation;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ReadChunkOperation
extends ImmutableOperation {
    protected final long logicalAddress;
    protected final ChunkAccessor chunkAccessor;

    ReadChunkOperation(int storeId, Device device, long logicalAddress, ChunkAccessor chunkAccessor) {
        super(storeId, device);
        this.logicalAddress = logicalAddress;
        this.chunkAccessor = chunkAccessor;
    }

    @Override
    public byte[] run(byte[] context) {
        return ReadChunkOperation.run0(this.getDevice(), context, this.logicalAddress, this.chunkAccessor);
    }

    LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    static byte[] run0(LocalStorageDevice device, byte[] context, long logicalAddress, ChunkAccessor chunkAccessor) {
        long filePos = device.getLogFileOffsetFromLogicalAddress(logicalAddress);
        HybridLogFileHandlePool handlePool = device.getHandlePool();
        HybridLogFileHandleProvider hybridLogHandleProvider = device.getHandleProvider();
        int fileno = device.segmentNoOf(logicalAddress);
        HybridLogFileHandle handle = handlePool.getHandle(fileno, hybridLogHandleProvider);
        byte[] buf = context;
        RandomAccessFile raf = handle.getRaf();
        try {
            raf.seek(filePos);
            int bytes = raf.read(buf);
            if (bytes < 4) {
                throw new DeviceException(String.format("Cannot read from device `%s`.", device.deviceName()));
            }
            int chunkLength = chunkAccessor.length(buf);
            int skipBytes = chunkAccessor.skipHeadingBytes();
            byte[] chunk = new byte[chunkLength];
            int payloadPart = buf.length - skipBytes;
            int copy = Math.min(payloadPart, chunkLength);
            System.arraycopy(buf, skipBytes, chunk, 0, copy);
            if (payloadPart >= chunkLength) {
                byte[] byArray = chunk;
                return byArray;
            }
            int rest = chunkLength - copy;
            bytes = raf.read(chunk, copy, rest);
            if (bytes < rest) {
                throw new DeviceException(String.format("Cannot read from device `%s`.", device.deviceName()));
            }
            byte[] byArray = chunk;
            return byArray;
        }
        catch (IOException ioe) {
            throw new DeviceException(ioe);
        }
        finally {
            handlePool.releaseHandle(handle);
        }
    }

    @Override
    public String toString() {
        return "ReadChunkOperation(" + this.storeId + ", " + this.device.deviceName() + ", " + this.logicalAddress + ")";
    }

    @Override
    public int getReadLength() {
        return -1;
    }
}

