/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.device.ChunkAccessor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.DeviceMetrics;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutor;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.RecordAccessor;
import com.hazelcast.internal.tstore.device.local.LocalStorageDeviceMetrics;
import com.hazelcast.internal.tstore.device.local.ReadChunkOperation;
import com.hazelcast.internal.tstore.device.local.ReadOperation;
import com.hazelcast.internal.tstore.device.local.ReadRecordOperation;
import com.hazelcast.internal.tstore.device.local.TruncateOperation;
import com.hazelcast.internal.tstore.device.local.WriteOperation;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

public class LocalStorageDevice
implements Device {
    public static final long LOG_FILE_MAX_SIZE_BYTES = 0x4000000L;
    private static final ILogger LOGGER = Logger.getLogger(LocalStorageDevice.class);
    private final HybridLogFileHandlePool handlePool;
    private final DeviceOperationExecutor operationExecutor;
    private final int storeId;
    private final int partitionId;
    private final LocalDeviceConfig deviceConfig;
    private final File storeDirPath;
    private final ConcurrentMap<Integer, Integer> fileNoToReadLocksCnt = new ConcurrentHashMap<Integer, Integer>();
    private final FilesNotSubmittedToCompactor filesNotSubmittedToCompactor = new FilesNotSubmittedToCompactor();
    private final PendingDeletedFiles pendingDeletedFiles;
    private final HybridLogFileHandleProvider handleProvider;
    private final TStoreUserId uid;
    private final CompactionStats compactionStats;
    private final StatsImpl stats;
    private final int readPageSize;
    private final int writePageSize;
    private final LocalStorageDeviceMetrics metrics = new LocalStorageDeviceMetrics();
    private final Map<Long, Compactor> inProgressCompactors = new ConcurrentHashMap<Long, Compactor>();
    private final AtomicLong compactorIdGenerator = new AtomicLong();

    public LocalStorageDevice(int storeId, TStoreUserId uid, LocalDeviceConfig deviceConfig, int writePageSize, File storeDirPath, HybridLogFileHandlePool handlePool, DeviceOperationExecutor operationExecutor, CompactionStats compactionStats, int partitionId, boolean cleanupFiles) {
        this.handlePool = handlePool;
        this.operationExecutor = operationExecutor;
        this.deviceConfig = deviceConfig;
        this.storeDirPath = storeDirPath;
        this.storeId = storeId;
        this.partitionId = partitionId;
        this.handleProvider = (storageId, fileno) -> this.getLogHandleFromFileno(fileno);
        this.uid = uid;
        this.compactionStats = compactionStats;
        this.readPageSize = deviceConfig.getBlockSize();
        this.writePageSize = writePageSize;
        if (cleanupFiles) {
            LocalStorageDevice.cleanupLogFiles(storeDirPath);
        }
        this.stats = new StatsImpl();
        this.pendingDeletedFiles = new PendingDeletedFiles(storeDirPath, this.metrics);
        compactionStats.registerDevice(this);
    }

    @Override
    public String deviceName() {
        return this.deviceConfig.getName();
    }

    @Override
    public String debugInfo() {
        return this.getClass().getSimpleName() + '\n' + "\t- Device name: " + this.deviceName() + '\n' + "\t- Store id: " + this.storeId + '\n' + "\t- Directory: " + this.storeDirPath.getAbsolutePath() + '\n' + "\t- Device page size: " + this.readPageSize;
    }

    @Override
    public CompletableFuture<Void> writeAsync(long logicalAddress, long physicalAddress, int writeLength) {
        assert (writeLength == this.writePageSize);
        assert (logicalAddress % (long)this.writePageSize == 0L);
        WriteOperation op = new WriteOperation(this.storeId, this, logicalAddress, physicalAddress, writeLength);
        return this.operationExecutor.submit(op);
    }

    @Override
    public CompletableFuture<byte[]> readAsync(long logicalAddress, int readLength) {
        ReadOperation op = new ReadOperation(this.storeId, this, logicalAddress, readLength);
        return this.operationExecutor.submit(op);
    }

    @Override
    public CompletableFuture<byte[]> readRecordAsync(long logicalAddress, RecordAccessor recordAccessor) {
        ReadRecordOperation op = new ReadRecordOperation(this.storeId, this, logicalAddress, recordAccessor);
        return this.operationExecutor.submit(op);
    }

    @Override
    public byte[] read(long logicalAddress, int readLength) {
        byte[] data = new byte[readLength];
        return ReadOperation.run0(this, data, logicalAddress, readLength);
    }

    @Override
    public void read(long logicalAddress, byte[] buf) {
        ReadOperation.run0(this, buf, logicalAddress, buf.length);
    }

    @Override
    public byte[] readRecord(long logicalAddress, RecordAccessor recordAccessor) {
        byte[] data = new byte[this.readPageSize];
        return ReadRecordOperation.run0(this, data, logicalAddress, recordAccessor);
    }

    @Override
    public byte[] readRecord(long logicalAddress, byte[] buf, RecordAccessor recordAccessor) {
        return ReadRecordOperation.run0(this, buf, logicalAddress, recordAccessor);
    }

    @Override
    public byte[] readChunk(long logicalAddress, byte[] buf, ChunkAccessor chunkAccessor) {
        return ReadChunkOperation.run0(this, buf, logicalAddress, chunkAccessor);
    }

    @Override
    public CompletableFuture<Void> truncateAsync(long oldestLogicalAddress) {
        int oldestFileno = this.segmentNoOf(oldestLogicalAddress);
        if (oldestFileno == 0) {
            return CompletableFuture.completedFuture(null);
        }
        TruncateOperation op = new TruncateOperation(this.storeId, this, 0, oldestFileno - 1);
        return this.operationExecutor.submit(op);
    }

    @Override
    public CompletableFuture<Void> truncateAsync(int segmentNo) {
        return this.truncateAsync(segmentNo, segmentNo);
    }

    private CompletableFuture<Void> truncateAsync(int fromSegmentNo, int toSegmentNoInclusive) {
        Invariants.lessThanOrEqual(fromSegmentNo, toSegmentNoInclusive);
        TruncateOperation op = new TruncateOperation(this.storeId, this, fromSegmentNo, toSegmentNoInclusive);
        return this.operationExecutor.submit(op);
    }

    @Override
    public void dispose() {
        this.handlePool.close();
        this.compactionStats.deRegisterDevice(this);
        LocalStorageDevice.cleanupLogFiles(this.storeDirPath);
    }

    @Override
    public long segmentFirstLogicalAddress(int segmentNo) {
        Invariants.nonNegative(segmentNo);
        return 0x4000000L * (long)segmentNo;
    }

    @Override
    public long segmentLastLogicalAddress(int segmentNo) {
        Invariants.nonNegative(segmentNo);
        return 0x4000000L * (long)(segmentNo + 1) - 1L;
    }

    @Override
    public boolean containsLogicalAddress(long logicalAddress) {
        Invariants.nonNegative(logicalAddress);
        return this.fileNoToReadLocksCnt.containsKey(this.segmentNoOf(logicalAddress));
    }

    @Override
    public boolean tryReadLock(int segmentNo) {
        return this.fileNoToReadLocksCnt.computeIfPresent(segmentNo, (fileNoAsKey, readLocksCnt) -> readLocksCnt + 1) != null;
    }

    @Override
    public void releaseReadLock(int segmentNo) {
        Integer newReadLocksCnt = this.fileNoToReadLocksCnt.computeIfPresent(segmentNo, (fileNoAsKey, readLocksCnt) -> readLocksCnt - 1);
        if (newReadLocksCnt == null) {
            this.pendingDeletedFiles.releaseReadLock(segmentNo);
        } else {
            Invariants.nonNegative(newReadLocksCnt, "read locks count on a file cannot be negative");
        }
    }

    @Override
    public Device.Stats stats() {
        return this.stats;
    }

    @Override
    public int nextSegmentForCompactionOrMinus1() {
        return this.filesNotSubmittedToCompactor.pollOrMinus1();
    }

    int peekNextSegmentForCompactionOrMinus1() {
        return this.filesNotSubmittedToCompactor.peekOrMinus1();
    }

    @Override
    public TStoreUserId userId() {
        return this.uid;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    HybridLogFileHandlePool getHandlePool() {
        return this.handlePool;
    }

    HybridLogFileHandleProvider getHandleProvider() {
        return this.handleProvider;
    }

    long getLogFileOffsetFromLogicalAddress(long logicalAddress) {
        return logicalAddress % 0x4000000L;
    }

    @Override
    public int segmentNoOf(long logicalAddress) {
        if (logicalAddress == Long.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(logicalAddress / 0x4000000L);
    }

    HybridLogFileHandle getLogHandleFromFileno(int fileno) {
        try {
            File file = this.getHybridLogFileFromFileno(fileno);
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            if (this.fileNoToReadLocksCnt.putIfAbsent(fileno, 0) == null) {
                this.filesNotSubmittedToCompactor.add(fileno);
                if (fileno > 0) {
                    this.compactionStats.onNewSegment();
                }
            }
            return new HybridLogFileHandle(file, raf, this.storeId, fileno);
        }
        catch (FileNotFoundException ioe) {
            throw new DeviceException(ioe);
        }
    }

    File getHybridLogFileFromFileno(int fileno) {
        return LocalStorageDevice.getFileFromFileno(this.storeDirPath, fileno);
    }

    static File getFileFromFileno(File dir, int fileno) {
        String name = LocalStorageDevice.getFileName(fileno);
        return new File(dir, name);
    }

    private static String getFileName(int fileno) {
        return String.format(Locale.ENGLISH, "hz_%010d.hl", fileno);
    }

    public void deleteLogFiles(int fromFileNo, int toFileNoInclusive) {
        for (int fileNo = fromFileNo; fileNo <= toFileNoInclusive; ++fileNo) {
            Integer lockState = (Integer)this.fileNoToReadLocksCnt.remove(fileNo);
            if (lockState == null) continue;
            this.pendingDeletedFiles.add(fileNo, lockState);
        }
    }

    @Override
    public void completePendingSegmentDeletes() {
        this.pendingDeletedFiles.deleteAll();
    }

    public Map<Integer, Integer> getFileNoToReadLocksCnt() {
        return this.pendingDeletedFiles.getFileNoToReadLocksCnt();
    }

    public int getGarbage(int fileNo) {
        return this.filesNotSubmittedToCompactor.fileNoToGarbageBytes.getOrDefault(fileNo, 0);
    }

    private static void cleanupLogFiles(File dirFile) {
        assert (dirFile.isDirectory());
        File[] files = dirFile.listFiles((dir, name) -> name.endsWith(".hl"));
        if (files == null) {
            throw new DeviceException("Cannot read from device by path: " + dirFile.getAbsolutePath());
        }
        for (File hlFile : files) {
            if (hlFile.delete()) continue;
            String msg = String.format("Failed to cleanup directory %s. Cannot delete hybrid log file %s.", dirFile.getAbsolutePath(), hlFile.getName());
            LOGGER.warning(msg);
            throw new DeviceException(msg);
        }
    }

    @Override
    public DeviceMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public long registerCompactor(Compactor compactor) {
        long id = this.compactorIdGenerator.incrementAndGet();
        this.inProgressCompactors.put(id, compactor);
        return id;
    }

    @Override
    public synchronized void deregisterCompactor(long id) {
        Compactor compactor = this.inProgressCompactors.remove(id);
        assert (compactor != null);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateCompactors() {
        for (Compactor compactor : this.inProgressCompactors.values()) {
            compactor.interrupt();
        }
        boolean interrupted = false;
        LocalStorageDevice localStorageDevice = this;
        synchronized (localStorageDevice) {
            while (!this.inProgressCompactors.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @ThreadSafe
    private static final class FilesNotSubmittedToCompactor {
        private static final AtomicIntegerFieldUpdater<FilesNotSubmittedToCompactor> NOT_TO_COMPACT;
        private final ConcurrentMap<Integer, Integer> fileNoToGarbageBytes = new ConcurrentHashMap<Integer, Integer>();
        private volatile int notToCompact;

        FilesNotSubmittedToCompactor() {
        }

        void add(int fileNo) {
            Integer oldVal = this.fileNoToGarbageBytes.putIfAbsent(fileNo, 0);
            Invariants.isNull(oldVal, "trying to register an already registered file with fileNo=" + fileNo);
            NOT_TO_COMPACT.getAndUpdate(this, v -> Math.max(v, fileNo));
        }

        boolean addGarbage(int fileNo, int bytes) {
            Integer garbage = this.fileNoToGarbageBytes.computeIfPresent(fileNo, (k, v) -> v + bytes < 0 ? Integer.MAX_VALUE : v + bytes);
            return garbage != null && (long)garbage.intValue() >= 0x2000000L;
        }

        int pollOrMinus1() {
            return this.getOrMinus1(true);
        }

        int peekOrMinus1() {
            return this.getOrMinus1(false);
        }

        private int getOrMinus1(boolean remove) {
            int fileNo;
            int excluded = NOT_TO_COMPACT.get(this);
            do {
                Map.Entry mostGarbage = null;
                for (Map.Entry e : this.fileNoToGarbageBytes.entrySet()) {
                    if ((Integer)e.getKey() == excluded || mostGarbage != null && (Integer)mostGarbage.getValue() >= (Integer)e.getValue()) continue;
                    mostGarbage = e;
                }
                if (mostGarbage == null) {
                    return -1;
                }
                fileNo = (Integer)mostGarbage.getKey();
            } while (remove && this.fileNoToGarbageBytes.remove(fileNo) == null);
            return fileNo;
        }

        static {
            Invariants.lessThanOrEqual(0x4000000L, Integer.MAX_VALUE);
            NOT_TO_COMPACT = AtomicIntegerFieldUpdater.newUpdater(FilesNotSubmittedToCompactor.class, "notToCompact");
        }
    }

    private class StatsImpl
    implements Device.Stats {
        private StatsImpl() {
        }

        @Override
        public void markRecordAsUnreachable(long logicalRecord, int recordLengthBytes) {
            Invariants.nonNegative(logicalRecord);
            Invariants.greaterThan(recordLengthBytes, 0);
            int fileNo = LocalStorageDevice.this.segmentNoOf(logicalRecord);
            boolean tooMuchGarbage = LocalStorageDevice.this.filesNotSubmittedToCompactor.addGarbage(fileNo, recordLengthBytes);
            if (tooMuchGarbage && !LocalStorageDevice.this.compactionStats.isAutomaticCompactionDisabled() && (fileNo = LocalStorageDevice.this.filesNotSubmittedToCompactor.pollOrMinus1()) != -1) {
                LocalStorageDevice.this.compactionStats.compactSegment(LocalStorageDevice.this.userId(), LocalStorageDevice.this.partitionId(), fileNo);
            }
        }
    }

    @ThreadSafe
    private static final class PendingDeletedFiles {
        private final ConcurrentMap<Integer, Integer> fileNoToReadLocksCnt = new ConcurrentHashMap<Integer, Integer>();
        private final File storeDirPath;
        private final LocalStorageDeviceMetrics metrics;

        PendingDeletedFiles(File storeDirPath, LocalStorageDeviceMetrics metrics) {
            this.storeDirPath = storeDirPath;
            this.metrics = metrics;
        }

        void add(int fileNo, int readLockCount) {
            this.fileNoToReadLocksCnt.merge(fileNo, readLockCount, Integer::sum);
        }

        void releaseReadLock(int fileNo) {
            int newReadLocksCnt = this.fileNoToReadLocksCnt.merge(fileNo, -1, Integer::sum);
            Invariants.nonNegative(newReadLocksCnt);
        }

        void deleteAll() {
            for (Map.Entry e : this.fileNoToReadLocksCnt.entrySet()) {
                int fileNo = (Integer)e.getKey();
                int readLockCnt = (Integer)e.getValue();
                if (readLockCnt != 0) continue;
                this.deleteLogFile(fileNo);
                this.fileNoToReadLocksCnt.remove(fileNo);
            }
        }

        public ConcurrentMap<Integer, Integer> getFileNoToReadLocksCnt() {
            return this.fileNoToReadLocksCnt;
        }

        private void deleteLogFile(int fileNo) {
            block4: {
                Path filePath = Paths.get(this.storeDirPath.getAbsolutePath(), LocalStorageDevice.getFileName(fileNo));
                if (Files.exists(filePath, new LinkOption[0])) {
                    try {
                        long fileSize = Files.size(filePath);
                        assert (fileSize <= 0x4000000L);
                        Files.delete(filePath);
                        this.metrics.onDelete(fileSize);
                    }
                    catch (IOException e) {
                        if (!Files.exists(filePath, new LinkOption[0])) break block4;
                        LOGGER.warning(String.format("Unable to delete hybrid log file %s", filePath));
                        LOGGER.warning(e);
                    }
                }
            }
        }
    }
}

