/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.Compactor;
import java.util.concurrent.FutureTask;

public class CompactorFutureTask
extends FutureTask<Void> {
    private final Compactor<?> compactor;

    public CompactorFutureTask(Compactor<?> compactor) {
        super(compactor::compact, null);
        this.compactor = compactor;
    }

    @Override
    public void run() {
        if (this.isDone()) {
            return;
        }
        this.compactor.init();
        try {
            super.run();
        }
        finally {
            this.compactor.after();
        }
    }

    void deregister() {
        this.compactor.deregister();
    }

    @Override
    public String toString() {
        return "CompactorFutureTask{compactor=" + this.compactor + '}';
    }

    boolean isInterrupted() {
        return this.compactor.isInterrupted();
    }

    boolean isRegistered() {
        return this.compactor.isRegistered();
    }
}

