/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataInput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.ByteArrayObjectDataInput;
import com.hazelcast.internal.serialization.impl.EnterpriseSerializationUtil;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

class EnterpriseByteArrayObjectDataInput
extends ByteArrayObjectDataInput
implements EnterpriseBufferObjectDataInput {
    private final EnterpriseSerializationService enterpriseSerializationService;

    EnterpriseByteArrayObjectDataInput(byte[] buffer, int offset, EnterpriseSerializationService service, ByteOrder byteOrder, boolean isCompatibility) {
        super(buffer, offset, service, byteOrder, isCompatibility);
        this.enterpriseSerializationService = service;
    }

    @Override
    public void copyToMemoryBlock(MemoryBlock memory, int offset, int length) throws IOException {
        if (this.pos + length > this.size) {
            throw new EOFException("Size: " + this.size + ", Position: " + this.pos + ", Length: " + length);
        }
        if (memory.size() < offset + length) {
            throw new IOException("Cannot write " + length + " bytes to " + memory);
        }
        memory.copyFrom(offset, this.data, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + this.pos, length);
        this.pos += length;
    }

    @Override
    public EnterpriseSerializationService getSerializationService() {
        return this.enterpriseSerializationService;
    }

    @Override
    public Data readData(DataType type) throws IOException {
        return EnterpriseSerializationUtil.readDataInternal(this, type, this.enterpriseSerializationService.getCurrentMemoryAllocator(), false);
    }

    @Override
    public Data tryReadData(DataType type) throws IOException {
        return EnterpriseSerializationUtil.readDataInternal(this, type, this.enterpriseSerializationService.getCurrentMemoryAllocator(), true);
    }
}

