/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

class TLSExecutor {
    private final Executor executor;

    TLSExecutor(Executor executor) {
        this.executor = Preconditions.checkNotNull(executor, "executor can't be null");
    }

    void executeHandshakeTasks(SSLEngine sslEngine, Channel channel) {
        List<Runnable> tasks = this.collectTasks(sslEngine);
        AtomicInteger remaining = new AtomicInteger(tasks.size());
        for (Runnable task : tasks) {
            this.executor.execute(new HandshakeTask(task, remaining, sslEngine, channel));
        }
    }

    void execute(Runnable task) {
        this.executor.execute(task);
    }

    private List<Runnable> collectTasks(SSLEngine sslEngine) {
        Runnable task;
        LinkedList<Runnable> tasks = new LinkedList<Runnable>();
        while ((task = sslEngine.getDelegatedTask()) != null) {
            tasks.add(task);
        }
        return tasks;
    }

    private static class HandshakeTask
    implements Runnable {
        private final Runnable task;
        private final AtomicInteger remaining;
        private final SSLEngine sslEngine;
        private final Channel channel;

        HandshakeTask(Runnable task, AtomicInteger remaining, SSLEngine sslEngine, Channel channel) {
            this.task = task;
            this.remaining = remaining;
            this.sslEngine = sslEngine;
            this.channel = channel;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Exception e) {
                ILogger logger = Logger.getLogger(HandshakeTask.class);
                logger.warning("Failed to execute handshake task for " + this.channel, e);
            }
            finally {
                this.onTaskCompletion();
            }
        }

        private void onTaskCompletion() {
            if (this.remaining.decrementAndGet() == 0) {
                if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.channel.outboundPipeline().wakeup();
                } else {
                    this.channel.inboundPipeline().wakeup();
                }
            }
        }
    }
}

