/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.nio.ssl.SSLEngineFactoryAdaptor;
import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.internal.nio.ssl.TLSExecutor;
import com.hazelcast.internal.nio.ssl.TLSHandshakeDecoder;
import com.hazelcast.internal.nio.ssl.TLSHandshakeEncoder;
import com.hazelcast.internal.util.JavaVersion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.OpenSSLEngineFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import io.netty.handler.ssl.OpenSsl;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public abstract class AbstractTLSChannelInitializer
implements ChannelInitializer {
    private final ILogger logger = Logger.getLogger(AbstractTLSChannelInitializer.class);
    private final SSLConfig sslConfig;
    private final SSLEngineFactory sslEngineFactory;
    private final String mutualAuthentication;
    private final TLSExecutor tlsExecutor;
    private final boolean validateIdentity;

    public AbstractTLSChannelInitializer(SSLConfig sslConfig, Executor tlsExecutor) {
        this.sslConfig = sslConfig;
        this.sslEngineFactory = this.loadSSLEngineFactory();
        this.tlsExecutor = new TLSExecutor(tlsExecutor);
        this.mutualAuthentication = SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "mutualAuthentication");
        this.validateIdentity = Boolean.parseBoolean(SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "validateIdentity"));
    }

    private SSLEngineFactory loadSSLEngineFactory() {
        Object implementation = this.sslConfig.getFactoryImplementation();
        try {
            String factoryClassName = this.sslConfig.getFactoryClassName();
            if (implementation == null && factoryClassName != null) {
                implementation = Class.forName(factoryClassName).newInstance();
            }
            if (implementation == null) {
                implementation = this.loadDefaultImplementation();
            }
            if (implementation instanceof SSLContextFactory) {
                implementation = new SSLEngineFactoryAdaptor((SSLContextFactory)implementation);
            }
            SSLEngineFactory sslEngineFactory = (SSLEngineFactory)implementation;
            sslEngineFactory.init(this.sslConfig.getProperties(), this.forClient());
            return sslEngineFactory;
        }
        catch (HazelcastException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidConfigurationException("Error while loading SSL engine for: " + this.getClass().getSimpleName(), e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Error while loading SSL engine for: " + this.getClass().getSimpleName(), e);
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    private Object loadDefaultImplementation() {
        if (JavaVersion.isAtLeast(JavaVersion.JAVA_11)) {
            this.logger.info("Java " + JavaVersion.CURRENT_VERSION.getMajorVersion() + " detected, default for above Java 11 upwards is " + BasicSSLContextFactory.class.getName());
            return new BasicSSLContextFactory();
        }
        if (this.isOpenSSLAvailable()) {
            this.logger.info("OpenSSL capability detected, defaulting to " + OpenSSLEngineFactory.class.getName());
            return new OpenSSLEngineFactory();
        }
        this.logger.info("OpenSSL capability not detected, defaulting to " + BasicSSLContextFactory.class.getName());
        return new BasicSSLContextFactory();
    }

    private boolean isOpenSSLAvailable() {
        try {
            return OpenSsl.isAvailable();
        }
        catch (NoClassDefFoundError e) {
            this.logger.fine("Netty OpenSSL support has not been found on the classpath.");
            return false;
        }
    }

    protected abstract boolean forClient();

    @Override
    public final void initChannel(Channel channel) throws Exception {
        this.configChannel(channel);
        Address peerAddress = (Address)channel.attributeMap().get(Address.class);
        SSLEngine sslEngine = this.sslEngineFactory.create(channel.isClientMode(), peerAddress);
        if (this.validateIdentity && peerAddress != null) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
        }
        if ("REQUIRED".equals(this.mutualAuthentication)) {
            sslEngine.setNeedClientAuth(true);
        } else if ("OPTIONAL".equals(this.mutualAuthentication)) {
            sslEngine.setWantClientAuth(true);
        }
        sslEngine.beginHandshake();
        channel.inboundPipeline().addLast(new TLSHandshakeDecoder(sslEngine, this.tlsExecutor, channel.attributeMap()));
        this.initPipeline(channel);
        channel.outboundPipeline().addLast(new TLSHandshakeEncoder(sslEngine, this.tlsExecutor, channel.attributeMap()));
    }

    protected abstract void initPipeline(Channel var1);

    protected abstract void configChannel(Channel var1);
}

