/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.nearcache.HDNearCacheRecordStore;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.nearcache.impl.nativememory.SegmentedHDNearCacheRecordStore;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.logging.Level;

public class HDNearCache<K, V>
extends DefaultNearCache<K, V> {
    private static final AtomicLongFieldUpdater<HDNearCache> FORCED_EVICTION_COUNT = AtomicLongFieldUpdater.newUpdater(HDNearCache.class, "forcedEvictionCount");
    private final NearCacheManager nearCacheManager;
    private final ILogger logger = Logger.getLogger(this.getClass());
    private HazelcastMemoryManager memoryManager;
    private volatile long forcedEvictionCount;

    public HDNearCache(String name, NearCacheConfig nearCacheConfig, NearCacheManager nearCacheManager, EnterpriseSerializationService serializationService, TaskScheduler scheduler, ClassLoader classLoader, HazelcastProperties properties) {
        this(name, nearCacheConfig, nearCacheManager, null, serializationService, scheduler, classLoader, properties);
    }

    public HDNearCache(String name, NearCacheConfig nearCacheConfig, NearCacheManager nearCacheManager, NearCacheRecordStore<K, V> nearCacheRecordStore, SerializationService serializationService, TaskScheduler scheduler, ClassLoader classLoader, HazelcastProperties properties) {
        super(name, nearCacheConfig, nearCacheRecordStore, serializationService, scheduler, classLoader, properties);
        this.nearCacheManager = Preconditions.checkNotNull(nearCacheManager, "nearCacheManager cannot be null");
    }

    @Override
    public void initialize() {
        super.initialize();
        this.memoryManager = this.createMemoryManager();
        this.nearCacheRecordStore.initialize();
    }

    private HazelcastMemoryManager createMemoryManager() {
        if (this.nearCacheRecordStore instanceof HDNearCacheRecordStore) {
            return ((HDNearCacheRecordStore)this.nearCacheRecordStore).getMemoryManager();
        }
        return null;
    }

    @Override
    protected NearCacheRecordStore<K, V> createNearCacheRecordStore(String name, NearCacheConfig nearCacheConfig) {
        if (InMemoryFormat.NATIVE == nearCacheConfig.getInMemoryFormat()) {
            EnterpriseSerializationService ss = (EnterpriseSerializationService)this.serializationService;
            return new SegmentedHDNearCacheRecordStore(name, nearCacheConfig, ss, this.classLoader);
        }
        return super.createNearCacheRecordStore(name, nearCacheConfig);
    }

    @Override
    public void put(K key, Data keyData, V value, Data valueData) {
        long reservationId = this.tryReserveForUpdate(key, keyData, NearCache.UpdateSemantic.READ_UPDATE);
        if (reservationId != -1L) {
            this.tryPublishReserved(key, value, reservationId, false);
        }
    }

    @Override
    public long tryReserveForUpdate(K key, Data keyData, NearCache.UpdateSemantic updateSemantic) {
        assert (key != null) : "key cannot be null";
        boolean memoryCompacted = false;
        while (true) {
            try {
                return super.tryReserveForUpdate(key, keyData, updateSemantic);
            }
            catch (NativeOutOfMemoryError error) {
                EmptyStatement.ignore(error);
                if (this.evictRecordStores()) continue;
                if (memoryCompacted) {
                    this.handleNativeOOME(key);
                } else {
                    this.compactMemory();
                    memoryCompacted = true;
                    if (!Thread.currentThread().isInterrupted()) continue;
                }
                return -1L;
            }
            break;
        }
    }

    @Override
    public V tryPublishReserved(K key, V value, long reservationId, boolean deserialize) {
        assert (key != null) : "key cannot be null";
        boolean memoryCompacted = false;
        while (true) {
            try {
                return super.tryPublishReserved(key, value, reservationId, deserialize);
            }
            catch (NativeOutOfMemoryError error) {
                EmptyStatement.ignore(error);
                if (this.evictRecordStores()) continue;
                if (memoryCompacted) {
                    this.handleNativeOOME(key);
                } else {
                    this.compactMemory();
                    memoryCompacted = true;
                    if (!Thread.currentThread().isInterrupted()) continue;
                }
                return null;
            }
            break;
        }
    }

    private void handleNativeOOME(K key) {
        super.invalidate(key);
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(String.format("Entry can not be put into Near Cache for this time: nearCacheName=%s", this.name));
        }
    }

    private boolean evictRecordStores() {
        if (HDNearCache.evict(this.nearCacheRecordStore)) {
            this.incrementForceEvictionCount();
            return true;
        }
        Collection<NearCache> nearCacheList = this.nearCacheManager.listAllNearCaches();
        for (NearCache nearCache : nearCacheList) {
            if (nearCache == this || !(nearCache instanceof HDNearCache)) continue;
            HDNearCache hdNearCache = (HDNearCache)nearCache;
            if (!HDNearCache.evict(hdNearCache.nearCacheRecordStore)) continue;
            hdNearCache.incrementForceEvictionCount();
            return true;
        }
        return false;
    }

    private void incrementForceEvictionCount() {
        FORCED_EVICTION_COUNT.incrementAndGet(this);
    }

    long getForcedEvictionCount() {
        return this.forcedEvictionCount;
    }

    private static boolean evict(NearCacheRecordStore nearCacheRecordStore) {
        if (nearCacheRecordStore.size() == 0) {
            return false;
        }
        return nearCacheRecordStore.doEviction(true);
    }

    private void compactMemory() {
        assert (this.memoryManager != null) : "memoryManager cannot be null";
        this.memoryManager.compact();
    }

    void setMemoryManager(HazelcastMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public String toString() {
        return "HDNearCache{" + super.toString() + "} ";
    }
}

