/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.rest;

import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.monitor.LicenseInfo;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseType;

public class LicenseInfoImpl
implements LicenseInfo {
    private long expirationTime;
    private int maxNodeCount;
    private LicenseType type;
    private String companyName;
    private String ownerEmail;
    private String keyHash;

    public LicenseInfoImpl() {
    }

    public LicenseInfoImpl(License license) {
        this(license.getExpiryDate().getTime(), license.getAllowedNumberOfNodes(), license.getType(), license.getCompanyName(), license.getEmail(), license.computeKeyHash());
    }

    private LicenseInfoImpl(long expirationTime, int maxNodeCount, LicenseType type, String companyName, String ownerEmail, String keyHash) {
        this.expirationTime = expirationTime;
        this.maxNodeCount = maxNodeCount;
        this.type = type;
        this.companyName = companyName;
        this.ownerEmail = ownerEmail;
        this.keyHash = keyHash;
    }

    @Override
    public LicenseType getType() {
        return this.type;
    }

    @Override
    public int getMaxNodeCountAllowed() {
        return this.maxNodeCount;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    @Override
    public String getCompanyName() {
        return this.companyName;
    }

    @Override
    public String getKeyHash() {
        return this.keyHash;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("expiryDate", this.expirationTime);
        json.add("maxNodeCount", this.maxNodeCount);
        json.add("type", this.type != null ? this.type.getCode() : -1);
        json.add("companyName", this.companyName);
        json.add("ownerEmail", this.ownerEmail);
        json.add("keyHash", this.keyHash);
        return json;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.expirationTime = json.getLong("expiryDate", 0L);
        this.maxNodeCount = json.getInt("maxNodeCount", 0);
        this.ownerEmail = json.getString("ownerEmail", null);
        this.companyName = json.getString("companyName", null);
        this.type = LicenseType.getLicenseType(json.getInt("type", LicenseType.getDefault().getCode()));
        this.keyHash = json.getString("keyHash", null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseInfoImpl that = (LicenseInfoImpl)o;
        if (this.expirationTime != that.expirationTime) {
            return false;
        }
        if (this.maxNodeCount != that.maxNodeCount) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) {
            return false;
        }
        if (this.ownerEmail != null ? !this.ownerEmail.equals(that.ownerEmail) : that.ownerEmail != null) {
            return false;
        }
        return this.keyHash != null ? this.keyHash.equals(that.keyHash) : that.keyHash == null;
    }

    public int hashCode() {
        int result = (int)(this.expirationTime ^ this.expirationTime >>> 32);
        result = 31 * result + this.maxNodeCount;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.ownerEmail != null ? this.ownerEmail.hashCode() : 0);
        result = 31 * result + (this.keyHash != null ? this.keyHash.hashCode() : 0);
        return result;
    }
}

