/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.rest;

import com.hazelcast.config.Config;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpBadRequestException;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.HttpPostCommandProcessor;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.license.exception.InvalidLicenseException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.CompletionException;

public class EnterpriseHttpPostCommandProcessor
extends HttpPostCommandProcessor {
    EnterpriseHttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    protected void handleSetLicense(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 3);
        try {
            String licenseKey = params[2];
            ConfigurationService configurationService = (ConfigurationService)this.getNode().getNodeEngine().getService("hz:configurationService");
            configurationService.updateLicense(licenseKey);
            this.prepareResponse(cmd, this.responseOnSetLicenseSuccess());
        }
        catch (CompletionException completionException) {
            Throwable cause = completionException.getCause();
            if (cause instanceof InvalidLicenseException) {
                throw new HttpBadRequestException(cause.getMessage());
            }
            throw cause;
        }
    }

    @Override
    protected void handleConfigReload(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        ConfigurationService configurationService = (ConfigurationService)this.getNode().getNodeEngine().getService("hz:configurationService");
        ConfigUpdateResult configUpdateResult = configurationService.update();
        JsonObject response = EnterpriseHttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "Configuration Reload successfully finished.");
        response.add("result", configUpdateResult.toJson());
        this.prepareResponse(command, response);
    }

    @Override
    protected void handleConfigUpdate(HttpPostCommand command) throws UnsupportedEncodingException {
        String[] params = this.decodeParamsAndAuthenticate(command, 3);
        String newConfigAsString = params[2];
        Config from = Config.loadFromString(newConfigAsString);
        ConfigurationService configurationService = (ConfigurationService)this.getNode().getNodeEngine().getService("hz:configurationService");
        ConfigUpdateResult configUpdateResult = configurationService.update(from);
        JsonObject response = EnterpriseHttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "Configuration Update successfully finished.");
        response.add("result", configUpdateResult.toJson());
        this.prepareResponse(command, response);
    }

    private JsonObject responseOnSetLicenseSuccess() {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.getNode().getNodeExtension();
        LicenseInfoImpl licenseInfo = new LicenseInfoImpl(nodeExtension.getLicense());
        JsonObject jsonResponse = EnterpriseHttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", EnterpriseNodeExtension.licenseChangeMessage(this.getNode().getConfig().getDynamicConfigurationConfig().isPersistenceEnabled()));
        jsonResponse.add("licenseInfo", licenseInfo.toJson());
        return jsonResponse;
    }
}

