/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.management;

import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.management.TimedMemberStateFactory;
import com.hazelcast.internal.monitor.impl.MemberStateImpl;
import com.hazelcast.internal.monitor.impl.management.EnterpriseNodeStateImpl;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.security.impl.WeakSecretError;
import com.hazelcast.security.impl.WeakSecretsConfigChecker;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnterpriseTimedMemberStateFactory
extends TimedMemberStateFactory {
    private final Map<String, List<String>> weakSecretsReport = new HashMap<String, List<String>>();

    public EnterpriseTimedMemberStateFactory(HazelcastInstanceImpl instance) {
        super(instance);
        this.evaluateWeakSecretsInConfig();
    }

    @Override
    protected void createNodeState(MemberStateImpl memberState) {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.instance.node.getNodeExtension();
        LicenseInfoImpl licenseInfo = new LicenseInfoImpl(nodeExtension.getLicense());
        Node node = this.instance.node;
        ClusterServiceImpl cluster = this.instance.node.clusterService;
        EnterpriseNodeStateImpl nodeState = new EnterpriseNodeStateImpl(cluster.getClusterState(), node.getState(), cluster.getClusterVersion(), node.getVersion(), this.weakSecretsReport, licenseInfo);
        memberState.setNodeState(nodeState);
    }

    private void evaluateWeakSecretsInConfig() {
        WeakSecretsConfigChecker weakSecretsConfigChecker = new WeakSecretsConfigChecker(this.instance.getConfig());
        Map<String, EnumSet<WeakSecretError>> report = weakSecretsConfigChecker.evaluate();
        for (Map.Entry<String, EnumSet<WeakSecretError>> entry : report.entrySet()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (WeakSecretError error : entry.getValue()) {
                errors.add(error.name());
            }
            this.weakSecretsReport.put(entry.getKey(), errors);
        }
    }
}

