/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.merkletree;

import com.hazelcast.internal.merkletree.ComparisonState;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;

public class MerkleTreeComparisonProcessor {
    private ComparisonState comparisonState = ComparisonState.IN_PROGRESS;
    private int[] lastLocalNodeValues;
    private int[] lastRemoteNodeValues;
    private int[] difference;
    private int localTreeLevel = -1;
    private int remoteTreeLevel = -1;

    public void processLocalNodeValues(int[] localNodeValues) {
        assert (this.comparisonState == ComparisonState.IN_PROGRESS);
        this.lastLocalNodeValues = localNodeValues;
        this.localTreeLevel = MerkleTreeComparisonProcessor.extractTreeLevel(localNodeValues, this.localTreeLevel);
        if (localNodeValues == null) {
            this.difference = this.localize(this.lastRemoteNodeValues, this.localTreeLevel);
            this.comparisonState = ComparisonState.FINISHED;
        } else if (this.localTreeLevel == this.remoteTreeLevel) {
            this.difference = localNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        } else if (localNodeValues.length == 0) {
            this.difference = localNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        }
    }

    public void processRemoteNodeValues(int[] remoteNodeValues) {
        assert (this.comparisonState == ComparisonState.IN_PROGRESS);
        this.lastRemoteNodeValues = remoteNodeValues;
        if (remoteNodeValues == null) {
            this.difference = this.lastLocalNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
            return;
        }
        this.remoteTreeLevel = MerkleTreeComparisonProcessor.extractTreeLevel(remoteNodeValues, this.remoteTreeLevel);
        if (this.localTreeLevel == this.remoteTreeLevel) {
            this.difference = remoteNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        } else if (remoteNodeValues.length == 0) {
            this.difference = remoteNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        }
    }

    public boolean isComparisonFinished() {
        return this.comparisonState == ComparisonState.FINISHED;
    }

    public int[] getDifference() {
        return this.difference;
    }

    ComparisonState getComparisonState() {
        return this.comparisonState;
    }

    private static int extractTreeLevel(int[] nodeValues, int currentLevel) {
        if (nodeValues != null && nodeValues.length > 0) {
            return MerkleTreeUtil.getLevelOfNode(nodeValues[0]);
        }
        return currentLevel;
    }

    private int[] localize(int[] nodeValues, int leafLevel) {
        if (nodeValues != null && nodeValues.length > 0 && MerkleTreeUtil.getLevelOfNode(nodeValues[0]) > leafLevel) {
            int[] localizedNodeValues = new int[nodeValues.length / 2];
            int localizedIdx = 0;
            for (int i = 0; i < nodeValues.length; i += 4) {
                int leftChildOrder = nodeValues[i];
                int leftChildHash = nodeValues[i + 1];
                int rightChildHash = nodeValues[i + 3];
                int parentChildOrder = MerkleTreeUtil.getParentOrder(leftChildOrder);
                localizedNodeValues[localizedIdx++] = parentChildOrder;
                localizedNodeValues[localizedIdx++] = MerkleTreeUtil.sumHash(leftChildHash, rightChildHash);
            }
            return localizedNodeValues;
        }
        return nodeValues;
    }
}

