/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.JVMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ChunkFileOut
implements Closeable {
    public static final int FSYNC_INTERVAL_BYTES = 0x400000;
    public final File file;
    final FileOutputStream fileOut;
    private final ByteBuffer buf = ByteBuffer.allocate(65536);
    private final FileChannel fileChan;
    private final MutatorCatchup mc;
    private boolean needsFsyncBeforeClosing;
    private int flushedDataSize;
    private int flushedSizeAtLastCatchup;

    public ChunkFileOut(File file, MutatorCatchup mc) throws FileNotFoundException {
        this.file = file;
        this.fileOut = new FileOutputStream(file);
        this.fileChan = this.fileOut.getChannel();
        this.mc = mc;
    }

    public void writeValueRecord(long seq, long prefix, byte[] key, byte[] value) {
        this.putValueHeader(seq, prefix, key.length, value.length);
        this.write(key, 0, key.length);
        this.write(value, 0, value.length);
    }

    public void writeValueRecord(Record r, long keyPrefix, ByteBuffer keyBuf, ByteBuffer valBuf) {
        long seq = r.liveSeq();
        int keySize = keyBuf.remaining();
        int valSize = valBuf.remaining();
        assert (ChunkFileOut.bufferSizeValid(r, keySize, valSize));
        if (this.flushedDataSize == 0 && this.buf.position() == 0) {
            this.mc.catchupNow();
        }
        try {
            this.putValueHeader(seq, keyPrefix, keySize, valSize);
            this.write(keyBuf);
            this.write(valBuf);
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    public void writeTombstone(long seq, long prefix, byte[] key) {
        this.ensureRoomForHeader(20);
        this.buf.putLong(seq);
        this.buf.putLong(prefix);
        this.buf.putInt(key.length);
        this.write(key, 0, key.length);
    }

    public void writeTombstone(long seq, long prefix, ByteBuffer keyBuf, int keySize) {
        this.ensureRoomForHeader(20);
        this.buf.putLong(seq);
        this.buf.putLong(prefix);
        this.buf.putInt(keySize);
        this.write(keyBuf, keySize);
    }

    public void writeTombstone(long seq, long prefix, InputStream keyStream, int keySize) {
        this.ensureRoomForHeader(20);
        this.buf.putLong(seq);
        this.buf.putLong(prefix);
        this.buf.putInt(keySize);
        this.write(keyStream, keySize);
    }

    public void flagForFsyncOnClose(boolean fsyncOnClose) {
        this.needsFsyncBeforeClosing |= fsyncOnClose;
    }

    public void fsync() {
        this.flushLocalBuffer();
        this.fileFsync();
        this.needsFsyncBeforeClosing = false;
    }

    @Override
    public void close() {
        this.flushLocalBuffer();
        try {
            this.prepareClose(this.fileOut);
            if (this.needsFsyncBeforeClosing) {
                this.fileFsync();
            }
            this.fileOut.close();
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    private void putValueHeader(long seq, long prefix, int keySize, int valueSize) {
        this.ensureRoomForHeader(24);
        this.buf.putLong(seq);
        this.buf.putLong(prefix);
        this.buf.putInt(keySize);
        this.buf.putInt(valueSize);
    }

    private void write(ByteBuffer buf) throws IOException {
        this.write(buf.array(), buf.arrayOffset(), buf.remaining());
    }

    private void write(byte[] b, int offset, int length) {
        int position = offset;
        try {
            int remaining;
            int written;
            for (remaining = length; remaining > 65536; remaining -= written) {
                this.flushLocalBuffer();
                written = this.doWrite(this.fileOut, b, position, 65536);
                this.flushedDataSize += written;
                position += written;
            }
            while (remaining > 0) {
                int transferredCount = Math.min(65536 - this.buf.position(), remaining);
                this.buf.put(b, position, transferredCount);
                position += transferredCount;
                remaining -= transferredCount;
                this.ensureBufHasRoom();
            }
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    private void write(InputStream in, int length) {
        try {
            int transferredCount;
            int remaining;
            int written;
            for (remaining = length; remaining > 65536; remaining -= written) {
                this.flushLocalBuffer();
                written = this.doWrite(this.fileOut, in, 65536);
                this.flushedDataSize += written;
            }
            while (remaining > 0 && -1 != (transferredCount = in.read(this.buf.array(), this.buf.position(), Math.min(this.buf.remaining(), remaining)))) {
                JVMUtil.upcast(this.buf).position(this.buf.position() + transferredCount);
                remaining -= transferredCount;
                this.ensureBufHasRoom();
            }
            if (remaining > 0) {
                throw new HotRestartException("Partial write: " + (length - remaining) + ", requested: " + length + ", chunk file: " + this.file);
            }
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    private void write(ByteBuffer from, int length) {
        int limitBackup = from.limit();
        int localLimit = from.position() + length;
        JVMUtil.upcast(from).limit(localLimit);
        try {
            while (from.remaining() > 65536) {
                this.flushLocalBuffer();
                JVMUtil.upcast(from).limit(from.position() + 65536);
                this.flushedDataSize += this.doWrite(this.fileChan, from);
                JVMUtil.upcast(from).limit(localLimit);
                this.catchup();
            }
            if (from.remaining() > this.buf.remaining()) {
                JVMUtil.upcast(from).limit(from.position() + this.buf.remaining());
                this.buf.put(from);
                JVMUtil.upcast(from).limit(localLimit);
                this.ensureBufHasRoom();
            }
            this.buf.put(from);
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
        finally {
            JVMUtil.upcast(from).limit(limitBackup);
        }
    }

    private void ensureRoomForHeader(int headerSize) {
        if (this.buf.remaining() < headerSize) {
            this.flushLocalBuffer();
        }
    }

    private void ensureBufHasRoom() {
        if (this.buf.position() != 65536) {
            return;
        }
        try {
            this.flushedDataSize += this.doWrite(this.fileOut, this.buf.array(), 0, 65536);
            this.catchup();
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
        JVMUtil.upcast(this.buf).position(0);
    }

    private void flushLocalBuffer() {
        if (this.buf.position() == 0) {
            return;
        }
        JVMUtil.upcast(this.buf).flip();
        try {
            while (this.buf.hasRemaining()) {
                this.flushedDataSize += this.doWrite(this.fileChan, this.buf);
                this.catchup();
            }
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
        JVMUtil.upcast(this.buf).clear();
    }

    private void catchup() {
        if (this.mc != null) {
            this.mc.catchupNow();
            if (this.flushedDataSize - this.flushedSizeAtLastCatchup >= 0x400000) {
                this.fileFsync();
                this.mc.catchupNow();
                this.flushedSizeAtLastCatchup = this.flushedDataSize;
            }
        }
    }

    private void fileFsync() {
        try {
            this.fileOut.getFD().sync();
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    private static boolean bufferSizeValid(Record r, int keyBufSize, int valBufSize) {
        assert (keyBufSize + valBufSize == r.payloadSize()) : String.format("Expected record size %,d doesn't match key %,d + value %,d = %,d", r.payloadSize(), keyBufSize, valBufSize, keyBufSize + valBufSize);
        return true;
    }

    protected int doWrite(FileChannel chan, ByteBuffer from) throws IOException {
        return chan.write(from);
    }

    protected int doWrite(FileOutputStream out, byte[] b, int off, int len) throws IOException {
        out.write(b, off, len);
        return len;
    }

    protected int doWrite(FileOutputStream out, InputStream in, int len) throws IOException {
        IOUtil.drainTo(in, out, len);
        return len;
    }

    protected void prepareClose(FileOutputStream out) throws IOException {
    }
}

