/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.tracker;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.Tracker;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMapBase;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerOnHeap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TrackerMapOnHeap
extends TrackerMapBase {
    private final Map<KeyHandle, Tracker> trackers = new HashMap<KeyHandle, Tracker>();

    @Override
    public Tracker putIfAbsent(KeyHandle kh, long chunkSeq, boolean isTombstone) {
        Tracker tr = this.trackers.get(kh);
        if (tr != null) {
            return tr;
        }
        this.trackers.put(kh, new TrackerOnHeap(chunkSeq, isTombstone));
        this.added(isTombstone);
        return null;
    }

    @Override
    public Tracker get(KeyHandle kh) {
        return this.trackers.get(kh);
    }

    @Override
    void doRemove(KeyHandle kh) {
        this.trackers.remove(kh);
    }

    @Override
    public long size() {
        return this.trackers.size();
    }

    @Override
    public TrackerMap.Cursor cursor() {
        return new HeapCursor();
    }

    @Override
    public void dispose() {
    }

    private class HeapCursor
    implements TrackerMap.Cursor {
        private final Iterator<Map.Entry<KeyHandle, Tracker>> iter;
        private Map.Entry<KeyHandle, Tracker> current;

        private HeapCursor() {
            this.iter = TrackerMapOnHeap.this.trackers.entrySet().iterator();
        }

        @Override
        public boolean advance() {
            if (!this.iter.hasNext()) {
                return false;
            }
            this.current = this.iter.next();
            return true;
        }

        @Override
        public KeyHandle asKeyHandle() {
            return this.toKeyHandle();
        }

        @Override
        public KeyHandle toKeyHandle() {
            return this.current.getKey();
        }

        @Override
        public Tracker asTracker() {
            return this.current.getValue();
        }
    }
}

