/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.tracker;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.Tracker;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.SwCounter;

public abstract class TrackerMapBase
implements TrackerMap {
    @Probe(name="liveValues", level=ProbeLevel.MANDATORY)
    public final SwCounter liveValues = SwCounter.newSwCounter();
    @Probe(name="liveTombstones", level=ProbeLevel.MANDATORY)
    public final SwCounter liveTombstones = SwCounter.newSwCounter();

    @Override
    public void removeLiveTombstone(KeyHandle kh) {
        this.liveTombstones.inc(-1L);
        this.doRemove(kh);
    }

    @Override
    public void removeIfDead(KeyHandle kh, Tracker tr) {
        if (!tr.isAlive()) {
            this.doRemove(kh);
        }
    }

    abstract void doRemove(KeyHandle var1);

    final void added(boolean isTombstone) {
        (isTombstone ? this.liveTombstones : this.liveValues).inc();
    }

    final void retired(boolean isTombstone) {
        (isTombstone ? this.liveTombstones : this.liveValues).inc(-1L);
    }

    final void replacedTombstoneWithValue() {
        this.liveTombstones.inc(-1L);
        this.liveValues.inc();
    }

    final void replacedValueWithTombstone() {
        this.liveValues.inc(-1L);
        this.liveTombstones.inc();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(1024);
        TrackerMap.Cursor c = this.cursor();
        while (c.advance()) {
            b.append(c.asKeyHandle()).append("->").append(c.asTracker()).append(' ');
        }
        return b.toString();
    }
}

