/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.hotrestart.impl.io.TombFileAccessor;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

final class TombEvacuator {
    private final Collection<StableTombChunk> srcChunks;
    @Inject
    private GcLogger logger;
    @Inject
    private GcHelper gcHelper;
    @Inject
    private MutatorCatchup mc;
    @Inject
    private ChunkManager chunkMgr;
    @Inject
    private EncryptionManager encryptionMgr;
    private Long2ObjectHashMap<WriteThroughChunk> survivorMap;
    private TrackerMap trackers;
    private WriteThroughTombChunk survivor;
    private long start;

    TombEvacuator(Collection<StableTombChunk> srcChunks) {
        this.srcChunks = srcChunks;
    }

    void evacuate() {
        this.chunkMgr.survivors = new Long2ObjectHashMap();
        this.survivorMap = this.chunkMgr.survivors;
        this.trackers = this.chunkMgr.trackers;
        for (StableTombChunk chunk : this.srcChunks) {
            this.evacuate(chunk);
        }
        if (this.survivor != null) {
            this.closeSurvivor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evacuate(StableTombChunk chunk) {
        TombFileAccessor tfa = new TombFileAccessor(this.gcHelper.stableChunkFile(chunk, false), this.encryptionMgr);
        int[] filePositions = chunk.initFilePosToKeyHandle();
        try {
            for (int filePos : filePositions) {
                KeyHandle kh = chunk.getLiveKeyHandle(filePos);
                if (kh == null) continue;
                this.ensureSurvivor();
                long posBefore = Record.positionInUnitsOfBufsize(this.survivor.size());
                boolean full = this.survivor.addStep1(tfa, filePos);
                this.survivor.addStep2(tfa.recordSeq(), tfa.keyPrefix(), kh, tfa.recordSize());
                this.trackers.get(kh).moveToChunk(this.survivor.seq);
                if (Record.positionInUnitsOfBufsize(this.survivor.size()) != posBefore) {
                    this.mc.catchupNow();
                }
                if (!full) continue;
                this.closeSurvivor();
            }
        }
        finally {
            tfa.close();
            chunk.disposeFilePosToKeyHandle();
        }
    }

    private void ensureSurvivor() {
        if (this.survivor != null) {
            return;
        }
        this.start = System.nanoTime();
        this.survivor = this.gcHelper.newWriteThroughTombChunk(".chunk.survivor");
        this.survivor.flagForFsyncOnClose(true);
        this.survivorMap.put(this.survivor.seq, (WriteThroughChunk)this.survivor);
    }

    private void closeSurvivor() {
        this.survivor.close();
        this.mc.catchupNow();
        this.logger.finest("Wrote tombstone chunk #%03x (%,d bytes) in %d ms", this.survivor.seq, this.survivor.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
        this.survivor = null;
        this.mc.catchupNow();
    }
}

