/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.encryption;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;

class HotRestartCipherInputStream
extends CipherInputStream {
    HotRestartCipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream, cipher);
    }

    @Override
    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        try {
            return super.read(bytes);
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        try {
            return super.read(bytes, off, len);
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return super.skip(n);
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return super.available();
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            super.reset();
        }
        catch (IOException e) {
            throw HotRestartCipherInputStream.convert(e);
        }
    }

    private static IOException convert(IOException e) {
        if (e.getCause() instanceof IllegalBlockSizeException) {
            return new EOFException();
        }
        return e;
    }
}

